/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.entities.GreaterDreadglareEntity;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.EntityRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class NecromancerAbilities {
    public static void effectNecromancerWinterborn(class_1657 player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWinterborn, (class_1309)player)) {
            double frostSpellPower = SpellPower.getSpellPower((SpellSchool)SpellSchools.FROST, (class_1309)player).baseValue();
            player.method_6092(new class_1293(EffectRegistry.SOULSHOCK, 220, (int)frostSpellPower, false, false, false));
        }
    }

    public static void effectNecromancerEnrage(class_1309 livingEntity, class_1657 player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationEnrage, (class_1309)player)) {
            class_238 box = HelperMethods.createBoxHeight((class_1297)livingEntity, 15);
            for (class_1297 entities : livingEntity.method_37908().method_8333((class_1297)livingEntity, box, class_1301.field_6157)) {
                class_6025 te;
                if (entities == null || !(entities instanceof class_6025) || HelperMethods.checkFriendlyFire((class_1309)(te = (class_6025)entities), player)) continue;
                HelperMethods.incrementStatusEffect((class_1309)te, class_1294.field_5910, 200, 1, 3);
                HelperMethods.incrementStatusEffect((class_1309)te, class_1294.field_5907, 200, 1, 3);
            }
            player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_VOICE_20, class_3419.field_15248, 0.2f, 1.2f);
        }
    }

    public static void effectNecromancerDeathEssence(class_1657 player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDeathEssence, (class_1309)player)) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.BONEARMOR, 400, 1, 25);
        }
    }

    public static void effectDeathWarden(class_1657 player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDeathWarden, (class_1309)player)) {
            boolean success = false;
            class_238 box = HelperMethods.createBoxHeight((class_1297)player, 15);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_6025 te;
                if (entities == null || !(entities instanceof class_6025) || (te = (class_6025)entities).method_35057() == null || !te.method_35057().equals((Object)player)) continue;
                float healAmount = (float)((double)player.method_6063() * 0.15);
                player.method_6025(healAmount);
                entities.method_5643(player.method_48923().method_48830(), healAmount);
                HelperMethods.spawnWaistHeightParticles((class_3218)player.method_37908(), (class_2394)class_2398.field_11203, (class_1297)player, entities, 20);
                success = true;
            }
            if (success) {
                player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_VOICE_20, class_3419.field_15248, 0.2f, 1.3f);
            }
        }
    }

    public static void effectPlague(class_1657 player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationPlague, (class_1309)player) && player.field_6012 % 20 == 0 && player.method_6026() != null && HelperMethods.hasHarmfulStatusEffect((class_1309)player)) {
            class_238 box = HelperMethods.createBoxHeight((class_1297)player, 15);
            List<class_1297> validEntities = player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157).stream().filter(entities -> entities instanceof class_1321).filter(entities -> {
                class_1321 te = (class_1321)entities;
                return te.method_35057() != null && te.method_35057().equals((Object)player);
            }).toList();
            if (!validEntities.isEmpty()) {
                class_1297 randomEntity = validEntities.get(new Random().nextInt(validEntities.size()));
                HelperMethods.buffSteal((class_1309)randomEntity, (class_1309)player, true, true, true, false);
                HelperMethods.spawnWaistHeightParticles((class_3218)player.method_37908(), (class_2394)class_2398.field_11245, (class_1297)player, randomEntity, 12);
                player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_03, class_3419.field_15248, 0.1f, 1.5f);
            }
        }
    }

    public static void effectPestilence(class_1657 player, class_1309 minion, class_1309 target) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationPestilence, (class_1309)player)) {
            HelperMethods.buffSteal(target, minion, true, true, true, false);
        }
    }

    public static void effectDelightfulSuffering(class_1657 player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDelightfulSuffering, (class_1309)player)) {
            int duration = 800;
            ArrayList<class_1293> list = new ArrayList<class_1293>();
            list.add(0, new class_1293(class_1294.field_5903, duration, 0, false, false, true));
            list.add(1, new class_1293(class_1294.field_5909, duration, 0, false, false, true));
            list.add(2, new class_1293(class_1294.field_5920, duration, 0, false, false, true));
            list.add(3, new class_1293(class_1294.field_5901, duration, 0, false, false, true));
            list.add(4, new class_1293(class_1294.field_5901, duration, 0, false, false, true));
            if (!list.isEmpty()) {
                class_1291 chosenEffect = ((class_1293)list.get(player.method_6051().method_43048(4))).method_5579();
                HelperMethods.incrementStatusEffect((class_1309)player, chosenEffect, duration, 1, 2);
            }
        }
    }

    public static void effectEndlessServitude(class_1657 player, class_1321 minion) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationEndlessServitude, (class_1309)player)) {
            int chanceThreshold = Math.min(21 + HelperMethods.countHarmfulStatusEffects((class_1309)minion) * 5, 60);
            int chance = minion.method_6051().method_43048(100);
            if (chance < chanceThreshold) {
                class_1299 entityType = minion.method_5864();
                NecromancerAbilities.summonMinion((class_1299<? extends class_1309>)entityType, player);
                player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_02, class_3419.field_15248, 0.2f, 1.0f);
            }
        }
    }

    public static void effectShadowCombust(class_1657 player, class_1321 minion) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationShadowCombust, (class_1309)player)) {
            int radius = 4;
            if (minion instanceof GreaterDreadglareEntity) {
                radius = 7;
            }
            class_238 box = HelperMethods.createBox((class_1297)minion, radius);
            minion.method_37908().method_8333((class_1297)minion, box, class_1301.field_6157).stream().filter(Objects::nonNull).filter(entity -> entity instanceof class_1309).forEach(entity -> {
                class_1309 le = (class_1309)entity;
                if (player != null && HelperMethods.checkFriendlyFire(le, player)) {
                    le.field_6008 = 0;
                    float damageMulti = 3.2f;
                    if (minion instanceof GreaterDreadglareEntity) {
                        damageMulti = 6.4f;
                    }
                    le.method_5643(player.method_37908().method_48963().method_48815((class_1297)player, (class_1297)player), (float)SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (class_1309)player).baseValue() * damageMulti);
                    HelperMethods.spawnWaistHeightParticles((class_3218)minion.method_37908(), (class_2394)class_2398.field_11251, (class_1297)minion, (class_1297)le, 8);
                    le.field_6008 = 0;
                }
            });
            if (player != null) {
                player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_03, class_3419.field_15248, 0.1f, 1.0f);
                player.method_37908().method_43129(null, (class_1297)player, class_3417.field_15152, class_3419.field_15248, 0.1f, 1.0f);
            }
            HelperMethods.spawnOrbitParticles((class_3218)minion.method_37908(), minion.method_19538(), (class_2394)class_2398.field_11236, 1.0, 2);
            HelperMethods.spawnOrbitParticles((class_3218)minion.method_37908(), minion.method_19538(), (class_2394)class_2398.field_23114, 2.0, 20);
            HelperMethods.spawnOrbitParticles((class_3218)minion.method_37908(), minion.method_19538(), (class_2394)class_2398.field_11251, radius, 20);
            if (minion.method_5805()) {
                minion.method_5643(minion.method_37908().method_48963().method_48815((class_1297)minion, (class_1297)minion), minion.method_6063());
            }
        }
    }

    public static int getMinionLimit(String necromancerTree, class_1657 player) {
        int count = 0;
        for (String skillRef : SkillReferencePosition.undeadLegionSkills) {
            if (!HelperMethods.isUnlocked(necromancerTree, skillRef, (class_1309)player)) continue;
            ++count;
        }
        return 1 + count;
    }

    public static boolean signatureNecromancerSummoningRitual(String necromancerTree, class_1657 player) {
        for (int i = 0; i < NecromancerAbilities.getMinionLimit(necromancerTree, player); ++i) {
            if (HelperMethods.isUnlocked(necromancerTree, SkillReferencePosition.necromancerSpecialisationGreaterDreadglare, (class_1309)player)) {
                NecromancerAbilities.summonMinion(EntityRegistry.GREATER_DREADGLARE, player);
                break;
            }
            if (HelperMethods.isUnlocked(necromancerTree, SkillReferencePosition.necromancerSpecialisationSummonWraith, (class_1309)player)) {
                int chance = player.method_6051().method_43048(100);
                if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWraithLegion, (class_1309)player)) {
                    chance = 5;
                }
                if (chance < 50) {
                    NecromancerAbilities.summonMinion(EntityRegistry.WRAITH, player);
                    continue;
                }
                NecromancerAbilities.summonMinion(EntityRegistry.DREADGLARE, player);
                continue;
            }
            NecromancerAbilities.summonMinion(EntityRegistry.DREADGLARE, player);
        }
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_VOICE_20, class_3419.field_15248, 0.3f, 1.0f);
        return true;
    }

    public static void summonMinion(class_1299<? extends class_1309> livingEntity, class_1657 player) {
        class_1309 minion = (class_1309)livingEntity.method_47821((class_3218)player.method_37908(), player.method_24515().method_10086(4).method_10079(player.method_5755(), 3), class_3730.field_16471);
        if (minion != null) {
            if (minion instanceof class_1321) {
                class_1321 tameableMinion = (class_1321)minion;
                tameableMinion.method_6170(player);
                tameableMinion.method_6173(true);
                tameableMinion.method_18408(player.method_24515().method_10086(3), 32);
                if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationShadowAura, (class_1309)player)) {
                    int amplifier = 0;
                    if (tameableMinion instanceof GreaterDreadglareEntity) {
                        amplifier = 3;
                    }
                    minion.method_6092(new class_1293(EffectRegistry.SHADOWAURA, 2400, amplifier, false, false, false));
                }
            }
            double attackDamageMultiplier = 1.2;
            if (minion instanceof GreaterDreadglareEntity) {
                attackDamageMultiplier = 3.0;
            }
            double healthMultiplier = NecromancerAbilities.getHealthMultiplier(livingEntity);
            NecromancerAbilities.setMinionAttributes(player, minion, attackDamageMultiplier, healthMultiplier);
        }
    }

    private static double getHealthMultiplier(class_1299<?> entityType) {
        if (entityType.equals(EntityRegistry.DREADGLARE)) {
            return 1.4;
        }
        if (entityType.equals(EntityRegistry.WRAITH)) {
            return 0.8;
        }
        if (entityType.equals(EntityRegistry.GREATER_DREADGLARE)) {
            return 4.8;
        }
        return 1.0;
    }

    private static void setMinionAttributes(class_1657 player, class_1309 minion, double attackDamageMultiplier, double healthMultiplier) {
        double attackDamage = 3.0 + attackDamageMultiplier * SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (class_1309)player).baseValue();
        class_1324 attackAttribute = minion.method_5996(class_5134.field_23721);
        if (attackAttribute != null) {
            attackAttribute.method_6192(attackDamage);
        }
        double maxHealth = 1.0 + healthMultiplier * player.method_26825(class_5134.field_23716);
        class_1324 healthAttribute = minion.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6192(maxHealth);
            minion.method_6025((float)maxHealth);
        }
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationNecroticFortification, (class_1309)player)) {
            double multiplier = 0.5;
            if (minion instanceof GreaterDreadglareEntity) {
                multiplier = 1.0;
            }
            double maxArmor = 1.0 + multiplier * player.method_26825(class_5134.field_23724);
            double maxArmorToughness = 1.0 + multiplier * player.method_26825(class_5134.field_23725);
            class_1324 armorAttribute = minion.method_5996(class_5134.field_23724);
            class_1324 armorToughnessAttribute = minion.method_5996(class_5134.field_23725);
            if (armorAttribute != null) {
                armorAttribute.method_6192(maxArmor);
            }
            if (armorToughnessAttribute != null) {
                armorToughnessAttribute.method_6192(maxArmorToughness);
            }
        }
    }
}

