/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.paladins.effect.Effects;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class CrusaderAbilities {
    public static void passiveCrusaderRetribution(class_1657 player, class_1309 attacker) {
        int retributionChance;
        int random = new Random().nextInt(100);
        if (random < (retributionChance = SimplySkills.crusaderConfig.passiveCrusaderRetributionChance)) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:paladins_judgement", 32, (class_1297)attacker, null);
        }
    }

    public static void passiveCrusaderExhaustiveRecovery(class_1657 player, class_1309 attacker) {
        int random = new Random().nextInt(100);
        int recoveryChance = SimplySkills.crusaderConfig.passiveCrusaderExhaustiveRecoveryChance;
        int exhaustStacks = SimplySkills.crusaderConfig.passiveCrusaderExhaustiveRecoveryExhaustionStacks - 1;
        if (random < recoveryChance) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:paladins_flash_heal", 32, (class_1297)player, null);
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.EXHAUSTION, 300, exhaustStacks, 99);
        }
    }

    public static void passiveCrusaderAegis(class_1657 player) {
        int frequency = SimplySkills.crusaderConfig.passiveCrusaderAegisFrequency;
        int stacksRemoved = SimplySkills.crusaderConfig.passiveCrusaderAegisStacksRemoved;
        if (player.method_6059(EffectRegistry.EXHAUSTION) && player.field_6012 % frequency == 0 && player.method_6112(EffectRegistry.EXHAUSTION).method_5578() > stacksRemoved) {
            HelperMethods.incrementStatusEffect((class_1309)player, Effects.DIVINE_PROTECTION, 200, 1, 5);
            HelperMethods.decrementStatusEffects((class_1309)player, EffectRegistry.EXHAUSTION, stacksRemoved);
        }
    }

    public static boolean signatureHeavensmithsCall(String crusaderSkillTree, class_1657 player) {
        class_2338 blockpos = null;
        class_1297 target = null;
        boolean success = false;
        int heavensmithsCallRange = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallRange;
        int duration = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDADuration;
        if (HelperMethods.getTargetedEntity((class_1297)player, heavensmithsCallRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, heavensmithsCallRange).method_24515();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getBlockLookingAt(player, heavensmithsCallRange);
        }
        if (blockpos != null) {
            class_1309 le;
            if (target instanceof class_1309 && !HelperMethods.checkFriendlyFire(le = (class_1309)target, player)) {
                target = null;
            }
            if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationDivineAdjudication, (class_1309)player)) {
                player.method_6092(new class_1293(EffectRegistry.DIVINEADJUDICATION, duration, 0, false, false, true));
            }
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:physical_heavensmiths_call", heavensmithsCallRange, target, blockpos);
            success = true;
        }
        return success;
    }

    public static void signatureHeavensmithsCallImpact(String crusaderSkillTree, List<class_1297> targets, class_2960 spellId, class_1657 player) {
        int tauntDuration = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallTauntMarkDuration;
        if (spellId != null && spellId.toString().equals("simplyskills:physical_heavensmiths_call")) {
            class_1297 target = targets.get(0);
            class_238 box = HelperMethods.createBox(target, 3);
            for (class_1297 entities : target.method_37908().method_8333(target, box, class_1301.field_6157)) {
                class_1309 le;
                if (!(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationHeavensmithsCallMark, (class_1309)player)) {
                    le.method_6092(new class_1293(EffectRegistry.DEATHMARK, tauntDuration));
                }
                if (!(le instanceof class_1308)) continue;
                class_1308 me = (class_1308)le;
                if (!HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationHeavensmithsCallTaunt, (class_1309)player)) continue;
                SimplyStatusEffectInstance tauntEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, tauntDuration, 0, false, false, true);
                tauntEffect.setSourceEntity((class_1309)player);
                me.method_6092((class_1293)tauntEffect);
            }
        }
    }

    public static boolean signatureCrusaderSacredOnslaught(String crusaderSkillTree, class_1657 player) {
        int divineProtectionDuration = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtDPDuration;
        int dashDuration = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtDashDuration;
        player.method_6092(new class_1293(EffectRegistry.SACREDONSLAUGHT, dashDuration, 0, false, false, true));
        if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationSacredOnslaughtDefend, (class_1309)player)) {
            player.method_6092(new class_1293(Effects.DIVINE_PROTECTION, divineProtectionDuration, 0, false, false, true));
            player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.SOUNDEFFECT15, class_3419.field_15248, 0.5f, 1.1f);
        }
        if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationSacredOnslaughtMighty, (class_1309)player)) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MIGHT, divineProtectionDuration, 3, 5);
        }
        return true;
    }

    public static boolean signatureCrusaderConsecration(String crusaderSkillTree, class_1657 player) {
        int consecrationExtendDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationExtendDuration;
        int consecrationDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationDuration;
        if (HelperMethods.isUnlocked(crusaderSkillTree, SkillReferencePosition.crusaderSpecialisationConsecrationDuration, (class_1309)player)) {
            consecrationDuration = SimplySkills.crusaderConfig.signatureCrusaderConsecrationDuration + consecrationExtendDuration;
        }
        player.method_6092(new class_1293(EffectRegistry.CONSECRATION, consecrationDuration, 0, false, false, true));
        return true;
    }

    public static void effectDivineAdjudication(class_1657 player) {
        int frequency = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAFrequency;
        if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationHeavensmithsCall, (class_1309)player) && player.method_6059(EffectRegistry.DIVINEADJUDICATION) && player.field_6012 % frequency == 0) {
            int chance = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAChance;
            int radius = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDARadius;
            int exhaustStacksRemoved = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAExhaustStacks;
            int mightDuration = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAMightDuration;
            int mightStacksMax = SimplySkills.crusaderConfig.signatureCrusaderHeavensmithsCallDAMightStacksMax - 1;
            String spellIdentifier = "simplyskills:paladins_judgement";
            if (SignatureAbilities.castSpellEngineAOE(player, spellIdentifier, radius, chance, true)) {
                if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationHeavensmithsCallExhaust, (class_1309)player)) {
                    HelperMethods.decrementStatusEffects((class_1309)player, EffectRegistry.EXHAUSTION, exhaustStacksRemoved);
                }
                if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationHeavensmithsCallMighty, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MIGHT, mightDuration, 1, mightStacksMax);
                }
            }
        }
    }
}

