/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.SkillsAPI;
import net.spell_engine.internals.SpellRegistry;
import net.spell_power.api.SpellSchool;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AbilityEffects;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.ClericAbilities;
import net.sweenus.simplyskills.abilities.CrusaderAbilities;
import net.sweenus.simplyskills.abilities.InitiateAbilities;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.abilities.ProminenceAbilities;
import net.sweenus.simplyskills.abilities.SpellbladeAbilities;
import net.sweenus.simplyskills.abilities.WayfarerAbilities;
import net.sweenus.simplyskills.abilities.WizardAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.items.GraciousManuscript;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.ItemRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.jetbrains.annotations.Nullable;

public class AbilityLogic {
    public static boolean skillTreeUnlockManager(class_1657 player, String categoryID) {
        if (HelperMethods.stringContainsAny(categoryID, SimplySkills.getSpecialisations())) {
            if (SimplySkills.generalConfig.removeUnlockRestrictions || player.method_6047().method_7909() instanceof GraciousManuscript) {
                return false;
            }
            List<String> specialisationList = SimplySkills.getSpecialisationsAsArray();
            for (String s : specialisationList) {
                if (!categoryID.contains(s)) continue;
                for (Category value : SkillsAPI.streamUnlockedCategories((class_3222)((class_3222)player))::iterator) {
                    if (!HelperMethods.stringContainsAny(value.getId().toString(), SimplySkills.getSpecialisations())) continue;
                    return true;
                }
            }
            if (categoryID.contains("simplyskills:wizard") && !HelperMethods.isUnlocked("simplyskills:wizard", null, (class_1309)player)) {
                if (SimplySkills.wizardConfig.enableWizardSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:berserker") && !HelperMethods.isUnlocked("simplyskills:berserker", null, (class_1309)player)) {
                if (SimplySkills.berserkerConfig.enableBerserkerSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:rogue") && !HelperMethods.isUnlocked("simplyskills:rogue", null, (class_1309)player)) {
                if (SimplySkills.rogueConfig.enableRogueSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:ranger") && !HelperMethods.isUnlocked("simplyskills:ranger", null, (class_1309)player)) {
                if (SimplySkills.rangerConfig.enableRangerSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:spellblade") && !HelperMethods.isUnlocked("simplyskills:spellblade", null, (class_1309)player)) {
                if (SimplySkills.spellbladeConfig.enableSpellbladeSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:crusader") && !HelperMethods.isUnlocked("simplyskills:crusader", null, (class_1309)player)) {
                if (!FabricLoader.getInstance().isModLoaded("paladins")) {
                    return true;
                }
                if (SimplySkills.crusaderConfig.enableCrusaderSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:cleric") && !HelperMethods.isUnlocked("simplyskills:cleric", null, (class_1309)player)) {
                if (!FabricLoader.getInstance().isModLoaded("paladins")) {
                    return true;
                }
                if (SimplySkills.clericConfig.enableClericSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:necromancer") && !HelperMethods.isUnlocked("simplyskills:necromancer", null, (class_1309)player)) {
                if (SimplySkills.necromancerConfig.enableNecromancerSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.method_43496((class_2561)class_2561.method_43471((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:ascendancy") && !HelperMethods.isUnlocked("simplyskills:ascendancy", null, (class_1309)player) && SimplySkills.generalConfig.enableAscendancy) {
                AbilityLogic.playUnlockSound(player);
                return false;
            }
        }
        return false;
    }

    static void playUnlockSound(class_1657 player) {
        if (player.method_6047().method_7909() != ItemRegistry.GRACIOUSMANUSCRIPT) {
            player.method_37908().method_43129(null, (class_1297)player, class_3417.field_15195, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static void performJunctionLogic(class_3222 player, String skillId, class_2960 categoryId) {
        ArrayList<String> sapphire = new ArrayList<String>();
        sapphire.add(SkillReferencePosition.sapphire_portal_1);
        sapphire.add(SkillReferencePosition.sapphire_portal_2);
        ArrayList<String> ruby = new ArrayList<String>();
        ruby.add(SkillReferencePosition.ruby_portal_1);
        ruby.add(SkillReferencePosition.ruby_portal_2);
        for (String s : sapphire) {
            if (!skillId.equals(s) || !HelperMethods.isUnlocked(categoryId.toString(), s, (class_1309)player)) continue;
            for (String su : sapphire) {
                if (HelperMethods.isUnlocked(categoryId.toString(), su, (class_1309)player)) continue;
                ((Skill)((Category)SkillsAPI.getCategory((class_2960)categoryId).get()).getSkill(su).get()).unlock(player);
            }
        }
        for (String s : ruby) {
            if (!skillId.equals(s) || !HelperMethods.isUnlocked(categoryId.toString(), s, (class_1309)player)) continue;
            for (String su : ruby) {
                if (HelperMethods.isUnlocked(categoryId.toString(), su, (class_1309)player)) continue;
                ((Skill)((Category)SkillsAPI.getCategory((class_2960)categoryId).get()).getSkill(su).get()).unlock(player);
            }
        }
    }

    public static void performTagEffects(class_1657 player, String tags) {
        if (tags.contains("magic")) {
            // empty if block
        }
        if (tags.contains("physical")) {
            // empty if block
        }
        if (tags.contains("arrow")) {
            // empty if block
        }
        if (tags.contains("arcane")) {
            // empty if block
        }
    }

    public static void onSpellCastEffects(class_1657 player, @Nullable List<class_1297> targets, @Nullable class_2960 spellId, @Nullable Set<? extends SpellSchool> schools) {
        SpellSchool school = null;
        if (spellId != null) {
            school = SpellRegistry.getSpell((class_2960)spellId).school;
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateEmpower, (class_1309)player) || FabricLoader.getInstance().isModLoaded("prominent") && HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.initiateEmpower, (class_1309)player)) {
            InitiateAbilities.passiveInitiateEmpower(player, school, schools);
        }
        if (player.method_6059(EffectRegistry.STEALTH)) {
            WayfarerAbilities.passiveWayfarerBreakStealth(null, player, false, false);
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateWhisperedWizardry, (class_1309)player)) {
                HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.SPELLFORGED, 80, 1, 5);
            }
        } else if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateSpellcloak, (class_1309)player) && !player.method_6059(EffectRegistry.REVEALED)) {
            player.method_6092(new class_1293(EffectRegistry.STEALTH, 40, 0, false, false, true));
        }
        if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
            SimplySwordsGemEffects.spellshield(player);
            SimplySwordsGemEffects.spellStandard(player);
        }
        if ((HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpellEcho, (class_1309)player) || AscendancyAbilities.magicCircleEffect(player)) && targets != null) {
            WizardAbilities.passiveWizardSpellEcho(player, targets);
        }
        if (HelperMethods.isUnlocked("simplyskills:spellblade", SkillReferencePosition.spellbladeWeaponExpert, (class_1309)player)) {
            SpellbladeAbilities.effectSpellbladeWeaponExpert(player);
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateOverload, (class_1309)player)) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.OVERLOAD, 160, 1, 9);
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateEldritchEnfeeblement, (class_1309)player) && targets != null) {
            InitiateAbilities.passiveInitiateEldritchEnfeeblement(player, targets);
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiatePerilousPrecision, (class_1309)player) && targets != null) {
            InitiateAbilities.passiveInitiatePerilousPrecision(player, targets);
        }
        NecromancerAbilities.effectDelightfulSuffering(player);
        if (spellId != null) {
            if (FabricLoader.getInstance().isModLoaded("prominent")) {
                ProminenceAbilities.focusEffect(player, spellId);
            }
            if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericMutualMending, (class_1309)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                ClericAbilities.passiveClericMutualMending(player, spellId, targets);
            }
            if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericHealingWard, (class_1309)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                ClericAbilities.passiveClericHealingWard(player, targets, spellId);
            }
            if (school.id.toString().contains("physical_melee")) {
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerQuickfire, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MARKSMANSHIP, 40, 1, 6);
                }
                AbilityEffects.effectRangerElementalArrows(player);
            }
            CrusaderAbilities.signatureHeavensmithsCallImpact("simplyskills:crusader", targets, spellId, player);
        }
    }
}

