/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.entity;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentFactory;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.PlayerComponent;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.internal.base.LazyDispatcher;
import dev.onyxstudios.cca.internal.base.QualifiedComponentFactory;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentPluginBase;
import dev.onyxstudios.cca.internal.entity.CardinalEntityInternals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class StaticEntityComponentPlugin
extends LazyDispatcher
implements EntityComponentFactoryRegistry {
    public static final StaticEntityComponentPlugin INSTANCE = new StaticEntityComponentPlugin();
    private final List<PredicatedComponentFactory<?>> dynamicFactories = new ArrayList();
    private final Map<Class<? extends Entity>, Map<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<? extends Entity, ?>>>> componentFactories = new HashMap();

    private StaticEntityComponentPlugin() {
        super("instantiating an entity");
    }

    private static String getSuffix(Class<?> entityClass) {
        String simpleName = entityClass.getSimpleName();
        return String.format("EntityImpl_%s_%s", simpleName, Integer.toHexString(entityClass.getName().hashCode()));
    }

    public boolean requiresStaticFactory(Class<? extends Entity> entityClass) {
        this.ensureInitialized();
        for (PredicatedComponentFactory<?> dynamicFactory : this.dynamicFactories) {
            dynamicFactory.tryRegister(entityClass);
        }
        return entityClass == Entity.class || this.componentFactories.containsKey(entityClass);
    }

    public ComponentContainer.Factory<Entity> buildDedicatedFactory(Class<? extends Entity> entityClass) {
        this.ensureInitialized();
        LinkedHashMap compiled = new LinkedHashMap(this.componentFactories.getOrDefault(entityClass, Collections.emptyMap()));
        for (Class<? extends Entity> type = entityClass; type != Entity.class; type = type.getSuperclass()) {
            this.componentFactories.getOrDefault(type, Collections.emptyMap()).forEach(compiled::putIfAbsent);
        }
        ComponentContainer.Factory.Builder builder = ComponentContainer.Factory.builder(Entity.class).factoryNameSuffix(StaticEntityComponentPlugin.getSuffix(entityClass));
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<? extends Entity, ?>>> entry : compiled.entrySet()) {
            this.addToBuilder((ComponentContainer.Factory.Builder<Entity>)builder, entry);
        }
        return builder.build();
    }

    private <C extends Component> void addToBuilder(ComponentContainer.Factory.Builder<Entity> builder, Map.Entry<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<? extends Entity, ?>>> entry) {
        ComponentKey<?> key = entry.getKey();
        ComponentFactory factory = (ComponentFactory)entry.getValue().factory();
        Class impl = entry.getValue().impl();
        builder.component(key, impl, factory, entry.getValue().dependencies());
    }

    protected void init() {
        StaticComponentPluginBase.processInitializers((Collection)StaticComponentPluginBase.getComponentEntrypoints((String)"cardinal-components-entity", EntityComponentInitializer.class), initializer -> initializer.registerEntityComponentFactories(this));
    }

    @Override
    public <C extends Component, E extends Entity> void registerFor(Class<E> target, ComponentKey<C> type, ComponentFactory<E, ? extends C> factory) {
        this.checkLoading(EntityComponentFactoryRegistry.class, "register");
        this.register0(target, type, new QualifiedComponentFactory(factory, type.getComponentClass(), Set.of()));
    }

    @Override
    public <C extends Component> void registerFor(Predicate<Class<? extends Entity>> test, ComponentKey<C> type, ComponentFactory<Entity, C> factory) {
        this.dynamicFactories.add(new PredicatedComponentFactory<C>(test, type, new QualifiedComponentFactory(factory, type.getComponentClass(), Set.of())));
    }

    @Override
    public <C extends Component, E extends Entity> EntityComponentFactoryRegistry.Registration<C, E> beginRegistration(Class<E> target, ComponentKey<C> key) {
        return new RegistrationImpl<C, E>(target, key);
    }

    @Override
    public <C extends PlayerComponent<? super C>> void registerForPlayers(ComponentKey<? super C> key, ComponentFactory<Player, C> factory) {
        this.registerForPlayers(key, factory, CardinalEntityInternals.DEFAULT_COPY_STRATEGY);
    }

    @Override
    public <C extends Component, P extends C> void registerForPlayers(ComponentKey<C> key, ComponentFactory<Player, P> factory, RespawnCopyStrategy<? super P> respawnStrategy) {
        this.registerFor(Player.class, key, factory);
        CardinalEntityInternals.registerRespawnCopyStrat(key, respawnStrategy);
    }

    private <C extends Component, F extends C, E extends Entity> void register0(Class<? extends E> target, ComponentKey<? super C> key, QualifiedComponentFactory<ComponentFactory<E, F>> factory) {
        Map specializedMap = this.componentFactories.computeIfAbsent(target, t -> new LinkedHashMap());
        QualifiedComponentFactory previousFactory = (QualifiedComponentFactory)specializedMap.get(key);
        if (previousFactory != null) {
            throw new StaticComponentLoadingException("Duplicate factory declarations for " + key.getId() + " on " + target + ": " + factory + " and " + previousFactory);
        }
        QualifiedComponentFactory<ComponentFactory<E, F>> factory1 = factory;
        specializedMap.put(key, factory1);
        QualifiedComponentFactory.checkNoDependencyCycles((Map)specializedMap);
    }

    private final class PredicatedComponentFactory<C extends Component> {
        private final Predicate<Class<? extends Entity>> predicate;
        private final ComponentKey<? super C> type;
        private final QualifiedComponentFactory<ComponentFactory<Entity, C>> factory;

        public PredicatedComponentFactory(Predicate<Class<? extends Entity>> predicate, ComponentKey<? super C> type, QualifiedComponentFactory<ComponentFactory<Entity, C>> factory) {
            this.type = type;
            this.factory = factory;
            this.predicate = predicate;
        }

        public void tryRegister(Class<? extends Entity> clazz) {
            if (this.predicate.test(clazz)) {
                StaticEntityComponentPlugin.this.register0(clazz, this.type, this.factory);
            }
        }
    }

    private final class RegistrationImpl<C extends Component, E extends Entity>
    implements EntityComponentFactoryRegistry.Registration<C, E> {
        private final Class<E> target;
        private final ComponentKey<? super C> key;
        private final Set<ComponentKey<?>> dependencies;
        private Class<C> componentClass;
        private Predicate<Class<? extends E>> test;

        RegistrationImpl(Class<E> target, ComponentKey<C> key) {
            this.target = target;
            this.componentClass = key.getComponentClass();
            this.dependencies = new LinkedHashSet();
            this.test = null;
            this.key = key;
        }

        @Override
        public EntityComponentFactoryRegistry.Registration<C, E> filter(Predicate<Class<? extends E>> test) {
            this.test = this.test == null ? test : this.test.and(test);
            return this;
        }

        @Override
        public EntityComponentFactoryRegistry.Registration<C, E> after(ComponentKey<?> dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        @Override
        public <I extends C> EntityComponentFactoryRegistry.Registration<I, E> impl(Class<I> impl) {
            RegistrationImpl ret = this;
            ret.componentClass = impl;
            return ret;
        }

        @Override
        public EntityComponentFactoryRegistry.Registration<C, E> respawnStrategy(RespawnCopyStrategy<? super C> strategy) {
            CardinalEntityInternals.registerRespawnCopyStrat(this.key, strategy);
            return this;
        }

        @Override
        public void end(ComponentFactory<E, C> factory) {
            StaticEntityComponentPlugin.this.checkLoading(EntityComponentFactoryRegistry.Registration.class, "end");
            if (this.test == null) {
                StaticEntityComponentPlugin.this.register0(this.target, this.key, new QualifiedComponentFactory(factory, this.componentClass, this.dependencies));
            } else {
                StaticEntityComponentPlugin.this.dynamicFactories.add(new PredicatedComponentFactory<C>(c -> this.target.isAssignableFrom((Class<?>)c) && this.test.test(c.asSubclass(this.target)), this.key, new QualifiedComponentFactory(entity -> factory.createComponent((Object)((Entity)this.target.cast(entity))), this.componentClass, this.dependencies)));
            }
        }
    }
}

