/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.entity;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.api.v3.entity.PlayerComponent;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.internal.entity.StaticEntityComponentPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;

public final class CardinalEntityInternals {
    public static final RespawnCopyStrategy<Component> DEFAULT_COPY_STRATEGY = CardinalEntityInternals::defaultCopyStrategy;
    private static final Map<Class<? extends Entity>, ComponentContainer.Factory<Entity>> entityContainerFactories = new HashMap<Class<? extends Entity>, ComponentContainer.Factory<Entity>>();
    private static final Map<ComponentKey<?>, RespawnCopyStrategy<?>> respawnCopyStrategies = new HashMap();
    private static final Object factoryMutex = new Object();

    private CardinalEntityInternals() {
        throw new AssertionError();
    }

    public static ComponentContainer createEntityComponentContainer(Entity entity) {
        Class<?> entityClass = entity.getClass();
        return Objects.requireNonNullElseGet(entityContainerFactories.get(entityClass), () -> CardinalEntityInternals.getEntityFactory(entityClass)).createContainer((Object)entity);
    }

    private static synchronized ComponentContainer.Factory<Entity> getEntityFactory(Class<? extends Entity> entityClass) {
        ComponentContainer.Factory<Entity> factory;
        ComponentContainer.Factory<Entity> existing = entityContainerFactories.get(entityClass);
        if (existing != null) {
            return existing;
        }
        if (StaticEntityComponentPlugin.INSTANCE.requiresStaticFactory(entityClass)) {
            factory = StaticEntityComponentPlugin.INSTANCE.buildDedicatedFactory(entityClass);
        } else {
            Class<? extends Entity> superclass = entityClass.getSuperclass();
            assert (Entity.class.isAssignableFrom(superclass)) : "requiresStaticFactory returned false on Entity?";
            factory = CardinalEntityInternals.getEntityFactory(superclass);
        }
        entityContainerFactories.put(entityClass, factory);
        return factory;
    }

    public static <C extends Component> void registerRespawnCopyStrat(ComponentKey<? super C> type, RespawnCopyStrategy<? super C> strategy) {
        respawnCopyStrategies.put(type, strategy);
    }

    public static <C extends Component> RespawnCopyStrategy<? super C> getRespawnCopyStrategy(ComponentKey<C> type) {
        return respawnCopyStrategies.getOrDefault(type, DEFAULT_COPY_STRATEGY);
    }

    private static void defaultCopyStrategy(Component from, Component to, boolean lossless, boolean keepInventory, boolean sameCharacter) {
        if (to instanceof PlayerComponent) {
            CardinalEntityInternals.playerComponentCopy(from, (PlayerComponent)to, lossless, keepInventory, sameCharacter);
        } else {
            RespawnCopyStrategy.LOSSLESS_ONLY.copyForRespawn(from, to, lossless, keepInventory, sameCharacter);
        }
    }

    private static <C extends Component> void playerComponentCopy(Component from, PlayerComponent<C> to, boolean lossless, boolean keepInventory, boolean sameCharacter) {
        if (to.shouldCopyForRespawn(lossless, keepInventory, sameCharacter)) {
            to.copyForRespawn(from, lossless, keepInventory, sameCharacter);
        }
    }

    public static <C extends Component> void copyAsCopyable(Component from, CopyableComponent<C> to) {
        to.copyFrom(from);
    }
}

