/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class ChestData
extends SavedData {
    private String key;
    private BlockPos pos;
    private ResourceKey<Level> dimension;
    private UUID uuid;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();
    private NonNullList<ItemStack> reference;
    private boolean custom;
    private boolean entity;
    private int size = -1;

    protected ChestData(String key) {
        this.key = key;
    }

    public static String ID(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public static Supplier<ChestData> ref_id(ResourceKey<Level> dimension, BlockPos pos, UUID id, NonNullList<ItemStack> base) {
        if (id == null) {
            throw new IllegalArgumentException("Can't create ChestData for custom container in dimension '" + dimension + "' at '" + pos + "' with a null id.");
        }
        return () -> {
            ChestData data = new ChestData(ChestData.ID(id));
            data.pos = pos;
            data.dimension = dimension;
            data.uuid = id;
            data.reference = base;
            data.custom = true;
            data.entity = false;
            if (data.reference == null) {
                throw new IllegalArgumentException("Inventory reference cannot be null.");
            }
            return data;
        };
    }

    public static Supplier<ChestData> id(ResourceKey<Level> dimension, BlockPos pos, UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("Can't create ChestData for container in dimension '" + dimension + "' at '" + pos + "' with a null id.");
        }
        return () -> {
            ChestData data = new ChestData(ChestData.ID(id));
            data.pos = pos;
            data.dimension = dimension;
            data.uuid = id;
            data.reference = null;
            data.custom = false;
            data.entity = false;
            return data;
        };
    }

    public static Supplier<ChestData> entity(ResourceKey<Level> dimension, BlockPos pos, UUID entityId) {
        if (entityId == null) {
            throw new IllegalArgumentException("Can't create ChestData for minecart in dimension '" + dimension + "' at '" + pos + "' with a null entityId.");
        }
        return () -> {
            ChestData data = new ChestData(ChestData.ID(entityId));
            data.pos = pos;
            data.dimension = dimension;
            data.uuid = entityId;
            data.entity = true;
            data.reference = null;
            data.custom = false;
            return data;
        };
    }

    public static Function<CompoundTag, ChestData> loadWrapper(UUID id, ResourceKey<Level> dimension, BlockPos position) {
        return tag -> {
            ChestData result = ChestData.load(tag);
            result.key = ChestData.ID(id);
            result.dimension = dimension;
            result.pos = position;
            return result;
        };
    }

    public static ChestData unwrap(ChestData data, UUID id, ResourceKey<Level> dimension, BlockPos position, int size) {
        data.key = ChestData.ID(id);
        data.dimension = dimension;
        data.pos = position;
        data.setSize(size);
        return data;
    }

    public static ChestData load(CompoundTag compound) {
        ChestData data = new ChestData(compound.m_128461_("key"));
        data.inventories.clear();
        data.pos = null;
        data.dimension = null;
        if (compound.m_128425_("position", 4)) {
            data.pos = BlockPos.m_122022_((long)compound.m_128454_("position"));
        } else if (compound.m_128425_("position", 10)) {
            data.pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("position"));
        }
        if (compound.m_128441_("dimension")) {
            data.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
        }
        boolean foundNewUUID = false;
        if (compound.m_128403_("uuid")) {
            data.uuid = compound.m_128342_("uuid");
            foundNewUUID = true;
        }
        boolean foundEntity = false;
        if (compound.m_128403_("entityId")) {
            if (data.uuid != null) {
                LootrAPI.LOG.error("Loaded an `entityId` from an already-migrated file: '" + data.key + "'");
            }
            data.uuid = compound.m_128342_("entityId");
            data.entity = true;
            foundEntity = true;
        }
        if (compound.m_128403_("tileId")) {
            if (data.uuid != null) {
                if (foundEntity && !foundNewUUID) {
                    LootrAPI.LOG.error("Loaded a `tileId` from an unmigrated file that also has `entityId`: '" + data.key + "'");
                } else if (foundEntity) {
                    LootrAPI.LOG.error("Loaded a `tileId` from an already-migrated file that also had an `entityId`: '" + data.key + "'");
                } else if (foundNewUUID) {
                    LootrAPI.LOG.error("Loaded a `tileId` from an already-migrated file: '" + data.key + "'");
                }
            }
            data.uuid = compound.m_128342_("tileId");
            data.entity = false;
        }
        if (compound.m_128441_("custom")) {
            data.custom = compound.m_128471_("custom");
        }
        if (compound.m_128441_("entity")) {
            data.entity = compound.m_128471_("entity");
        }
        if (compound.m_128403_("customId")) {
            LootrAPI.LOG.error("Loaded a `customId` from an old file when this field was never used. File was '" + data.key + "'");
            data.uuid = compound.m_128342_("customId");
            data.entity = false;
            data.custom = true;
        }
        if (compound.m_128441_("reference") && compound.m_128441_("referenceSize")) {
            int size;
            data.size = size = compound.m_128451_("referenceSize");
            data.reference = NonNullList.m_122780_((int)data.size, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("reference"), data.reference);
        }
        if (compound.m_128425_("size", 3)) {
            data.size = compound.m_128451_("size");
        } else if (!compound.m_128441_("referenceSize")) {
            LootrAPI.LOG.error("Loaded a data file with no size: '" + data.key + "' located in dimension '" + data.dimension + "' at '" + data.pos + "'. Sizes will be guessed and updated in future. This message will only appear once; if it occurs multiple times for the same location, please report on GitHub.");
        }
        ListTag compounds = compound.m_128437_("inventories", 10);
        if (data.size == -1) {
            int maxSlot = -1;
            for (int i = 0; i < compounds.size(); ++i) {
                CompoundTag thisTag = compounds.m_128728_(i);
                ListTag items = thisTag.m_128469_("chest").m_128437_("Items", 10);
                for (int j = 0; j < items.size(); ++j) {
                    CompoundTag itemTag = items.m_128728_(j);
                    int slot = itemTag.m_128445_("Slot") & 0xFF;
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
            }
            data.size = maxSlot % 9 == 0 ? maxSlot : maxSlot + (9 - maxSlot % 9);
        }
        for (int i = 0; i < compounds.size(); ++i) {
            CompoundTag thisTag = compounds.m_128728_(i);
            CompoundTag items = thisTag.m_128469_("chest");
            String name = thisTag.m_128461_("name");
            UUID uuid = thisTag.m_128342_("uuid");
            data.inventories.put(uuid, new SpecialChestInventory(data, items, name));
        }
        return data;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getKey() {
        return this.key;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        if (this.size == size) {
            return;
        }
        if (size < this.size) {
            throw new IllegalArgumentException("Cannot resize inventory associated with '" + this.getKey() + "' in dimension '" + this.getDimension() + "' at location '" + this.getPos() + "' to a smaller size.");
        }
        this.size = size;
        for (SpecialChestInventory inventory : this.inventories.values()) {
            inventory.resizeInventory(size);
        }
    }

    @Nullable
    public UUID getEntityId() {
        if (this.entity) {
            return this.uuid;
        }
        return null;
    }

    @Nullable
    public UUID getTileId() {
        if (!this.entity) {
            return this.uuid;
        }
        return null;
    }

    public boolean isEntity() {
        return this.entity;
    }

    public LootFiller customInventory() {
        return (player, inventory, table, seed) -> {
            for (int i = 0; i < this.reference.size(); ++i) {
                inventory.m_6836_(i, ((ItemStack)this.reference.get(i)).m_41777_());
            }
        };
    }

    public boolean clearInventory(UUID uuid) {
        return this.inventories.remove(uuid) != null;
    }

    @Nullable
    public SpecialChestInventory getInventory(ServerPlayer player) {
        return this.inventories.get(player.m_20148_());
    }

    public SpecialChestInventory createInventory(ServerPlayer player, LootFiller filler, IntSupplier sizeSupplier, Supplier<Component> displaySupplier, Supplier<ResourceLocation> tableSupplier, LongSupplier seedSupplier) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (level.m_46472_() != this.dimension) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return null;
            }
            level = server.m_129880_(this.dimension);
        }
        if (level == null) {
            return null;
        }
        NonNullList items = NonNullList.m_122780_((int)sizeSupplier.getAsInt(), (Object)ItemStack.f_41583_);
        SpecialChestInventory result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, displaySupplier.get());
        filler.unpackLootTable((Player)player, result, tableSupplier.get(), seedSupplier.getAsLong());
        this.inventories.put(player.m_20148_(), result);
        this.m_77762_();
        return result;
    }

    public SpecialChestInventory createInventory(ServerPlayer player, LootFiller filler, BaseContainerBlockEntity blockEntity, Supplier<ResourceLocation> tableSupplier, LongSupplier seedSupplier) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (level.m_46472_() != this.dimension) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return null;
            }
            level = server.m_129880_(this.dimension);
        }
        if (level == null) {
            return null;
        }
        NonNullList items = NonNullList.m_122780_((int)blockEntity.m_6643_(), (Object)ItemStack.f_41583_);
        SpecialChestInventory result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, blockEntity.m_5446_());
        filler.unpackLootTable((Player)player, result, tableSupplier.get(), seedSupplier.getAsLong());
        this.inventories.put(player.m_20148_(), result);
        this.m_77762_();
        return result;
    }

    public SpecialChestInventory createInventory(ServerPlayer player, LootFiller filler, @Nullable RandomizableContainerBlockEntity tile) {
        ResourceLocation lootTable;
        SpecialChestInventory result;
        ServerLevel world = (ServerLevel)player.m_9236_();
        long seed = -1L;
        if (this.entity) {
            Entity initial = world.m_8791_(this.uuid);
            if (!(initial instanceof LootrChestMinecartEntity)) {
                return null;
            }
            LootrChestMinecartEntity cart = (LootrChestMinecartEntity)initial;
            NonNullList items = NonNullList.m_122780_((int)cart.m_6643_(), (Object)ItemStack.f_41583_);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, cart.m_5446_());
            lootTable = cart.f_38204_;
        } else {
            if (tile == null) {
                return null;
            }
            lootTable = ((ILootBlockEntity)tile).getTable();
            NonNullList items = NonNullList.m_122780_((int)tile.m_6643_(), (Object)ItemStack.f_41583_);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, tile.m_5446_());
        }
        filler.unpackLootTable((Player)player, result, lootTable, seed);
        this.inventories.put(player.m_20148_(), result);
        this.m_77762_();
        return result;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (this.key != null) {
            compound.m_128359_("key", this.key);
        } else {
            LootrAPI.LOG.error("Attempted to save a data file with no key! How could this happen?" + this);
        }
        if (this.pos != null) {
            compound.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        } else {
            LootrAPI.LOG.error("Attempted to save a data file with no `position`: '" + this.key + "'");
        }
        if (this.dimension != null) {
            compound.m_128359_("dimension", this.dimension.m_135782_().toString());
        } else {
            LootrAPI.LOG.error("Attempted to save a data file with no `dimension`: '" + this.key + "'");
        }
        if (this.uuid == null) {
            throw new IllegalStateException("Attempted to save a data file with no `uuid`: '" + this.key + "'. Located in dimension '" + this.dimension + "' at '" + this.pos + "'. This is an unrecoverable error.");
        }
        compound.m_128362_("uuid", this.uuid);
        compound.m_128379_("custom", this.custom);
        compound.m_128379_("entity", this.entity);
        compound.m_128405_("size", this.size);
        if (this.reference != null) {
            compound.m_128405_("referenceSize", this.reference.size());
            compound.m_128365_("reference", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.reference, (boolean)true));
        }
        ListTag compounds = new ListTag();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            CompoundTag thisTag = new CompoundTag();
            thisTag.m_128362_("uuid", entry.getKey());
            thisTag.m_128365_("chest", (Tag)entry.getValue().writeItems());
            thisTag.m_128359_("name", entry.getValue().writeName());
            compounds.add((Object)thisTag);
        }
        compound.m_128365_("inventories", (Tag)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }

    public void m_77757_(File pFile) {
        if (this.m_77764_()) {
            pFile.getParentFile().mkdirs();
        }
        super.m_77757_(pFile);
    }
}

