/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public class DeskBlock<T extends BlockEntity>
extends IEEntityBlock<T> {
    private static final CachedShapesWithTransform<Boolean, Direction> SHAPES = CachedShapesWithTransform.createDirectional(b -> {
        double xMin = b != false ? 0.0 : 0.0625;
        double xMax = xMin + 0.9375;
        return ImmutableList.of((Object)new AABB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0), (Object)new AABB(xMin, 0.0, 0.0625, xMax, 0.8125, 0.9375));
    });
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f).m_60955_();
    public static final Property<Direction> FACING = IEProperties.FACING_HORIZONTAL;
    public static final Property<Boolean> DUMMY = IEProperties.MULTIBLOCKSLAVE;

    public DeskBlock(RegistryObject<BlockEntityType<T>> tileType, BlockBehaviour.Properties props) {
        super(tileType, props);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DUMMY, FACING, BlockStateProperties.f_61362_});
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction newFacing = rot.m_55954_((Direction)state.m_61143_(FACING));
        return (BlockState)state.m_61124_(FACING, (Comparable)newFacing);
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (mirrorIn == Mirror.NONE) {
            return state;
        }
        Direction oldFacing = (Direction)state.m_61143_(FACING);
        Direction newFacing = mirrorIn.m_54848_(oldFacing);
        boolean oldDummy = (Boolean)state.m_61143_(DUMMY);
        boolean newDummy = !oldDummy;
        return (BlockState)((BlockState)state.m_61124_(FACING, (Comparable)newFacing)).m_61124_(DUMMY, (Comparable)Boolean.valueOf(newDummy));
    }

    @Override
    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        BlockPos start = context.m_8083_();
        Direction tableFacing = PlacementLimitation.HORIZONTAL.getDirectionForPlacement(context);
        Direction dummyDir = DeskBlock.getDeskDummyOffset(context.m_43725_(), context.m_8083_(), tableFacing, context);
        return DeskBlock.areAllReplaceable(start, start.m_121945_(dummyDir), context);
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction updateSide, BlockState updatedState, LevelAccessor worldIn, BlockPos currentPos, BlockPos updatedPos) {
        Direction facing = (Direction)stateIn.m_61143_(FACING);
        boolean dummy = (Boolean)stateIn.m_61143_(DUMMY);
        BlockPos otherHalf = currentPos.m_5484_(facing.m_122427_(), dummy ? -1 : 1);
        BlockState otherState = worldIn.m_8055_(otherHalf);
        if (otherState.m_60734_() == this && otherState.m_61143_(FACING) == facing && (Boolean)otherState.m_61143_(DUMMY) == !dummy) {
            return stateIn;
        }
        for (Direction candidate : FACING.m_6908_()) {
            BlockPos otherHalf2;
            BlockState otherState2;
            if (candidate == facing || (otherState2 = worldIn.m_8055_(otherHalf2 = currentPos.m_5484_(candidate.m_122427_(), dummy ? -1 : 1))).m_60734_() != this || otherState2.m_61143_(FACING) != candidate || (Boolean)otherState2.m_61143_(DUMMY) != !dummy) continue;
            return (BlockState)stateIn.m_61124_(FACING, (Comparable)candidate);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static Direction getDeskDummyOffset(Level world, BlockPos pos, Direction facing, BlockPlaceContext ctx) {
        Direction dummyDir = facing.m_122434_() == Direction.Axis.X ? (ctx.m_43720_().f_82481_ < 0.5 ? Direction.NORTH : Direction.SOUTH) : (ctx.m_43720_().f_82479_ < 0.5 ? Direction.WEST : Direction.EAST);
        BlockPos dummyPos = pos.m_121945_(dummyDir);
        if (!world.m_8055_(dummyPos).m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)dummyPos, (Direction)dummyDir))) {
            dummyDir = dummyDir.m_122424_();
        }
        return dummyDir;
    }

    public static void placeDummies(BlockState state, Level world, BlockPos pos, BlockPlaceContext ctx) {
        boolean mirror;
        Direction facing = (Direction)state.m_61143_(FACING);
        Direction dummyDir = DeskBlock.getDeskDummyOffset(world, pos, facing, ctx);
        BlockPos dummyPos = pos.m_121945_(dummyDir);
        boolean bl = mirror = dummyDir != facing.m_122427_();
        if (mirror) {
            world.m_46597_(pos, (BlockState)state.m_61124_(DUMMY, (Comparable)Boolean.valueOf(true)));
        }
        world.m_46597_(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(!mirror)), world, pos));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Boolean)state.m_61143_(DUMMY), (Direction)state.m_61143_(FACING));
    }
}

