/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.conveyor;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorCacheData;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.conveyor.BasicConveyorRender;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.RedstoneConveyor;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class RedstoneConveyorRender
extends BasicConveyorRender<RedstoneConveyor> {
    public static final ResourceLocation texture_panel = new ResourceLocation("immersiveengineering:block/conveyor/redstone");
    public static final String MODEL_NAME = "conveyor_redstone_panel";
    public static DynamicModel MODEL_PANEL;
    private static final Map<Direction, BakedModel> ROTATED_MODELS;

    @SubscribeEvent
    public static void initModels(ModelEvent.BakingCompleted ev) {
        ResourceLocation modelName = MODEL_PANEL.getName();
        UnbakedModel model = ev.getModelBakery().m_119341_(modelName);
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            BlockModelRotation transform = BlockModelRotation.m_119153_((int)0, (int)((int)d.m_122435_() + 180));
            BakedModel baked = model.m_7611_(ev.getModelBakery(), arg_0 -> ((AtlasSet)ev.getModelBakery().getAtlasSet()).m_117971_(arg_0), (ModelState)transform, modelName);
            ROTATED_MODELS.put(d, baked);
        }
    }

    public RedstoneConveyorRender(ResourceLocation active, ResourceLocation inactive) {
        super(active, inactive);
    }

    @Override
    public Object getModelCacheKey(IConveyorModelRender.RenderContext<RedstoneConveyor> context) {
        BasicConveyorCacheData basic = IConveyorModelRender.getDefaultData(this, context);
        RedstoneConveyor instance = context.instance();
        if (instance == null) {
            return basic;
        }
        return Pair.of((Object)basic, (Object)instance.isPanelRight());
    }

    @Override
    public boolean shouldRenderWall(Direction facing, ConveyorWall wall, IConveyorModelRender.RenderContext<RedstoneConveyor> context) {
        RedstoneConveyor instance = context.instance();
        if (instance == null || instance.isPanelRight() && wall == ConveyorWall.RIGHT || !instance.isPanelRight() && wall == ConveyorWall.LEFT) {
            return true;
        }
        return super.shouldRenderWall(facing, wall, context);
    }

    @Override
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<RedstoneConveyor> context) {
        boolean panelRight = context.instance() == null || context.instance().isPanelRight();
        Direction facing = context.getFacing();
        BakedModel model = ROTATED_MODELS.get(panelRight ? facing : facing.m_122424_());
        if (model != null) {
            String[] stringArray;
            if (context.isActiveOr(false)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "panel";
                stringArray = stringArray2;
                stringArray2[1] = "lamp";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "panel";
            }
            String[] parts = stringArray;
            baseModel.addAll(model.getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts)), null));
        }
        return baseModel;
    }

    static {
        ROTATED_MODELS = new EnumMap<Direction, BakedModel>(Direction.class);
    }
}

