/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computer_common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ILuaMethodProvider;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ComputerEventManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.DroneAICC;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.DroneInterfaceBlock;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ProgWidgetCC;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.Validate;

public class DroneInterfaceBlockEntity
extends AbstractTickingBlockEntity
implements ILuaMethodProvider {
    private final LuaMethodRegistry luaMethodRegistry = new LuaMethodRegistry(this);
    private DroneEntity drone;
    public float rotationYaw;
    public float rotationPitch = (float)Math.toRadians(-42.0);
    private final ConcurrentLinkedQueue<Integer> ringSendQueue = new ConcurrentLinkedQueue();
    private int ringSendCooldown;
    private IProgWidget curAction;
    private int droneId;

    public DroneInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.DRONE_INTERFACE.get()), pos, state);
    }

    @Override
    public void tickClient() {
        DroneEntity eDrone;
        super.tickClient();
        Entity entity = this.nonNullLevel().m_6815_(this.droneId);
        DroneEntity droneEntity = this.drone = entity instanceof DroneEntity ? (eDrone = (DroneEntity)entity) : null;
        if (this.drone != null) {
            double dx = this.drone.m_20185_() - ((double)this.m_58899_().m_123341_() + 0.5);
            double dy = this.drone.m_20186_() - ((double)this.m_58899_().m_123342_() + 0.5);
            double dz = this.drone.m_20189_() - ((double)this.m_58899_().m_123343_() + 0.5);
            double f3 = Math.sqrt(dx * dx + dz * dz);
            this.rotationYaw = (float)(-Math.atan2(dx, dz));
            this.rotationPitch = (float)(-Math.atan2(dy, f3));
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.drone != null && !this.drone.m_6084_()) {
            this.setDrone(null);
        }
        if (this.drone != null) {
            if (this.ringSendCooldown > 0) {
                --this.ringSendCooldown;
            }
            if (!this.ringSendQueue.isEmpty() && this.ringSendCooldown <= 0) {
                this.ringSendCooldown = this.ringSendQueue.size() > 10 ? 1 : 5;
                NetworkHandler.sendToAllTracking((Object)new PacketSpawnRing((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, (Entity)this.drone, this.ringSendQueue.poll()), this);
            }
            if (!((Boolean)this.m_58900_().m_61143_((Property)DroneInterfaceBlock.CONNECTED)).booleanValue()) {
                this.nonNullLevel().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DroneInterfaceBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
            }
        } else if (((Boolean)this.m_58900_().m_61143_((Property)DroneInterfaceBlock.CONNECTED)).booleanValue()) {
            NetworkHandler.sendToAllTracking((Object)new PacketShowArea(this.m_58899_(), new BlockPos[0]), this);
            this.nonNullLevel().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DroneInterfaceBlock.CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("drone", this.drone != null ? this.drone.m_19879_() : -1);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.droneId = tag.m_128451_("drone");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.droneId = pkt.m_131708_().m_128451_("drone");
    }

    private DroneEntity validateAndGetDrone() {
        if (this.drone == null) {
            throw new IllegalStateException("There's no connected Drone!");
        }
        return this.drone;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        registry.registerLuaMethod(new LuaMethod("isConnectedToDrone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{DroneInterfaceBlockEntity.this.drone != null};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDronePressure"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{(double)((IAirHandler)DroneInterfaceBlockEntity.this.validateAndGetDrone().getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).orElseThrow(RuntimeException::new)).getPressure()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("exitPiece"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.validateAndGetDrone();
                DroneInterfaceBlockEntity.this.setDrone(null);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getAllActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                ArrayList<String> actions = new ArrayList<String>();
                DroneEntity drone = (DroneEntity)((EntityType)ModEntityTypes.DRONE.get()).m_20615_(DroneInterfaceBlockEntity.this.nonNullLevel());
                ModProgWidgets.PROG_WIDGETS.get().getEntries().forEach(entry -> {
                    IProgWidget widget = IProgWidget.create((ProgWidgetType)entry.getValue());
                    if (widget.canBeRunByComputers(drone, DroneInterfaceBlockEntity.this.getWidget())) {
                        actions.add(((ResourceKey)entry.getKey()).m_135782_().toString());
                    }
                });
                return new Object[]{this.getStringTable(actions)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDronePosition"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneEntity d = DroneInterfaceBlockEntity.this.validateAndGetDrone();
                return new Double[]{d.m_20185_(), d.m_20186_(), d.m_20189_()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDronePositionVec"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneEntity d = DroneInterfaceBlockEntity.this.validateAndGetDrone();
                return new Object[]{Map.of("x", d.m_20185_(), "y", d.m_20186_(), "z", d.m_20189_())};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setBlockOrder"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "'closest'/'highToLow'/'lowToHigh'");
                String arg = (String)args[0];
                for (IBlockOrdered.Ordering order : IBlockOrdered.Ordering.values()) {
                    if (!order.toString().equalsIgnoreCase(arg)) continue;
                    DroneInterfaceBlockEntity.this.getWidget().setOrder(order);
                    return null;
                }
                throw new IllegalArgumentException("No valid order. Valid arguments:  'closest', 'highToLow' or 'lowToHigh'!");
            }
        });
        registry.registerLuaMethod(new LuaMethod("getAreaTypes"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return DroneInterfaceBlockEntity.this.getWidget().getAreaTypes();
            }
        });
        registry.registerLuaMethod(new LuaMethod("addArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{3, 7}, "(x,y,z) or (x1,y1,z1,x2,y2,z2,areaType)");
                if (args.length == 3) {
                    DroneInterfaceBlockEntity.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                } else {
                    DroneInterfaceBlockEntity.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                }
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.AREA.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("removeArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{3, 7}, "(x,y,z) or (x1,y1,z1,x2,y2,z2,areaType)");
                if (args.length == 3) {
                    DroneInterfaceBlockEntity.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                } else if (args.length == 7) {
                    DroneInterfaceBlockEntity.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                }
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.AREA.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearArea();
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.AREA.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("showArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                HashSet<BlockPos> area = new HashSet<BlockPos>();
                DroneInterfaceBlockEntity.this.getWidget().getArea(area);
                NetworkHandler.sendToAllTracking((Object)new PacketShowArea(DroneInterfaceBlockEntity.this.m_58899_(), area), DroneInterfaceBlockEntity.this);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("hideArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                NetworkHandler.sendToAllTracking((Object)new PacketShowArea(DroneInterfaceBlockEntity.this.m_58899_(), new BlockPos[0]), DroneInterfaceBlockEntity.this);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "<string> item/block name, <bool> Use NBT, <bool> Use Mod Similarity");
                DroneInterfaceBlockEntity.this.getWidget().addWhitelistItemFilter((String)args[0], (Boolean)args[1], (Boolean)args[2]);
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "<string> item/block name, <bool> Use NBT, <bool> Use Mod Similarity");
                DroneInterfaceBlockEntity.this.getWidget().addBlacklistItemFilter((String)args[0], (Boolean)args[1], (Boolean)args[2]);
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearItemWhitelist();
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearItemBlacklist();
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addWhitelistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> text");
                DroneInterfaceBlockEntity.this.getWidget().addWhitelistText((String)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addBlacklistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> text");
                DroneInterfaceBlockEntity.this.getWidget().addBlacklistText((String)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearWhitelistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearWhitelistText();
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearBlacklistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearBlacklistText();
                DroneInterfaceBlockEntity.this.messageToDrone((ProgWidgetType)ModProgWidgets.TEXT.get());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSide"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 2, "down/up/north/south/west/east, <boolean> valid");
                Direction dir = this.getDirForString((String)args[0]);
                boolean[] sides = DroneInterfaceBlockEntity.this.getWidget().getSides();
                sides[dir.ordinal()] = (Boolean)args[1];
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSides"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 6, "6 x boolean (order: DUNSWE)");
                boolean[] sides = new boolean[6];
                for (int i = 0; i < 6; ++i) {
                    sides[i] = (Boolean)args[i];
                }
                DroneInterfaceBlockEntity.this.getWidget().setSides(sides);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setEmittingRedstone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> signal_strength");
                DroneInterfaceBlockEntity.this.getWidget().setEmittingRedstone(((Double)args[0]).intValue());
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRenameString"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> new_name");
                DroneInterfaceBlockEntity.this.getWidget().setNewName((String)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> fluid_name");
                DroneInterfaceBlockEntity.this.getWidget().addWhitelistLiquidFilter((String)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("addBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> fluid_name");
                DroneInterfaceBlockEntity.this.getWidget().addBlacklistLiquidFilter((String)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearLiquidWhitelist();
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("clearBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getWidget().clearLiquidBlacklist();
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setDropStraight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> drop_straight");
                DroneInterfaceBlockEntity.this.getWidget().setDropStraight((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setUseCount"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_use_count");
                DroneInterfaceBlockEntity.this.getWidget().setUseCount((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setCount"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> use_count");
                DroneInterfaceBlockEntity.this.getWidget().setCount(((Double)args[0]).intValue());
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setIsAndFunction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> is_and_function");
                DroneInterfaceBlockEntity.this.getWidget().setAndFunction((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setOperator"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> '>=', '=' or = '<='");
                DroneInterfaceBlockEntity.this.getWidget().setOperator((String)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("evaluateCondition"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                if (DroneInterfaceBlockEntity.this.curAction instanceof ICondition) {
                    ((ICondition)((Object)DroneInterfaceBlockEntity.this.curAction)).setOperator(DroneInterfaceBlockEntity.this.getWidget().getOperator());
                    ((ICondition)((Object)DroneInterfaceBlockEntity.this.curAction)).setRequiredCount(DroneInterfaceBlockEntity.this.getWidget().getRequiredCount());
                    ((ICondition)((Object)DroneInterfaceBlockEntity.this.curAction)).setMeasureVar(DroneInterfaceBlockEntity.this.getWidget().getMeasureVar());
                    ((ICondition)((Object)DroneInterfaceBlockEntity.this.curAction)).setAndFunction(DroneInterfaceBlockEntity.this.getWidget().isAndFunction());
                    boolean bool = ((ICondition)((Object)DroneInterfaceBlockEntity.this.curAction)).evaluate(DroneInterfaceBlockEntity.this.drone, DroneInterfaceBlockEntity.this.getWidget());
                    return new Object[]{bool};
                }
                throw new IllegalArgumentException("Current action is not a condition! Action: " + (DroneInterfaceBlockEntity.this.curAction != null ? DroneInterfaceBlockEntity.this.curAction.getType().toString() : "*none*"));
            }
        });
        registry.registerLuaMethod(new LuaMethod("setUseMaxActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_use_max_actions");
                DroneInterfaceBlockEntity.this.getWidget().setUseMaxActions((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setMaxActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> max_actions");
                DroneInterfaceBlockEntity.this.getWidget().setMaxActions(((Double)args[0]).intValue());
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSneaking"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> is_sneaking");
                DroneInterfaceBlockEntity.this.getWidget().setSneaking((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setCanSteal"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> can_steal");
                DroneInterfaceBlockEntity.this.getWidget().setCanSteal((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRightClickType"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> 'click_item' or 'click_block'");
                String val = ((String)args[0]).toUpperCase(Locale.ROOT);
                DroneInterfaceBlockEntity.this.getWidget().setClickType(IBlockRightClicker.RightClickType.valueOf(val));
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setPlaceFluidBlocks"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_place_fluid_blocks");
                DroneInterfaceBlockEntity.this.getWidget().setPlaceFluidBlocks((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> action_name");
                String widgetName = (String)args[0];
                ResourceLocation id = widgetName.contains(":") ? new ResourceLocation(widgetName) : PneumaticRegistry.RL(widgetName);
                ProgWidgetType type = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS.get().getValue(id);
                Validate.notNull((Object)type, (String)("No action with the name '" + widgetName + "'!"), (Object[])new Object[0]);
                IProgWidget widget = IProgWidget.create(type);
                Validate.isTrue((boolean)widget.isAvailable(), (String)("Widget '" + widget.getTypeID() + "' is not available in this instance!"), (Object[])new Object[0]);
                Goal ai = widget.getWidgetAI(DroneInterfaceBlockEntity.this.drone, DroneInterfaceBlockEntity.this.getWidget());
                Validate.isTrue((ai != null && widget.canBeRunByComputers(DroneInterfaceBlockEntity.this.drone, DroneInterfaceBlockEntity.this.getWidget()) ? 1 : 0) != 0, (String)("Parsed action '" + widgetName + "' is not a runnable action!"), (Object[])new Object[0]);
                DroneInterfaceBlockEntity.this.getAI().setAction(widget, ai);
                DroneInterfaceBlockEntity.this.getTargetAI().setAction(widget, widget.getWidgetTargetAI(DroneInterfaceBlockEntity.this.drone, DroneInterfaceBlockEntity.this.getWidget()));
                DroneInterfaceBlockEntity.this.messageToDrone(widget.getColor());
                DroneInterfaceBlockEntity.this.curAction = widget;
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                if (DroneInterfaceBlockEntity.this.curAction != null) {
                    return new Object[]{PneumaticCraftUtils.getRegistryName(ModProgWidgets.PROG_WIDGETS.get(), DroneInterfaceBlockEntity.this.curAction.getType()).map(ResourceLocation::toString).orElse("?")};
                }
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("abortAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.getAI().abortAction();
                DroneInterfaceBlockEntity.this.getTargetAI().abortAction();
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                DroneInterfaceBlockEntity.this.curAction = null;
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("isActionDone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{DroneInterfaceBlockEntity.this.getAI().isActionDone()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("forgetTarget"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                DroneInterfaceBlockEntity.this.validateAndGetDrone().m_6710_(null);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getUpgrades"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> upgrade_name");
                PNCUpgrade upgrade = (PNCUpgrade)ModUpgrades.UPGRADES.get().getValue(PneumaticCraftUtils.modDefaultedRL((String)args[0]));
                Validate.isTrue((upgrade != null ? 1 : 0) != 0, (String)("unknown upgrade: '" + args[0] + "'"), (Object[])new Object[0]);
                return new Object[]{(double)DroneInterfaceBlockEntity.this.validateAndGetDrone().getUpgrades(upgrade)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setCraftingGrid"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 9, "9 x item_name");
                String[] grid = new String[9];
                for (int i = 0; i < 9; ++i) {
                    grid[i] = (String)args[i];
                }
                DroneInterfaceBlockEntity.this.getWidget().setCraftingGrid(grid);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setVariable"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{2, 4}, "<string> var_name, true/false OR <string> var_name, <int> x, <int> y, <int> z");
                DroneEntity d = DroneInterfaceBlockEntity.this.validateAndGetDrone();
                String varName = (String)args[0];
                int x = args[1] instanceof Double ? ((Double)args[1]).intValue() : ((Boolean)args[1] != false ? 1 : 0);
                int y = 0;
                int z = 0;
                if (args.length == 4) {
                    y = ((Double)args[2]).intValue();
                    z = ((Double)args[3]).intValue();
                }
                d.setVariable(varName, new BlockPos(x, y, z));
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getVariable"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> var_name");
                return DroneInterfaceBlockEntity.this.validateAndGetDrone().getVariable((String)args[0]).map(var -> {
                    DroneInterfaceBlockEntity.this.messageToDrone(-1);
                    return new Object[]{var.m_123341_(), var.m_123342_(), var.m_123343_()};
                }).orElse(null);
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSignText"){

            @Override
            public Object[] call(Object[] args) {
                DroneInterfaceBlockEntity.this.getWidget().signText = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    DroneInterfaceBlockEntity.this.getWidget().signText[i] = (String)args[i];
                }
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRequiresTool"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> require_tool");
                DroneInterfaceBlockEntity.this.getWidget().setRequiresTool((Boolean)args[0]);
                DroneInterfaceBlockEntity.this.messageToDrone(-1);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getDroneName"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{DroneInterfaceBlockEntity.this.validateAndGetDrone().m_7755_().getString()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getOwnerName"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{DroneInterfaceBlockEntity.this.validateAndGetDrone().getOwnerName().getString()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getOwnerID"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{DroneInterfaceBlockEntity.this.validateAndGetDrone().getOwnerUUID().toString()};
            }
        });
    }

    @Override
    public LuaMethodRegistry getLuaMethodRegistry() {
        return this.luaMethodRegistry;
    }

    @Override
    public String getPeripheralType() {
        return "drone_interface";
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public void setDrone(DroneEntity drone) {
        this.drone = drone;
        ComputerEventManager.getInstance().sendEvents(this, drone != null ? "droneConnected" : "droneDisconnected", new Object[0]);
        BlockState state = this.nonNullLevel().m_8055_(this.m_58899_());
        this.nonNullLevel().m_7260_(this.m_58899_(), state, state, 3);
    }

    public DroneEntity getDrone() {
        return this.drone;
    }

    private ProgWidgetCC getWidget() {
        return this.getAI().getWidget();
    }

    private DroneAICC getAI() {
        if (this.drone != null) {
            for (DroneAIManager.WrappedGoal wrappedGoal : this.drone.getRunningTasks()) {
                if (!(wrappedGoal.goal() instanceof DroneAICC)) continue;
                return (DroneAICC)wrappedGoal.goal();
            }
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private DroneAICC getTargetAI() {
        if (this.drone != null && this.drone.getRunningTargetAI() instanceof DroneAICC) {
            return (DroneAICC)this.drone.getRunningTargetAI();
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private <P extends ProgWidget> void messageToDrone(ProgWidgetType<P> type) {
        this.messageToDrone(((ProgWidget)type.create()).getColor());
    }

    private void messageToDrone(DyeColor color) {
        float[] c = color.m_41068_();
        this.messageToDrone((int)(c[0] * 256.0f) << 24 | (int)(c[1] * 256.0f) << 16 | (int)(c[2] * 256.0f) | 0xFF000000);
    }

    private void messageToDrone(int color) {
        this.ringSendQueue.offer(color);
    }
}

