/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2Integration;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2RequesterIntegration;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

public class LogisticsRequesterEntity
extends AbstractLogisticsFrameEntity
implements ISpecificRequester,
IProvidingInventoryListener {
    private static final EntityDataAccessor<Boolean> AE2_ENABLED = SynchedEntityData.m_135353_(LogisticsRequesterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String NBT_AE2_INTEGRATION = "AE2_Integration";
    private int minItems = 1;
    private int minFluid = 1;
    private AE2RequesterIntegration ae2requester = null;

    public LogisticsRequesterEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        if (AE2Integration.isAvailable()) {
            this.m_20088_().m_135372_(AE2_ENABLED, (Object)false);
        }
    }

    @Override
    public int getColor() {
        return -16776961;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.MODEL_LOGISTICS_FRAME_REQUESTER;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    protected MenuType<?> getContainerType() {
        return (MenuType)ModMenuTypes.LOGISTICS_FRAME_REQUESTER.get();
    }

    @Override
    public int getMinItemOrderSize() {
        return this.minItems;
    }

    @Override
    public void setMinItemOrderSize(int minItems) {
        this.minItems = minItems;
    }

    @Override
    public int getMinFluidOrderSize() {
        return this.minFluid;
    }

    @Override
    public void setMinFluidOrderSize(int minFluid) {
        this.minFluid = minFluid;
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (AE2Integration.isAvailable()) {
            this.setAE2enabled(tag.m_128471_(NBT_AE2_INTEGRATION));
        }
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag) {
        tag = super.serializeNBT(tag);
        if (AE2Integration.isAvailable()) {
            tag.m_128379_(NBT_AE2_INTEGRATION, this.isAE2enabled());
        }
        return tag;
    }

    @Override
    public boolean canFilterStack() {
        return true;
    }

    @Override
    public boolean supportsBlacklisting() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public void notify(IProvidingInventoryListener.TileEntityAndFace teAndFace) {
    }

    @Override
    protected void doExtraCleanupTasks(boolean removingSemiblock) {
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
    }

    @Override
    public int amountRequested(ItemStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return IOHelper.getInventoryForTE(this.getCachedTileEntity(), this.getSide()).map(itemHandler -> {
                int count = 0;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack s = itemHandler.getStackInSlot(i);
                    if (s.m_41619_() || !this.getItemFilterHandler().matchOneItem(stack, s)) continue;
                    count += s.m_41613_();
                }
                return Math.max(0, Math.min(stack.m_41613_(), totalRequestingAmount - (count += this.getIncomingItems(stack))));
            }).orElse(0);
        }
        return 0;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return this.getCachedTileEntity().getCapability(ForgeCapabilities.FLUID_HANDLER, this.getSide()).map(fluidHandler -> {
                int count = 0;
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack contents = fluidHandler.getFluidInTank(i);
                    if (contents.getFluid() != stack.getFluid()) continue;
                    count += contents.getAmount();
                }
                return Math.max(0, Math.min(stack.getAmount(), totalRequestingAmount - (count += this.getIncomingFluid(stack.getFluid()))));
            }).orElse(0);
        }
        return 0;
    }

    private int getTotalRequestedAmount(ItemStack stack) {
        return this.getItemFilterHandler().getMatchedCount(stack);
    }

    private int getTotalRequestedAmount(FluidStack stack) {
        int requesting = 0;
        for (int i = 0; i < 9; ++i) {
            FluidStack requestingStack = this.getFluidFilter(i);
            if (requestingStack == null || requestingStack.getFluid() != stack.getFluid()) continue;
            requesting += requestingStack.getAmount();
        }
        return requesting;
    }

    private void setAE2enabled(boolean enabled) {
        this.m_20088_().m_135381_(AE2_ENABLED, (Object)enabled);
    }

    public boolean isAE2enabled() {
        return AE2Integration.isAvailable() && (Boolean)this.m_20088_().m_135370_(AE2_ENABLED) != false;
    }
}

