/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.item.logistics.AbstractLogisticsFrameItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractLogisticsFrameEntity
extends AbstractSemiblockEntity
implements IDirectionalSemiblock {
    public static final String NBT_INVISIBLE = "invisible";
    public static final String NBT_MATCH_NBT = "matchNBT";
    public static final String NBT_MATCH_DURABILITY = "matchDurability";
    public static final String NBT_MATCH_MODID = "matchModID";
    public static final String NBT_ITEM_WHITELIST = "whitelist";
    public static final String NBT_FLUID_WHITELIST = "fluidWhitelist";
    public static final String NBT_ITEM_FILTERS = "filters";
    public static final String NBT_FLUID_FILTERS = "fluidFilters";
    private static final String NBT_SIDE = "side";
    private static final int ITEM_FILTER_SLOTS = 27;
    public static final int FLUID_FILTER_SLOTS = 9;
    private static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.m_135353_(AbstractLogisticsFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> SIDE = SynchedEntityData.m_135353_(AbstractLogisticsFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final float FRAME_WIDTH = 0.03125f;
    private final Map<ItemStack, Integer> incomingStacks = new HashMap<ItemStack, Integer>();
    private final Map<FluidStack, Integer> incomingFluid = new IdentityHashMap<FluidStack, Integer>();
    private final ItemFilterHandler itemFilterHandler = new ItemFilterHandler(27);
    private FluidFilter fluidFilters = new FluidFilter(9);
    private boolean matchNBT = false;
    private boolean matchDurability = false;
    private boolean matchModId = false;
    private boolean itemWhiteList = true;
    private boolean fluidWhiteList = true;
    private int alpha = 255;

    AbstractLogisticsFrameEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static AbstractLogisticsFrameEntity fromItemStack(Level world, @Nullable Player player, @Nonnull ItemStack stack) {
        SemiblockItem semiblockItem;
        AbstractSemiblockEntity semiblock;
        Item item = stack.m_41720_();
        if (item instanceof SemiblockItem && (semiblock = (semiblockItem = (SemiblockItem)item).createEntity(world, stack, player, BlockPos.f_121853_)) instanceof AbstractLogisticsFrameEntity) {
            AbstractLogisticsFrameEntity logisticsFrame = (AbstractLogisticsFrameEntity)semiblock;
            if (world.f_46443_ && stack.m_41782_()) {
                CompoundTag tag = logisticsFrame.m_20240_(new CompoundTag());
                UUID uuid = logisticsFrame.m_20148_();
                tag.m_128391_(stack.m_41783_().m_128469_("EntityTag"));
                logisticsFrame.m_20084_(uuid);
                logisticsFrame.m_20258_(tag);
            }
            return logisticsFrame;
        }
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(INVISIBLE, (Object)false);
        this.m_20088_().m_135372_(SIDE, (Object)Direction.SOUTH);
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockEntity te = this.getCachedTileEntity();
        return te != null && (te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent() || te.getCapability(ForgeCapabilities.FLUID_HANDLER, facing).isPresent());
    }

    @Override
    public boolean canStay() {
        return this.canPlace(this.getSide());
    }

    @Override
    protected AABB calculateBlockBounds() {
        AABB bb = super.calculateBlockBounds();
        return switch (this.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new AABB(bb.f_82288_, bb.f_82289_ - 0.03125, bb.f_82290_, bb.f_82291_, bb.f_82289_, bb.f_82293_);
            case Direction.UP -> new AABB(bb.f_82288_, bb.f_82292_, bb.f_82290_, bb.f_82291_, bb.f_82292_ + 0.03125, bb.f_82293_);
            case Direction.NORTH -> new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_ - 0.03125, bb.f_82291_, bb.f_82292_, bb.f_82290_);
            case Direction.SOUTH -> new AABB(bb.f_82288_, bb.f_82289_, bb.f_82293_, bb.f_82291_, bb.f_82292_, bb.f_82293_ + 0.03125);
            case Direction.WEST -> new AABB(bb.f_82288_ - 0.03125, bb.f_82289_, bb.f_82290_, bb.f_82288_, bb.f_82292_, bb.f_82293_);
            case Direction.EAST -> new AABB(bb.f_82291_, bb.f_82289_, bb.f_82290_, bb.f_82291_ + 0.03125, bb.f_82292_, bb.f_82293_);
        };
    }

    @Override
    public abstract int getColor();

    public abstract ResourceLocation getTexture();

    public abstract int getPriority();

    protected abstract MenuType<?> getContainerType();

    public boolean shouldProvideTo(int level) {
        return true;
    }

    public boolean isSemiblockInvisible() {
        return (Boolean)this.m_20088_().m_135370_(INVISIBLE);
    }

    public void setSemiblockInvisible(boolean invisible) {
        this.m_20088_().m_135381_(INVISIBLE, (Object)invisible);
    }

    @Override
    public Direction getSide() {
        return (Direction)this.m_20088_().m_135370_(SIDE);
    }

    @Override
    public void setSide(Direction facing) {
        if (SemiblockTracker.getInstance().getSemiblock(this.f_19853_, this.getBlockPos(), facing) == null) {
            this.m_20088_().m_135381_(SIDE, (Object)facing);
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean isItemWhiteList() {
        return this.itemWhiteList;
    }

    public void setItemWhiteList(boolean whiteList) {
        this.itemWhiteList = whiteList;
    }

    public boolean isFluidWhiteList() {
        return this.fluidWhiteList;
    }

    public void setFluidWhiteList(boolean whiteList) {
        this.fluidWhiteList = whiteList;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNBT) {
        this.matchNBT = matchNBT;
    }

    public boolean isMatchDurability() {
        return this.matchDurability;
    }

    public void setMatchDurability(boolean matchDurability) {
        this.matchDurability = matchDurability;
    }

    public boolean isMatchModId() {
        return this.matchModId;
    }

    public void setMatchModId(boolean matchModId) {
        this.matchModId = matchModId;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            Iterator<Map.Entry<ItemStack, Integer>> iterator = this.incomingStacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> entry = iterator.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
            Iterator<Map.Entry<FluidStack, Integer>> it = this.incomingFluid.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<FluidStack, Integer> entry = it.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    it.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
        } else {
            this.alpha = this.isSemiblockInvisible() && !this.playerIsHoldingLogisticItems() ? Math.max(0, this.alpha - 9) : Math.min(255, this.alpha + 9);
        }
    }

    public void informIncomingStack(ItemStack stack) {
        this.incomingStacks.put(stack, 0);
    }

    public void clearIncomingStack(ItemStack stack) {
        this.incomingStacks.remove(stack);
    }

    public void informIncomingStack(FluidStack stack) {
        this.incomingFluid.put(stack, 0);
    }

    public void clearIncomingStack(FluidStack stack) {
        this.incomingFluid.remove(stack);
    }

    public int getIncomingFluid(Fluid fluid) {
        int count = 0;
        for (FluidStack fluidStack : this.incomingFluid.keySet()) {
            if (fluidStack.getFluid() != fluid) continue;
            count += fluidStack.getAmount();
        }
        return count;
    }

    public int getIncomingItems(ItemStack stack) {
        return this.incomingStacks.keySet().stream().filter(s -> this.itemFilterHandler.matchOneItem(stack, (ItemStack)s)).mapToInt(ItemStack::m_41613_).sum();
    }

    public void setItemFilter(int slot, ItemStack stack) {
        this.itemFilterHandler.setStackInSlot(slot, stack);
    }

    public void setFluidFilter(int filterIndex, FluidStack stack) {
        this.fluidFilters.fluidStacks.set(filterIndex, stack);
    }

    public FluidStack getFluidFilter(int filterIndex) {
        return this.fluidFilters.fluidStacks.get(filterIndex);
    }

    public ItemFilterHandler getItemFilterHandler() {
        return this.itemFilterHandler;
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.itemFilterHandler.deserializeNBT(tag.m_128469_(NBT_ITEM_FILTERS));
        this.fluidFilters.deserializeNBT(tag.m_128469_(NBT_FLUID_FILTERS));
        this.setSemiblockInvisible(tag.m_128471_(NBT_INVISIBLE));
        this.setMatchNBT(tag.m_128471_(NBT_MATCH_NBT));
        this.setMatchDurability(tag.m_128471_(NBT_MATCH_DURABILITY));
        this.setMatchModId(tag.m_128471_(NBT_MATCH_MODID));
        this.setItemWhiteList(tag.m_128471_(NBT_ITEM_WHITELIST));
        if (!tag.m_128425_(NBT_FLUID_WHITELIST, 1)) {
            this.setFluidWhiteList(true);
        } else {
            this.setFluidWhiteList(tag.m_128471_(NBT_FLUID_WHITELIST));
        }
        this.setSide(tag.m_128441_(NBT_SIDE) ? Direction.m_122376_((int)tag.m_128451_(NBT_SIDE)) : Direction.UP);
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity = this;
        if (abstractLogisticsFrameEntity instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            spr.setMinItemOrderSize(Math.max(1, tag.m_128451_("minItems")));
            spr.setMinFluidOrderSize(Math.max(1, tag.m_128451_("minFluid")));
        }
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag) {
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity;
        tag = super.serializeNBT(tag);
        tag.m_128365_(NBT_ITEM_FILTERS, (Tag)this.itemFilterHandler.serializeNBT());
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.serializeNBT());
        tag.m_128379_(NBT_INVISIBLE, this.isSemiblockInvisible());
        tag.m_128379_(NBT_MATCH_NBT, this.isMatchNBT());
        tag.m_128379_(NBT_MATCH_DURABILITY, this.isMatchDurability());
        tag.m_128379_(NBT_MATCH_MODID, this.isMatchModId());
        tag.m_128379_(NBT_ITEM_WHITELIST, this.isItemWhiteList());
        tag.m_128379_(NBT_FLUID_WHITELIST, this.isFluidWhiteList());
        if (this.getSide() != null) {
            tag.m_128405_(NBT_SIDE, this.getSide().m_122411_());
        }
        if ((abstractLogisticsFrameEntity = this) instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            tag.m_128405_("minItems", spr.getMinItemOrderSize());
            tag.m_128405_("minFluid", spr.getMinFluidOrderSize());
        }
        return tag;
    }

    @Override
    public void onPlaced(Player player, ItemStack stack, Direction facing) {
        super.onPlaced(player, stack, facing);
        this.setSide(facing);
    }

    public boolean canFilterStack() {
        return false;
    }

    boolean passesFilter(ItemStack stack) {
        return this.itemFilterHandler.isEmpty() || this.itemFilterHandler.match(stack) == this.isItemWhiteList();
    }

    boolean passesFilter(Fluid fluid) {
        boolean hasFilter = false;
        for (FluidStack filterStack : this.fluidFilters.fluidStacks) {
            if (filterStack.getAmount() <= 0) continue;
            if (this.matchFluids(filterStack, fluid)) {
                return this.isFluidWhiteList();
            }
            hasFilter = true;
        }
        return !hasFilter;
    }

    private boolean matchFluids(FluidStack filterStack, Fluid fluid) {
        return filterStack.getFluid() == fluid;
    }

    @Override
    public void addTooltip(Consumer<Component> curInfo, Player player, CompoundTag tag, boolean extended) {
        NonNullList<ItemStack> drops;
        curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.facing", this.getSide()));
        if (player.m_6144_() && !(drops = this.getDrops()).isEmpty()) {
            AbstractLogisticsFrameItem.addLogisticsTooltip((ItemStack)drops.get(0), player.f_19853_, new ArrayList<Component>(), true).forEach(curInfo);
        }
    }

    @Override
    public boolean onRightClickWithConfigurator(Player player, Direction side) {
        if (!player.f_19853_.f_46443_) {
            if (side != this.getSide()) {
                return false;
            }
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return new ItemStack((ItemLike)AbstractLogisticsFrameEntity.this.getDroppedItem()).m_41786_();
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new LogisticsMenu(AbstractLogisticsFrameEntity.this.getContainerType(), i, playerInventory, AbstractLogisticsFrameEntity.this.m_19879_());
                }
            };
            NetworkHandler.sendToPlayer(new PacketSyncSemiblock(this, false), (ServerPlayer)player);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, buffer -> buffer.m_130130_(this.m_19879_()));
        }
        return true;
    }

    private boolean playerIsHoldingLogisticItems() {
        Player player = ClientUtils.getClientPlayer();
        ItemStack stack = player.m_21205_();
        return stack.m_41720_() == ModItems.LOGISTICS_CONFIGURATOR.get() || stack.m_41720_() == ModItems.LOGISTICS_DRONE.get() || stack.m_41720_() instanceof SemiblockItem;
    }

    public boolean supportsBlacklisting() {
        return true;
    }

    @Override
    public void writeToBuf(FriendlyByteBuf payload) {
        super.writeToBuf(payload);
        payload.writeByte(this.getSide().m_122411_());
        payload.writeBoolean(this.isSemiblockInvisible());
        payload.writeBoolean(this.itemWhiteList);
        payload.writeBoolean(this.fluidWhiteList);
        payload.writeBoolean(this.matchNBT);
        payload.writeBoolean(this.matchDurability);
        payload.writeBoolean(this.matchModId);
        payload.m_130130_(this.itemFilterHandler.getSlots());
        for (int i = 0; i < this.itemFilterHandler.getSlots(); ++i) {
            payload.m_130055_(this.itemFilterHandler.getStackInSlot(i));
        }
        this.fluidFilters.write(payload);
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity = this;
        if (abstractLogisticsFrameEntity instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            payload.m_130130_(spr.getMinItemOrderSize());
            payload.m_130130_(spr.getMinFluidOrderSize());
        }
    }

    @Override
    public void readFromBuf(FriendlyByteBuf payload) {
        super.readFromBuf(payload);
        this.setSide(Direction.m_122376_((int)payload.readByte()));
        this.setSemiblockInvisible(payload.readBoolean());
        this.itemWhiteList = payload.readBoolean();
        this.fluidWhiteList = payload.readBoolean();
        this.matchNBT = payload.readBoolean();
        this.matchDurability = payload.readBoolean();
        this.matchModId = payload.readBoolean();
        int size = payload.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.itemFilterHandler.setStackInSlot(i, payload.m_130267_());
        }
        this.fluidFilters = new FluidFilter(payload);
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity = this;
        if (abstractLogisticsFrameEntity instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            spr.setMinItemOrderSize(payload.m_130242_());
            spr.setMinFluidOrderSize(payload.m_130242_());
        }
    }

    public boolean isObstructed(PathComputationType pathType) {
        BlockPos pos = this.getBlockPos().m_121945_(this.getSide());
        return !this.f_19853_.m_8055_(pos).m_60647_((BlockGetter)this.f_19853_, pos, pathType);
    }

    public class ItemFilterHandler
    extends ItemStackHandler {
        private final List<ItemStack> filterStacks;

        ItemFilterHandler(int size) {
            super(size);
            this.filterStacks = new ArrayList<ItemStack>();
        }

        boolean match(ItemStack stack) {
            return this.filterStacks.stream().anyMatch(filterStack -> this.matchOneItem((ItemStack)filterStack, stack));
        }

        int getMatchedCount(ItemStack stack) {
            return this.filterStacks.stream().filter(filterStack -> this.matchOneItem((ItemStack)filterStack, stack)).mapToInt(ItemStack::m_41613_).sum();
        }

        boolean matchOneItem(ItemStack filterStack, ItemStack stack) {
            return !filterStack.m_41619_() && PneumaticCraftUtils.doesItemMatchFilter(filterStack, stack, AbstractLogisticsFrameEntity.this.isMatchDurability(), AbstractLogisticsFrameEntity.this.isMatchNBT(), AbstractLogisticsFrameEntity.this.isMatchModId());
        }

        private void buildFilterList() {
            this.filterStacks.clear();
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).m_41619_()) continue;
                this.filterStacks.add(this.getStackInSlot(i));
            }
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.buildFilterList();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.buildFilterList();
        }

        public boolean isEmpty() {
            return this.filterStacks.isEmpty();
        }
    }

    public static class FluidFilter
    implements INBTSerializable<CompoundTag> {
        private final List<FluidStack> fluidStacks = new ArrayList<FluidStack>();

        public FluidFilter() {
        }

        FluidFilter(int size) {
            for (int i = 0; i < size; ++i) {
                this.fluidStacks.add(FluidStack.EMPTY);
            }
        }

        FluidFilter(FriendlyByteBuf packetBuffer) {
            int size = packetBuffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                this.fluidStacks.add(packetBuffer.readFluidStack());
            }
        }

        public FluidStack get(int slot) {
            return this.fluidStacks.get(slot);
        }

        public int size() {
            return this.fluidStacks.size();
        }

        public void write(FriendlyByteBuf packetBuffer) {
            packetBuffer.m_130130_(this.fluidStacks.size());
            this.fluidStacks.forEach(arg_0 -> ((FriendlyByteBuf)packetBuffer).writeFluidStack(arg_0));
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("size", this.fluidStacks.size());
            ListTag list = new ListTag();
            for (FluidStack f : this.fluidStacks) {
                list.add((Object)f.writeToNBT(new CompoundTag()));
            }
            tag.m_128365_(AbstractLogisticsFrameEntity.NBT_ITEM_FILTERS, (Tag)list);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.fluidStacks.clear();
            int n = nbt.m_128451_("size");
            ListTag l = nbt.m_128437_(AbstractLogisticsFrameEntity.NBT_ITEM_FILTERS, 10);
            for (int i = 0; i < n; ++i) {
                this.fluidStacks.add(FluidStack.loadFluidStackFromNBT((CompoundTag)l.m_128728_(i)));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerLeftClick(AttackEntityEvent event) {
            AbstractLogisticsFrameEntity frame;
            Entity entity = event.getTarget();
            if (entity instanceof AbstractLogisticsFrameEntity && (frame = (AbstractLogisticsFrameEntity)entity).isSemiblockInvisible()) {
                frame.getBlockState().m_60686_(frame.getWorld(), frame.getBlockPos(), event.getEntity());
                event.setCanceled(true);
            }
        }
    }
}

