/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.minecraftforge.fluids.IFluidTank;

public class FluidItemModel
implements IDynamicBakedModel {
    private final BakedModel bakedBaseModel;
    private final ItemOverrides overrideList = new FluidOverridesList(this);
    private List<TankRenderInfo> tanksToRender = Collections.emptyList();

    private FluidItemModel(BakedModel bakedBaseModel) {
        this.bakedBaseModel = bakedBaseModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> res = new ArrayList<BakedQuad>(this.bakedBaseModel.getQuads(state, side, rand, extraData, renderType));
        for (TankRenderInfo info : this.tanksToRender) {
            ImmutableList vecs;
            IFluidTank tank = info.getTank();
            if (tank.getFluid().isEmpty()) continue;
            Fluid fluid = tank.getFluid().getFluid();
            IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid);
            ResourceLocation texture = renderProps.getStillTexture(tank.getFluid());
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
            int color = renderProps.getTintColor(tank.getFluid());
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            AABB bounds = this.getRenderBounds(tank, info.getBounds());
            float bx1 = (float)(bounds.f_82288_ * 16.0);
            float bx2 = (float)(bounds.f_82291_ * 16.0);
            float by1 = (float)(bounds.f_82289_ * 16.0);
            float by2 = (float)(bounds.f_82292_ * 16.0);
            float bz1 = (float)(bounds.f_82290_ * 16.0);
            float bz2 = (float)(bounds.f_82293_ * 16.0);
            if (info.shouldRender(Direction.DOWN)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.DOWN, bx1, bx2, bz1, bz2));
            }
            if (info.shouldRender(Direction.UP)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            }
            if (info.shouldRender(Direction.NORTH)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            }
            if (info.shouldRender(Direction.SOUTH)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            }
            if (info.shouldRender(Direction.WEST)) {
                vecs = ImmutableList.of((Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_));
                res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.WEST, bz1, bz2, by1, by2));
            }
            if (!info.shouldRender(Direction.EAST)) continue;
            vecs = ImmutableList.of((Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), (Object)new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), (Object)new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_));
            res.add(this.createQuad((List<Vec3>)vecs, cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }
        return res;
    }

    private AABB getRenderBounds(IFluidTank tank, AABB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.f_82292_ - tankBounds.f_82289_;
        double y1 = tankBounds.f_82289_;
        double y2 = tankBounds.f_82289_ + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getFluidType().isLighterThanAir()) {
            double yOff = tankBounds.f_82292_ - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AABB(tankBounds.f_82288_, y1, tankBounds.f_82290_, tankBounds.f_82291_, y2, tankBounds.f_82293_);
    }

    private BakedQuad createQuad(List<Vec3> vecs, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_());
        this.putVertex(quadBaker, normal, vecs.get((int)0).f_82479_, vecs.get((int)0).f_82480_, vecs.get((int)0).f_82481_, u1, v1, sprite, cols, face);
        this.putVertex(quadBaker, normal, vecs.get((int)1).f_82479_, vecs.get((int)1).f_82480_, vecs.get((int)1).f_82481_, u1, v2, sprite, cols, face);
        this.putVertex(quadBaker, normal, vecs.get((int)2).f_82479_, vecs.get((int)2).f_82480_, vecs.get((int)2).f_82481_, u2, v2, sprite, cols, face);
        this.putVertex(quadBaker, normal, vecs.get((int)3).f_82479_, vecs.get((int)3).f_82480_, vecs.get((int)3).f_82481_, u2, v1, sprite, cols, face);
        return quad[0];
    }

    private void putVertex(QuadBakingVertexConsumer quadBaker, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float[] cols, Direction face) {
        quadBaker.m_5483_(x, y, z);
        quadBaker.m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_);
        quadBaker.m_85950_(cols[1], cols[2], cols[3], cols[0]);
        quadBaker.m_7421_(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
        quadBaker.setSprite(sprite);
        quadBaker.setDirection(face);
        quadBaker.m_5752_();
    }

    public boolean m_7541_() {
        return this.bakedBaseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.bakedBaseModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.bakedBaseModel.m_7521_();
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        return this.bakedBaseModel.getParticleIcon(data);
    }

    public TextureAtlasSprite m_6160_() {
        return this.bakedBaseModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return super.getRenderPasses(itemStack, fabulous);
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        this.bakedBaseModel.m_7442_().m_111808_(transformType).m_111763_(applyLeftHandTransform, poseStack);
        return this;
    }

    private static class FluidOverridesList
    extends ItemOverrides {
        private final FluidItemModel modelIn;

        FluidOverridesList(FluidItemModel modelIn) {
            this.modelIn = modelIn;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel original, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            Item item = stack.m_41720_();
            if (item instanceof IFluidRendered) {
                IFluidRendered r = (IFluidRendered)item;
                this.modelIn.tanksToRender = r.getFluidItemRenderer().getTanksToRender(stack);
            }
            return this.modelIn;
        }
    }

    public static enum Loader implements IGeometryLoader<Geometry>
    {
        INSTANCE;


        public Geometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            return new Geometry(baseModel);
        }
    }

    public static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private final BlockModel baseModel;

        Geometry(BlockModel baseModel) {
            this.baseModel = baseModel;
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new FluidItemModel(this.baseModel.m_111449_(bakery, this.baseModel.f_111418_, spriteGetter, modelTransform, modelLocation, true));
        }

        public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.baseModel.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

