/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.KeroseneLampBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.KeroseneLampMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.apache.commons.lang3.tuple.Pair;

public class KeroseneLampScreen
extends AbstractPneumaticCraftContainerScreen<KeroseneLampMenu, KeroseneLampBlockEntity> {
    private WidgetLabel rangeLabel;
    private ForgeSlider slider;
    private WidgetAnimatedStat fuelTab;
    private int prevRange;

    public KeroseneLampScreen(KeroseneLampMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.prevRange = ((KeroseneLampBlockEntity)this.te).getRange();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new WidgetTank(this.f_97735_ + 152, this.f_97736_ + 15, ((KeroseneLampBlockEntity)this.te).getTank()));
        this.rangeLabel = new WidgetLabel(this.f_97735_ + 8, this.f_97736_ + 50, (Component)Component.m_237119_());
        this.m_142416_((GuiEventListener)this.rangeLabel);
        this.slider = new PNCForgeSlider(this.f_97735_ + 7, this.f_97736_ + 30, 118, 16, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keroseneLamp.maxRange", new Object[0]).m_130946_(" "), (Component)Component.m_237119_(), 1.0, 30.0, ((KeroseneLampBlockEntity)this.te).getTargetRange(), true, slider -> this.sendDelayed(5));
        this.m_142416_((GuiEventListener)this.slider);
        this.fuelTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidCompressor.fuel", new Object[0]), new ItemStack((ItemLike)ModItems.LPG_BUCKET.get()), -5226496, true);
        this.populateFuelTab();
    }

    private void populateFuelTab() {
        int div = ((KeroseneLampBlockEntity)this.te).getRange() * ((KeroseneLampBlockEntity)this.te).getRange() * 3;
        Pair<Integer, List<Component>> p = ClientUtils.formatFuelList((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keroseneLamp.fuelsHeader", ((KeroseneLampBlockEntity)this.te).getRange()), this.getGuiLeft() - 10, fluid -> (int)(((KeroseneLampBlockEntity)this.te).calculateFuelQuality((Fluid)fluid) * 5.0f / (float)div), false);
        this.fuelTab.setMinimumExpandedDimensions((Integer)p.getLeft() + 30, 17);
        this.fuelTab.setText((List)p.getRight());
    }

    @Override
    public void m_181908_() {
        if (this.firstUpdate) {
            this.slider.m_93611_((double)((KeroseneLampBlockEntity)this.te).getTargetRange());
        }
        if (this.prevRange != ((KeroseneLampBlockEntity)this.te).getRange()) {
            this.populateFuelTab();
            this.prevRange = ((KeroseneLampBlockEntity)this.te).getRange();
        }
        super.m_181908_();
        this.rangeLabel.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.range", ((KeroseneLampBlockEntity)this.te).getRange()));
    }

    @Override
    protected void doDelayedAction() {
        this.sendGUIButtonPacketToServer(Integer.toString(this.slider.getValueInt()));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_KEROSENE_LAMP;
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((KeroseneLampBlockEntity)this.te).getTank().getFluidAmount() == 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.keroseneLamp.noFuel", new Object[0]));
        } else if (((KeroseneLampBlockEntity)this.te).getFuelQuality() == 0.0f) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.keroseneLamp.badFuel", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (((KeroseneLampBlockEntity)this.te).getTank().getFluidAmount() < 30 && ((KeroseneLampBlockEntity)this.te).getTank().getFluidAmount() > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.keroseneLamp.lowFuel", new Object[0]));
        }
    }
}

