/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import java.util.List;
import java.util.Optional;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.animation.AnimationRegistry;
import net.bettercombat.client.animation.AttackAnimationSubStack;
import net.bettercombat.client.animation.CustomAnimationPlayer;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.animation.PoseSubStack;
import net.bettercombat.client.animation.StateCollectionHelper;
import net.bettercombat.client.animation.modifier.TransmissionSpeedModifier;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.LivingEntityAccessor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerEntityMixin
extends Player
implements PlayerAttackAnimatable {
    private final AttackAnimationSubStack attackAnimation = new AttackAnimationSubStack(this.createAttackAdjustment());
    private final PoseSubStack mainHandBodyPose = new PoseSubStack((AbstractModifier)this.createPoseAdjustment(), true, true);
    private final PoseSubStack mainHandItemPose = new PoseSubStack(null, false, true);
    private final PoseSubStack offHandBodyPose = new PoseSubStack(null, true, false);
    private final PoseSubStack offHandItemPose = new PoseSubStack(null, false, true);

    public AbstractClientPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile, @Nullable ProfilePublicKey publicKey) {
        super(world, pos, yaw, gameProfile, publicKey);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientLevel world, GameProfile profile, ProfilePublicKey publicKey, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        stack.addAnimLayer(1, (IAnimation)this.offHandItemPose.base);
        stack.addAnimLayer(2, (IAnimation)this.offHandBodyPose.base);
        stack.addAnimLayer(3, (IAnimation)this.mainHandItemPose.base);
        stack.addAnimLayer(4, (IAnimation)this.mainHandBodyPose.base);
        stack.addAnimLayer(2000, (IAnimation)this.attackAnimation.base);
        this.mainHandBodyPose.configure = this::updateAnimationByCurrentActivity;
        this.offHandBodyPose.configure = this::updateAnimationByCurrentActivity;
    }

    @Override
    public void updateAnimationsOnTick() {
        WeaponAttributes offHandAttributes;
        boolean hasActiveAttackAnimation;
        AbstractClientPlayerEntityMixin instance = this;
        Player player = instance;
        boolean isLeftHanded = this.isLeftHanded();
        boolean bl = hasActiveAttackAnimation = this.attackAnimation.base.getAnimation() != null && this.attackAnimation.base.getAnimation().isActive();
        if (player.f_20911_ || player.m_6117_()) {
            this.offHandBodyPose.setPose(null, isLeftHanded);
            this.mainHandBodyPose.setPose(null, isLeftHanded);
            return;
        }
        if (hasActiveAttackAnimation) {
            ((LivingEntityAccessor)player).invokeTurnHead(player.m_6080_(), 0.0f);
        }
        KeyframeAnimation newMainHandPose = null;
        WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(player.m_21205_());
        if (mainHandAttributes != null && mainHandAttributes.pose() != null) {
            newMainHandPose = AnimationRegistry.animations.get(mainHandAttributes.pose());
        }
        KeyframeAnimation newOffHandPose = null;
        if (PlayerAttackHelper.isDualWielding(player) && (offHandAttributes = WeaponRegistry.getAttributes(player.m_21206_())) != null && offHandAttributes.offHandPose() != null) {
            newOffHandPose = AnimationRegistry.animations.get(offHandAttributes.offHandPose());
        }
        this.mainHandItemPose.setPose(newMainHandPose, isLeftHanded);
        this.offHandItemPose.setPose(newOffHandPose, isLeftHanded);
        if (!PlayerAttackHelper.isTwoHandedWielding(player) && (this.isWalking() || this.m_6144_())) {
            newMainHandPose = null;
            newOffHandPose = null;
        }
        this.mainHandBodyPose.setPose(newMainHandPose, isLeftHanded);
        this.offHandBodyPose.setPose(newOffHandPose, isLeftHanded);
    }

    @Override
    public void playAttackAnimation(String name, AnimatedHand animatedHand, float length, float upswing) {
        try {
            KeyframeAnimation animation = AnimationRegistry.animations.get(name);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.updateAnimationByCurrentActivity(copy);
            copy.torso.fullyEnablePart(true);
            copy.head.pitch.setEnabled(false);
            float speed = (float)animation.endTick / length;
            boolean mirror = animatedHand.isOffHand();
            if (this.isLeftHanded()) {
                mirror = !mirror;
            }
            int fadeIn = copy.beginTick;
            float upswingSpeed = speed / BetterCombat.config.getUpswingMultiplier();
            float downwindSpeed = (float)((double)speed * Mth.m_14139_((double)(Math.max((double)BetterCombat.config.getUpswingMultiplier() - 0.5, 0.0) / 0.5), (double)(1.0f - upswing), (double)(upswing / (1.0f - upswing))));
            this.attackAnimation.speed.set(upswingSpeed, List.of(new TransmissionSpeedModifier.Gear(length * upswing, downwindSpeed), new TransmissionSpeedModifier.Gear(length, speed)));
            this.attackAnimation.mirror.setEnabled(mirror);
            CustomAnimationPlayer player = new CustomAnimationPlayer(copy.build(), 0);
            player.setFirstPersonMode(CompatibilityFlags.firstPersonRender() ? FirstPersonMode.THIRD_PERSON_MODEL : FirstPersonMode.NONE);
            player.setFirstPersonConfiguration(this.firstPersonConfig(animatedHand));
            this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AdjustmentModifier createAttackAdjustment() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float offsetZ;
            float offsetY;
            float offsetX;
            float rotationZ;
            float rotationY;
            float rotationX;
            block20: {
                block19: {
                    rotationX = 0.0f;
                    rotationY = 0.0f;
                    rotationZ = 0.0f;
                    offsetX = 0.0f;
                    offsetY = 0.0f;
                    offsetZ = 0.0f;
                    if (!FirstPersonMode.isFirstPersonPass()) break block19;
                    float pitch = player.m_146909_();
                    pitch = (float)Math.toRadians(pitch);
                    switch (partName) {
                        case "body": {
                            rotationX -= pitch;
                            if (pitch < 0.0f) {
                                double offset = Math.abs(Math.sin(pitch));
                                offsetY = (float)((double)offsetY + offset * 0.5);
                                offsetZ = (float)((double)offsetZ - offset);
                                break;
                            }
                            break block20;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                    break block20;
                }
                float pitch = player.m_146909_();
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "body": {
                        rotationX -= pitch * 0.75f;
                        break;
                    }
                    case "rightArm": 
                    case "leftArm": {
                        rotationX += pitch * 0.25f;
                        break;
                    }
                    case "rightLeg": 
                    case "leftLeg": {
                        rotationX = (float)((double)rotationX - (double)pitch * 0.75);
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private AdjustmentModifier createPoseAdjustment() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (!FirstPersonMode.isFirstPersonPass()) {
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        if (this.mainHandItemPose.lastAnimationUsesBodyChannel || !player.m_6144_()) break;
                        offsetY += 4.0f;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private void updateAnimationByCurrentActivity(KeyframeAnimation.AnimationBuilder animation) {
        Pose pose = this.m_20089_();
        switch (pose) {
            case STANDING: {
                break;
            }
            case FALL_FLYING: {
                break;
            }
            case SLEEPING: {
                break;
            }
            case SWIMMING: {
                StateCollectionHelper.configure(animation.rightLeg, false, false);
                StateCollectionHelper.configure(animation.leftLeg, false, false);
                break;
            }
            case SPIN_ATTACK: {
                break;
            }
            case CROUCHING: {
                break;
            }
            case LONG_JUMPING: {
                break;
            }
        }
        if (this.isMounting()) {
            StateCollectionHelper.configure(animation.rightLeg, false, false);
            StateCollectionHelper.configure(animation.leftLeg, false, false);
        }
    }

    private boolean isWalking() {
        return !this.m_21224_() && (this.m_6069_() || this.m_20184_().m_165924_() > 0.03);
    }

    private boolean isMounting() {
        return this.m_20202_() != null;
    }

    public boolean isLeftHanded() {
        return this.m_5737_() == HumanoidArm.LEFT;
    }

    @Override
    public void stopAttackAnimation(float length) {
        IAnimation currentAnimation = this.attackAnimation.base.getAnimation();
        if (currentAnimation != null && currentAnimation instanceof KeyframeAnimationPlayer) {
            int fadeOut = Math.round(length);
            this.attackAnimation.adjustmentModifier.fadeOut(fadeOut);
            this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeOut, (Ease)Ease.INOUTSINE), null);
        }
    }

    private FirstPersonConfiguration firstPersonConfig(AnimatedHand animatedHand) {
        boolean showLeftItem;
        boolean showArms;
        boolean leftHanded = this.m_5737_() == HumanoidArm.LEFT;
        boolean showRightArm = showArms = BetterCombatClient.config.isShowingArmsInFirstPerson;
        boolean showLeftArm = showArms;
        if (animatedHand != AnimatedHand.TWO_HANDED) {
            if (!BetterCombatClient.config.isShowingOtherHandFirstPerson) {
                showRightArm = showArms;
                showLeftArm = false;
            }
            if (leftHanded) {
                showRightArm = !showRightArm;
                showLeftArm = !showLeftArm;
            }
        }
        boolean showRightItem = true;
        if (leftHanded) {
            showRightItem = !showRightItem;
        }
        boolean bl = showLeftItem = !showRightItem;
        if (BetterCombatClient.config.isShowingOtherHandFirstPerson) {
            showRightItem = true;
            showLeftItem = true;
        }
        FirstPersonConfiguration config = new FirstPersonConfiguration(showRightArm, showLeftArm, showRightItem, showLeftItem);
        return config;
    }
}

