/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.handler;

import com.maciej916.maenchants.common.registries.ModEnchantments;
import java.text.DecimalFormat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;

public class HandlerMomentum {
    public static void handlerBreak(BlockEvent.BreakEvent event) {
        String currentBlock;
        Player player = event.getPlayer();
        ItemStack stack = player.m_21120_(player.m_7655_());
        int lvl = stack.getEnchantmentLevel((Enchantment)ModEnchantments.MOMENTUM.get());
        if (lvl == 0) {
            return;
        }
        CompoundTag compound = stack.m_41784_();
        int momentum = compound.m_128451_("momentum");
        String cachedBlock = compound.m_128461_("block");
        if (!cachedBlock.equals(currentBlock = event.getState().m_60734_().m_7705_())) {
            compound.m_128405_("momentum", 0);
            compound.m_128359_("block", currentBlock);
        } else if (momentum < 100) {
            compound.m_128405_("momentum", momentum + 1);
        }
    }

    public static void handlerSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(player.m_7655_());
        int lvl = stack.getEnchantmentLevel((Enchantment)ModEnchantments.MOMENTUM.get());
        if (lvl == 0) {
            return;
        }
        CompoundTag compound = stack.m_41784_();
        int momentum = compound.m_128451_("momentum");
        float oldSpeed = event.getOriginalSpeed();
        float newSpeed = oldSpeed + 0.05f * (float)momentum;
        event.setNewSpeed(newSpeed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlerTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        int lvl = stack.getEnchantmentLevel((Enchantment)ModEnchantments.MOMENTUM.get());
        if (lvl == 0) {
            return;
        }
        CompoundTag compound = stack.m_41784_();
        int momentum = compound.m_128451_("momentum");
        String block = compound.m_128461_("block");
        if (block.equals("")) {
            block = "-";
        }
        double speed = 1.0f + (float)momentum * 0.05f;
        DecimalFormat df = new DecimalFormat("#.##");
        if (momentum < 100) {
            event.getToolTip().add(Component.m_237110_((String)"enchantment.maenchants.momentum.speed", (Object[])new Object[]{df.format(speed)}));
        } else {
            event.getToolTip().add(Component.m_237110_((String)"enchantment.maenchants.momentum.speed_max", (Object[])new Object[]{df.format(speed)}));
        }
        MutableComponent blockName = Component.m_237115_((String)block);
        event.getToolTip().add(Component.m_237110_((String)"enchantment.maenchants.momentum.block", (Object[])new Object[]{blockName}));
    }
}

