/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.capabilities.player;

import com.maciej916.maenchants.common.capabilities.player.IPlayerCapability;
import com.maciej916.maenchants.common.registries.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerCapability
implements IPlayerCapability,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IPlayerCapability> modCapabilityLazyOptional = LazyOptional.of(() -> this);
    private boolean stepAssist = false;
    private boolean nightVision = false;
    private int multiJump = 0;
    private boolean multiJumpSpace = false;
    private boolean excavate = false;
    private int fasterAttack = 0;
    private BlockPos lastBlockPos = BlockPos.f_121853_;

    @Override
    public boolean getStepAssist() {
        return this.stepAssist;
    }

    @Override
    public boolean getNightVision() {
        return this.nightVision;
    }

    @Override
    public int getMultiJump() {
        return this.multiJump;
    }

    @Override
    public boolean getMultiJumpSpace() {
        return this.multiJumpSpace;
    }

    @Override
    public boolean getExcavateActive() {
        return this.excavate;
    }

    @Override
    public void setStepAssist(boolean enabled) {
        this.stepAssist = enabled;
    }

    @Override
    public void setNightVision(boolean enabled) {
        this.nightVision = enabled;
    }

    @Override
    public void setMultiJump(int count) {
        this.multiJump = count;
    }

    @Override
    public void setMultiJumpSpace(boolean enabled) {
        this.multiJumpSpace = enabled;
    }

    @Override
    public void setExcavateActive(boolean enabled) {
        this.excavate = enabled;
    }

    @Override
    public int getFasterAttack() {
        return this.fasterAttack;
    }

    @Override
    public void setFasterAttack(int lvl) {
        this.fasterAttack = lvl;
    }

    @Override
    public void clone(IPlayerCapability capability) {
        this.setStepAssist(capability.getStepAssist());
        this.setNightVision(capability.getNightVision());
        this.setMultiJump(capability.getMultiJump());
        this.setMultiJumpSpace(capability.getMultiJumpSpace());
        this.setExcavateActive(capability.getExcavateActive());
        this.setFasterAttack(capability.getFasterAttack());
        this.setLastBlockPos(capability.getLastBlockPos());
    }

    @Override
    public BlockPos getLastBlockPos() {
        return this.lastBlockPos;
    }

    @Override
    public void setLastBlockPos(BlockPos blockPos) {
        this.lastBlockPos = blockPos;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("stepAssist", this.getStepAssist());
        tag.m_128379_("nightVision", this.getNightVision());
        tag.m_128405_("multiJump", this.getMultiJump());
        tag.m_128379_("multiJumpSpace", this.getMultiJumpSpace());
        tag.m_128379_("excavate", this.getExcavateActive());
        tag.m_128405_("fasterAttack", this.getFasterAttack());
        tag.m_128365_("lastBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getLastBlockPos()));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setStepAssist(nbt.m_128471_("stepAssist"));
        this.setNightVision(nbt.m_128471_("nightVision"));
        this.setMultiJump(nbt.m_128451_("multiJump"));
        this.setMultiJumpSpace(nbt.m_128471_("multiJumpSpace"));
        this.setExcavateActive(nbt.m_128471_("excavate"));
        this.setFasterAttack(nbt.m_128451_("fasterAttack"));
        this.setLastBlockPos(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("lastBlockPos")));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.PLAYER_CAPABILITY) {
            return this.modCapabilityLazyOptional.cast();
        }
        return LazyOptional.empty();
    }
}

