/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class MeltedCobblestone
extends Block {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final int NEIGHBORS_TO_AGE = 4;
    private static final int NEIGHBORS_TO_MELT = 2;

    public MeltedCobblestone() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56742_).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.m_213897_(pState, pLevel, pPos, pRandom);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((pRandom.m_188503_(3) == 0 || this.fewerNeigboursThan((BlockGetter)pLevel, pPos, 4)) && pLevel.m_46803_(pPos) > 11 - (Integer)pState.m_61143_((Property)AGE) - pState.m_60739_((BlockGetter)pLevel, pPos) && this.slightlyMelt(pState, (Level)pLevel, pPos)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
                BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
                if (!blockstate.m_60713_((Block)this) || this.slightlyMelt(blockstate, (Level)pLevel, (BlockPos)blockpos$mutableblockpos)) continue;
                pLevel.m_186460_((BlockPos)blockpos$mutableblockpos, (Block)this, Mth.m_216271_((RandomSource)pRandom, (int)20, (int)40));
            }
        } else {
            pLevel.m_186460_(pPos, (Block)this, Mth.m_216271_((RandomSource)pRandom, (int)20, (int)40));
        }
    }

    private boolean slightlyMelt(BlockState pState, Level pLevel, BlockPos pPos) {
        int i = (Integer)pState.m_61143_((Property)AGE);
        if (i < 3) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.melt(pState, pLevel, pPos);
        return true;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pBlock.m_49966_().m_60713_((Block)this) && this.fewerNeigboursThan((BlockGetter)pLevel, pPos, 2)) {
            this.melt(pState, pLevel, pPos);
        }
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    private boolean fewerNeigboursThan(BlockGetter pLevel, BlockPos pPos, int pNeighborsRequired) {
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
            if (!pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_((Block)this) || ++i < pNeighborsRequired) continue;
            return false;
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.f_41583_;
    }

    protected void melt(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46597_(pPos, Blocks.f_49991_.m_49966_());
        pLevel.m_46586_(pPos, Blocks.f_49991_, pPos);
    }
}

