/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.fluid.PotionFluid;
import cofh.core.init.CoreFluids;
import cofh.lib.fluid.FluidIngredient;
import cofh.thermal.core.util.managers.machine.BottlerRecipeManager;
import cofh.thermal.core.util.recipes.machine.BottlerRecipe;
import cofh.thermal.expansion.compat.jei.TExpJeiPlugin;
import cofh.thermal.expansion.compat.jei.machine.BottlerRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PotionFluidRecipeManagerPlugin
implements IRecipeManagerPlugin {
    private final List<BottlerRecipe> bottlerRecipes = new ArrayList<BottlerRecipe>();

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        return List.of(TExpJeiPlugin.BOTTLER_TYPE);
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (recipeCategory instanceof BottlerRecipeCategory) {
            ItemStack item;
            Optional ingredient;
            ArrayList<BottlerRecipe> retList = new ArrayList<BottlerRecipe>();
            if (focus.getRole() == RecipeIngredientRole.INPUT) {
                FluidStack fluid;
                Optional fluidIngredient = focus.getTypedValue().getIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
                if (fluidIngredient.isPresent() && ((FluidStack)fluidIngredient.get()).getFluid() == CoreFluids.POTION_FLUID.get() && (fluid = (FluidStack)fluidIngredient.get()).hasTag()) {
                    ItemStack item2 = new ItemStack((ItemLike)Items.f_42589_);
                    item2.m_41751_(fluid.getTag().m_6426_());
                    retList.add(this.getDynamicBottlerPotionRecipe(item2, fluid));
                }
            } else if (focus.getRole() == RecipeIngredientRole.OUTPUT && (ingredient = focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK)).isPresent() && ((ItemStack)ingredient.get()).m_41720_() == Items.f_42589_ && (item = (ItemStack)ingredient.get()).m_41782_()) {
                FluidStack fluid = PotionFluid.getPotionFluidFromItem((int)250, (ItemStack)item);
                retList.add(this.getDynamicBottlerPotionRecipe(item, fluid));
            }
            return retList;
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof BottlerRecipeCategory) {
            if (this.bottlerRecipes.isEmpty()) {
                for (Potion potion : ForgeRegistries.POTIONS) {
                    FluidStack fluid;
                    if (potion == null || potion == Potions.f_43599_ || potion == Potions.f_43598_ || (fluid = PotionFluid.getPotionAsFluid((int)250, (Potion)potion)).isEmpty()) continue;
                    ItemStack item = new ItemStack((ItemLike)Items.f_42589_);
                    item.m_41751_(fluid.getTag());
                    this.bottlerRecipes.add(this.getDynamicBottlerPotionRecipe(item, fluid));
                }
            }
            return this.bottlerRecipes;
        }
        return List.of();
    }

    @NotNull
    private BottlerRecipe getDynamicBottlerPotionRecipe(ItemStack item, FluidStack fluid) {
        return new BottlerRecipe(new ResourceLocation("thermal", "bottler_potion_" + item.hashCode()), BottlerRecipeManager.instance().getDefaultEnergy(), 0.0f, List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_})), List.of(FluidIngredient.of((FluidStack[])new FluidStack[]{fluid}).setAmount(250)), List.of(item), List.of(Float.valueOf(1.0f)), List.of());
    }
}

