/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;
import twilightforest.init.TFBlocks;

public class TFCavesCarver
extends WorldCarver<CaveCarverConfiguration> {
    private final boolean isHighlands;
    private final Random rand = new Random();

    public TFCavesCarver(Codec<CaveCarverConfiguration> codec, boolean isHighlands) {
        super(codec);
        this.f_64984_ = ImmutableSet.of((Object)Fluids.f_76193_, (Object)Fluids.f_76195_);
        this.isHighlands = isHighlands;
    }

    public boolean isStartChunk(CaveCarverConfiguration config, RandomSource rand) {
        return rand.m_188501_() <= config.f_67859_;
    }

    public boolean carve(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, RandomSource rand, Aquifer aquifer, ChunkPos accessPos, CarvingMask mask) {
        int i = SectionPos.m_123223_((int)(this.m_65073_() * 2 - 1));
        int j = rand.m_188503_(rand.m_188503_(rand.m_188503_(this.getCaveBound()) + 1) + 1);
        for (int k = 0; k < j; ++k) {
            double x = accessPos.m_151382_(rand.m_188503_(16));
            double y = config.f_159088_.m_213859_(rand, (WorldGenerationContext)ctx);
            double z = accessPos.m_151391_(rand.m_188503_(16));
            double horiz = config.f_159155_.m_214084_(rand);
            double vert = config.f_159156_.m_214084_(rand);
            double floor = config.f_159157_.m_214084_(rand);
            WorldCarver.CarveSkipChecker checker = (p_159202_, p_159203_, p_159204_, p_159205_, p_159206_) -> TFCavesCarver.shouldSkip(p_159203_, p_159204_, p_159205_, floor);
            int l = 1;
            if (rand.m_188503_(4) == 0 && this.isHighlands) {
                double d6 = config.f_159089_.m_214084_(rand);
                float f1 = 1.0f + rand.m_188501_() * 6.0f;
                this.createRoom(ctx, config, access, biomePos, aquifer, x, y, z, f1, d6, mask, checker);
                l += rand.m_188503_(4);
            }
            for (int k1 = 0; k1 < l; ++k1) {
                float f = rand.m_188501_() * ((float)Math.PI * 2);
                float f3 = (rand.m_188501_() - 0.5f) / 4.0f;
                float f2 = this.getThickness(rand);
                int i1 = i - rand.m_188503_(i / 4);
                this.createTunnel(ctx, config, access, biomePos, rand.m_188505_(), aquifer, x, y, z, horiz, vert, f2, f, f3, 0, i1, this.getYScale(), mask, checker);
            }
        }
        return true;
    }

    protected boolean carveBlock(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos posUp, Aquifer aquifer, MutableBoolean isSurface) {
        BlockState blockstate = access.m_8055_((BlockPos)pos);
        if (blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_50195_) || blockstate.m_60713_(Blocks.f_50599_) || blockstate.m_60713_(Blocks.f_152481_)) {
            isSurface.setTrue();
        }
        if (pos.m_123342_() < access.m_141937_() + 6) {
            return false;
        }
        if (!this.m_224910_((CarverConfiguration)config, blockstate) && !TFCavesCarver.m_159423_((CarverConfiguration)config)) {
            return false;
        }
        BlockState blockstate2 = this.m_159418_(ctx, (CarverConfiguration)config, (BlockPos)pos, aquifer);
        if (blockstate2 == null) {
            return false;
        }
        if (aquifer.m_142203_() && !blockstate2.m_60819_().m_76178_()) {
            access.m_8113_((BlockPos)pos);
        }
        for (Direction facing : Direction.values()) {
            BlockPos posDown;
            FluidState aboveSurface = access.m_6425_(posUp.m_121955_((Vec3i)pos.m_7918_(0, 1, 0)));
            FluidState areaAround = access.m_6425_(posUp.m_121945_(facing));
            FluidState areaAboveAround = access.m_6425_(posUp.m_121955_((Vec3i)pos.m_7918_(0, 1, 0).m_121945_(facing)));
            if (areaAround.m_205070_(FluidTags.f_13131_) || areaAboveAround.m_205070_(FluidTags.f_13131_) || aboveSurface.m_205070_(FluidTags.f_13131_)) {
                return false;
            }
            if (this.rand.nextInt(10) == 0 && access.m_8055_((BlockPos)pos).m_60795_() && access.m_8055_(pos.m_121945_(facing)).m_204336_(BlockTags.f_13061_) && this.isHighlands) {
                access.m_6978_(pos.m_121945_(facing), ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), false);
            }
            access.m_6978_((BlockPos)pos, f_64980_, false);
            if ((access.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13061_) || access.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_)) && access.m_8055_((BlockPos)pos).m_60795_() && !this.isHighlands) {
                switch (this.rand.nextInt(5)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        access.m_6978_(pos.m_7494_(), Blocks.f_50493_.m_49966_(), false);
                        break;
                    }
                    case 3: {
                        access.m_6978_(pos.m_7494_(), Blocks.f_152549_.m_49966_(), false);
                        break;
                    }
                    case 4: {
                        access.m_6978_(pos.m_7494_(), Blocks.f_50546_.m_49966_(), false);
                    }
                }
            }
            if (!isSurface.isTrue() || !access.m_8055_(posDown = pos.m_122159_((Vec3i)pos, Direction.DOWN).m_7495_()).m_60713_(Blocks.f_50493_)) continue;
            ctx.m_190646_(biomePos, access, posDown, !blockstate2.m_60819_().m_76178_()).ifPresent(state -> {
                access.m_6978_(posDown, state, false);
                if (!state.m_60819_().m_76178_()) {
                    access.m_8113_(posDown);
                }
            });
        }
        return true;
    }

    protected int getCaveBound() {
        return 15;
    }

    protected float getThickness(RandomSource rand) {
        float f = rand.m_188501_() * 2.0f + rand.m_188501_();
        if (rand.m_188503_(10) == 0) {
            f *= rand.m_188501_() * rand.m_188501_() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double getYScale() {
        return 1.0;
    }

    protected void createRoom(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, Aquifer aquifer, double posX, double posY, double posZ, float radius, double horizToVertRatio, CarvingMask mask, WorldCarver.CarveSkipChecker checker) {
        double d0 = 1.5 + (double)(Mth.m_14031_((float)1.5707964f) * radius);
        double d1 = d0 * horizToVertRatio;
        this.m_190753_(ctx, (CarverConfiguration)config, access, biomePos, aquifer, posX + 1.0, posY, posZ, d0, d1, mask, checker);
    }

    protected void createTunnel(CarvingContext ctx, CaveCarverConfiguration config, ChunkAccess access, Function<BlockPos, Holder<Biome>> biomePos, long seed, Aquifer aquifer, double posX, double posY, double posZ, double horizMult, double vertMult, float thickness, float yaw, float pitch, int branchIndex, int branchCount, double horizToVertRatio, CarvingMask mask, WorldCarver.CarveSkipChecker checker) {
        Random random = new Random(seed);
        int i = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean flag = random.nextInt(6) == 0;
        float f = 0.0f;
        float f1 = 0.0f;
        for (int j = branchIndex; j < branchCount; ++j) {
            double d0 = 1.5 + (double)(Mth.m_14031_((float)((float)Math.PI * (float)j / (float)branchCount)) * thickness);
            double d1 = d0 * horizToVertRatio;
            float f2 = Mth.m_14089_((float)pitch);
            posX += (double)(Mth.m_14089_((float)yaw) * f2);
            posY += (double)Mth.m_14031_((float)pitch);
            posZ += (double)(Mth.m_14031_((float)yaw) * f2);
            pitch *= flag ? 0.92f : 0.7f;
            pitch += f1 * 0.1f;
            yaw += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j == i && thickness > 1.0f) {
                this.createTunnel(ctx, config, access, biomePos, random.nextLong(), aquifer, posX, posY, posZ, horizMult, vertMult, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, checker);
                this.createTunnel(ctx, config, access, biomePos, random.nextLong(), aquifer, posX, posY, posZ, horizMult, vertMult, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, checker);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!TFCavesCarver.m_159367_((ChunkPos)access.m_7697_(), (double)posX, (double)posZ, (int)j, (int)branchCount, (float)thickness)) {
                return;
            }
            this.m_190753_(ctx, (CarverConfiguration)config, access, biomePos, aquifer, posX, posY, posZ, d0 * horizMult, d1 * vertMult, mask, checker);
        }
    }

    private static boolean shouldSkip(double posX, double posY, double posZ, double minY) {
        if (posY <= minY) {
            return true;
        }
        return posX * posX + posY * posY + posZ * posZ >= 1.0;
    }
}

