/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class LampOfCindersItem
extends Item {
    private static final int FIRING_TIME = 12;

    public LampOfCindersItem(Item.Properties props) {
        super(props);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (this.burnBlock(world, pos)) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, player.m_21120_(context.m_43724_()));
            }
            if (player != null) {
                player.m_5496_((SoundEvent)TFSounds.LAMP_BURN.get(), 0.5f, 1.5f);
            }
            for (int i = 0; i < 10; ++i) {
                float dx = (float)pos.m_123341_() + 0.5f + (world.m_213780_().m_188501_() - world.m_213780_().m_188501_()) * 0.75f;
                float dy = (float)pos.m_123342_() + 0.5f + (world.m_213780_().m_188501_() - world.m_213780_().m_188501_()) * 0.75f;
                float dz = (float)pos.m_123343_() + 0.5f + (world.m_213780_().m_188501_() - world.m_213780_().m_188501_()) * 0.75f;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean burnBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)TFBlocks.BROWN_THORNS.get()) || state.m_60713_((Block)TFBlocks.GREEN_THORNS.get())) {
            level.m_46597_(pos, ((Block)TFBlocks.BURNT_THORNS.get()).m_152465_(state));
            return true;
        }
        return false;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int useRemaining) {
        int useTime = this.m_8105_(stack) - useRemaining;
        if (useTime > 12 && stack.m_41773_() + 1 < this.getMaxDamage(stack)) {
            this.doBurnEffect(level, living);
        }
    }

    private void doBurnEffect(Level level, LivingEntity living) {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)living.f_19790_), Mth.m_14107_((double)(living.f_19791_ + (double)living.m_20192_())), Mth.m_14107_((double)living.f_19792_));
        int range = 4;
        if (!level.m_5776_()) {
            level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)TFSounds.LAMP_BURN.get(), living.m_5720_(), 1.5f, 0.8f);
            for (int dx = -range; dx <= range; ++dx) {
                for (int dy = -range; dy <= range; ++dy) {
                    for (int dz = -range; dz <= range; ++dz) {
                        this.burnBlock(level, pos.m_7918_(dx, dy, dz));
                    }
                }
            }
        }
        if (living instanceof Player) {
            for (int i = 0; i < 6; ++i) {
                BlockPos rPos = pos.m_7918_(level.m_213780_().m_188503_(range) - level.m_213780_().m_188503_(range), level.m_213780_().m_188503_(2), level.m_213780_().m_188503_(range) - level.m_213780_().m_188503_(range));
                level.m_5898_((Player)living, 2004, rPos, 0);
            }
            for (LivingEntity targets : level.m_45976_(LivingEntity.class, new AABB(living.m_20183_()).m_82400_(4.0))) {
                if (targets instanceof Player) continue;
                targets.m_20254_(5);
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }
}

