/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.goal.BreathAttackGoal;
import twilightforest.entity.monster.HostileWolf;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class WinterWolf
extends HostileWolf
implements IBreathAttacker {
    private static final EntityDataAccessor<Boolean> BREATH_FLAG = SynchedEntityData.m_135353_(WinterWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float BREATH_DAMAGE = 2.0f;

    public WinterWolf(EntityType<? extends WinterWolf> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new BreathAttackGoal<WinterWolf>(this, 5.0f, 30, 0.1f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return HostileWolf.registerAttributes().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREATH_FLAG, (Object)false);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isBreathing()) {
            if (this.m_9236_().m_5776_()) {
                this.spawnBreathParticles();
            }
            this.playBreathSound();
        }
    }

    private void spawnBreathParticles() {
        Vec3 look = this.m_20154_();
        double dist = 0.5;
        double px = this.m_20185_() + look.m_7096_() * 0.5;
        double py = this.m_20186_() + 1.25 + look.m_7098_() * 0.5;
        double pz = this.m_20189_() + look.m_7094_() * 0.5;
        for (int i = 0; i < 10; ++i) {
            double dx = look.m_7096_();
            double dy = look.m_7098_();
            double dz = look.m_7094_();
            double spread = 5.0 + this.m_217043_().m_188500_() * 2.5;
            double velocity = 3.0 + this.m_217043_().m_188500_() * 0.15;
            dx += this.m_217043_().m_188583_() * 0.0075 * spread;
            dy += this.m_217043_().m_188583_() * 0.0075 * spread;
            dz += this.m_217043_().m_188583_() * 0.0075 * spread;
            this.m_9236_().m_7106_((ParticleOptions)TFParticleType.SNOW.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
        }
    }

    @Override
    protected SoundEvent getTargetSound() {
        return (SoundEvent)TFSounds.WINTER_WOLF_TARGET.get();
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.WINTER_WOLF_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)TFSounds.WINTER_WOLF_HURT.get();
    }

    private void playBreathSound() {
        this.m_5496_((SoundEvent)TFSounds.WINTER_WOLF_SHOOT.get(), this.m_217043_().m_188501_() * 0.5f, this.m_217043_().m_188501_() * 0.5f);
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.WINTER_WOLF_DEATH.get();
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 0.6f;
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.f_19804_.m_135370_(BREATH_FLAG);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.f_19804_.m_135381_(BREATH_FLAG, (Object)flag);
    }

    @Override
    public void doBreathAttack(Entity target) {
        target.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
    }

    public static boolean canSpawnHere(EntityType<? extends WinterWolf> entity, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        Optional key = accessor.m_204166_(pos).m_203543_();
        return accessor.m_46791_() != Difficulty.PEACEFUL && Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST)) || Monster.m_219009_((ServerLevelAccessor)accessor, (BlockPos)pos, (RandomSource)random);
    }
}

