/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import twilightforest.TwilightForestMod;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFDimensionSettings;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructureSets;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFGenerationSettings;
import twilightforest.world.registration.biomes.BiomeMaker;

public record WorldGenerator(DataGenerator generator) implements DataProvider
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<ResourceKey<Biome>, ImmutableSet<TFLandmark>> BIOME_FEATURES_SETS = new ImmutableMap.Builder().put(BiomeKeys.ENCHANTED_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.QUEST_GROVE)).put(BiomeKeys.SWAMP, (Object)ImmutableSet.of((Object)TFLandmark.LABYRINTH)).put(BiomeKeys.FIRE_SWAMP, (Object)ImmutableSet.of((Object)TFLandmark.HYDRA_LAIR)).put(BiomeKeys.DARK_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.KNIGHT_STRONGHOLD)).put(BiomeKeys.DARK_FOREST_CENTER, (Object)ImmutableSet.of((Object)TFLandmark.DARK_TOWER)).put(BiomeKeys.SNOWY_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.YETI_CAVE)).put(BiomeKeys.GLACIER, (Object)ImmutableSet.of((Object)TFLandmark.ICE_TOWER)).put(BiomeKeys.HIGHLANDS, (Object)ImmutableSet.of((Object)TFLandmark.TROLL_CAVE)).put(BiomeKeys.FINAL_PLATEAU, (Object)ImmutableSet.of((Object)TFLandmark.FINAL_CASTLE)).build();

    public void m_213708_(CachedOutput cache) {
        Path path = this.generator.m_123916_();
        RegistryAccess registryaccess = BuiltinRegistries.f_206379_;
        RegistryOps dynamicops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryaccess);
        HolderSet<StructureSet> structureOverrides = this.makeStructureList();
        Registry<LevelStem> twilight = this.registerTFSettings(registryaccess, structureOverrides);
        MappedRegistry biomeRegistry = new MappedRegistry(Registry.f_122885_, Lifecycle.experimental(), null);
        BiomeMaker.registerUnderground((Registry<Biome>)biomeRegistry, true);
        Map<ResourceLocation, Biome> biomes = this.getBiomes();
        biomes.forEach((arg_0, arg_1) -> WorldGenerator.lambda$run$0((WritableRegistry)biomeRegistry, arg_0, arg_1));
        StreamSupport.stream(RegistryAccess.m_194613_().spliterator(), false).filter(r -> registryaccess.m_142664_(r.f_123101_()).isPresent() && !r.f_123101_().equals((Object)Registry.f_122885_)).forEach(arg_0 -> WorldGenerator.lambda$run$2(cache, path, registryaccess, (DynamicOps)dynamicops, arg_0));
        LOGGER.info("Dumping real BIOME_REGISTRY");
        WorldGenerator.dumpRegistry(path, cache, (DynamicOps<JsonElement>)dynamicops, Registry.f_122885_, biomeRegistry, Biome.f_47429_);
        LOGGER.info("Dumping real LEVEL_STEM_REGISTRY");
        WorldGenerator.dumpRegistry(path, cache, (DynamicOps<JsonElement>)dynamicops, Registry.f_122820_, twilight, LevelStem.f_63970_);
    }

    private HolderSet<StructureSet> makeStructureList() {
        return HolderSet.m_205803_(Function.identity(), TFStructureSets.STRUCTURE_SETS.getEntries().stream().map(RegistryObject::getHolder).filter(Optional::isPresent).map(Optional::get).toList());
    }

    private static <T> void dumpRegistryCap(CachedOutput cache, Path path, RegistryAccess access, DynamicOps<JsonElement> ops, RegistryAccess.RegistryData<T> data) {
        LOGGER.info("Dumping: {}", (Object)data.f_123101_());
        WorldGenerator.dumpRegistry(path, cache, ops, data.f_123101_(), access.m_206191_(data.f_123101_()), data.f_123102_());
    }

    private Registry<LevelStem> registerTFSettings(RegistryAccess access, HolderSet<StructureSet> structureOverrides) {
        MappedRegistry writableregistry = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental(), null);
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        Holder<Biome> undergroundHolder = BiomeMaker.registerUnderground((Registry<Biome>)biomeRegistry, false);
        Holder noiseGenSettings = access.m_175515_(Registry.f_122878_).m_206081_(TFDimensionSettings.TWILIGHT_NOISE_GEN.getKey());
        NoiseBasedChunkGenerator forestChunkGen = new NoiseBasedChunkGenerator(access.m_175515_(Registry.f_211073_), access.m_175515_(Registry.f_194568_), (BiomeSource)new TFBiomeProvider(0L, (Registry<Biome>)biomeRegistry, undergroundHolder, BiomeMaker.makeBiomeList((Registry<Biome>)biomeRegistry, undergroundHolder), -1.25f, 2.5f), noiseGenSettings);
        writableregistry.m_203505_(TFGenerationSettings.WORLDGEN_KEY, (Object)new LevelStem((Holder)TFDimensionSettings.TWILIGHT_DIM_TYPE.getHolder().get(), (ChunkGenerator)new ChunkGeneratorTwilight((ChunkGenerator)forestChunkGen, (Registry<StructureSet>)access.m_175515_(Registry.f_211073_), structureOverrides, (Holder<NoiseGeneratorSettings>)noiseGenSettings, true, Optional.of(19), BIOME_FEATURES_SETS)), Lifecycle.experimental());
        return writableregistry;
    }

    private Registry<LevelStem> registerSkylightSettings(RegistryAccess access, HolderSet<StructureSet> structureOverrides) {
        MappedRegistry writableregistry = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental(), null);
        MappedRegistry biomeRegistry = new MappedRegistry(Registry.f_122885_, Lifecycle.experimental(), null);
        Holder<Biome> undergroundHolder = BiomeMaker.registerUnderground((Registry<Biome>)biomeRegistry, false);
        Holder noiseGenSettings = access.m_175515_(Registry.f_122878_).m_206081_(TFDimensionSettings.SKYLIGHT_NOISE_GEN.getKey());
        NoiseBasedChunkGenerator forestChunkGen = new NoiseBasedChunkGenerator(access.m_175515_(Registry.f_211073_), access.m_175515_(Registry.f_194568_), (BiomeSource)new TFBiomeProvider(0L, (Registry<Biome>)biomeRegistry, undergroundHolder, BiomeMaker.makeBiomeList((Registry<Biome>)biomeRegistry, undergroundHolder), -1.25f, 2.5f), noiseGenSettings);
        writableregistry.m_203505_(ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)TwilightForestMod.prefix("skylight_forest")), (Object)new LevelStem((Holder)TFDimensionSettings.TWILIGHT_DIM_TYPE.getHolder().get(), (ChunkGenerator)new ChunkGeneratorTwilight((ChunkGenerator)forestChunkGen, (Registry<StructureSet>)access.m_175515_(Registry.f_211073_), structureOverrides, (Holder<NoiseGeneratorSettings>)noiseGenSettings, true, Optional.of(16), BIOME_FEATURES_SETS)), Lifecycle.stable());
        return writableregistry;
    }

    private static <E, T extends Registry<E>> void dumpRegistry(Path path, CachedOutput cache, DynamicOps<JsonElement> ops, ResourceKey<? extends T> key, T registry, Encoder<E> encoder) {
        for (Map.Entry entry : registry.m_6579_()) {
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("twilightforest")) continue;
            LOGGER.info("\t\t{}", (Object)((ResourceKey)entry.getKey()).m_135782_().m_135815_());
            Path otherPath = WorldGenerator.createPath(path, key.m_135782_(), ((ResourceKey)entry.getKey()).m_135782_());
            WorldGenerator.dumpValue(otherPath, cache, ops, encoder, entry.getValue());
        }
    }

    private static <E> void dumpValue(Path path, CachedOutput cache, DynamicOps<JsonElement> ops, Encoder<E> encoder, E entry) {
        try {
            Optional optional = encoder.encodeStart(ops, entry).resultOrPartial(p_206405_ -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, p_206405_));
            if (optional.isPresent()) {
                JsonObject object;
                if (((JsonElement)optional.get()).isJsonObject() && (object = ((JsonElement)optional.get()).getAsJsonObject()).has("generator") && object.get("generator").isJsonObject()) {
                    JsonObject wrapped_generator;
                    JsonObject generator = object.getAsJsonObject("generator");
                    if (generator.has("use_overworld_seed")) {
                        generator.remove("use_overworld_seed");
                        generator.addProperty("use_overworld_seed", Boolean.valueOf(true));
                    }
                    if (generator.has("wrapped_generator") && (wrapped_generator = generator.getAsJsonObject("wrapped_generator")).has("biome_source")) {
                        wrapped_generator.getAsJsonObject("biome_source").remove("seed");
                    }
                }
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save element {}", (Object)path, (Object)ioexception);
        }
    }

    private static Path createPath(Path path, ResourceLocation registry, ResourceLocation entry) {
        return path.resolve("data").resolve(entry.m_135827_()).resolve(registry.m_135815_()).resolve(entry.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Twilight Forest Worldgen";
    }

    private Map<ResourceLocation, Biome> getBiomes() {
        return BiomeMaker.BIOMES.entrySet().stream().collect(Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).m_135782_(), Map.Entry::getValue));
    }

    private static /* synthetic */ void lambda$run$2(CachedOutput cache, Path path, RegistryAccess registryaccess, DynamicOps dynamicops, RegistryAccess.RegistryData data) {
        WorldGenerator.dumpRegistryCap(cache, path, registryaccess, (DynamicOps<JsonElement>)dynamicops, data);
    }

    private static /* synthetic */ void lambda$run$0(WritableRegistry biomeRegistry, ResourceLocation rl, Biome biome) {
        biomeRegistry.m_203505_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)rl), (Object)biome, Lifecycle.experimental());
    }
}

