/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector3f;

public class FogUniforms {
    private FogUniforms() {
    }

    public static void addFogUniforms(DynamicUniformHolder uniforms, FogMode fogMode) {
        if (fogMode == FogMode.OFF) {
            uniforms.uniform1f(UniformUpdateFrequency.ONCE, "fogDensity", () -> 0.0f);
            uniforms.uniform1i(UniformUpdateFrequency.ONCE, "fogMode", () -> 0);
            uniforms.uniform1i(UniformUpdateFrequency.ONCE, "fogShape", () -> -1);
        } else if (fogMode == FogMode.PER_VERTEX || fogMode == FogMode.PER_FRAGMENT) {
            uniforms.uniform1i("fogMode", () -> {
                float fogDensity = CapturedRenderingState.INSTANCE.getFogDensity();
                if (fogDensity < 0.0f) {
                    return 9729;
                }
                return 2049;
            }, listener -> {});
        }
        uniforms.uniform1f("fogDensity", () -> Math.max(0.0f, CapturedRenderingState.INSTANCE.getFogDensity()), notifier -> {});
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "fogShape", () -> RenderSystem.m_202041_() == FogShape.CYLINDER ? 1 : 0);
        uniforms.uniform1f("fogStart", RenderSystem::m_157200_, listener -> StateUpdateNotifiers.fogStartNotifier.setListener(listener));
        uniforms.uniform1f("fogEnd", RenderSystem::m_157199_, listener -> StateUpdateNotifiers.fogEndNotifier.setListener(listener));
        uniforms.uniform3f(UniformUpdateFrequency.PER_FRAME, "fogColor", () -> {
            float[] fogColor = RenderSystem.m_157198_();
            return new Vector3f(fogColor[0], fogColor[1], fogColor[2]);
        });
    }
}

