/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.networking;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.client.handler.ClientMessageHandler;
import dev.felnull.otyacraftengine.networking.PacketMessage;
import dev.felnull.otyacraftengine.networking.existence.BlockEntityExistence;
import dev.felnull.otyacraftengine.networking.existence.ItemExistence;
import dev.felnull.otyacraftengine.server.handler.ServerMessageHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class OEPackets {
    public static final ResourceLocation BLOCK_ENTITY_INSTRUCTION = new ResourceLocation("otyacraftengine", "block_entity_instruction");
    public static final ResourceLocation BLOCK_ENTITY_INSTRUCTION_RETURN = new ResourceLocation("otyacraftengine", "block_entity_instruction_return");
    public static final ResourceLocation ITEM_INSTRUCTION = new ResourceLocation("otyacraftengine", "item_instruction");
    public static final ResourceLocation ITEM_INSTRUCTION_RETURN = new ResourceLocation("otyacraftengine", "item_instruction_return");

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)BLOCK_ENTITY_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onBlockEntityInstructionMessage(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)ITEM_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onItemInstructionMessage(new ItemInstructionMessage(friendlyByteBuf), packetContext));
    }

    public static void clientInit() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)BLOCK_ENTITY_INSTRUCTION_RETURN, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onBlockEntityInstructionReturn(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)ITEM_INSTRUCTION_RETURN, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onItemInstructionReturn(new ItemInstructionMessage(friendlyByteBuf), packetContext));
    }

    public record ItemInstructionMessage(UUID instructionScreenID, ItemExistence itemExistence, String name, CompoundTag data) implements PacketMessage
    {
        public ItemInstructionMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), ItemExistence.read(bf), bf.m_130277_(), bf.m_130260_());
        }

        @Override
        public FriendlyByteBuf toFBB(FriendlyByteBuf buf) {
            buf.m_130077_(this.instructionScreenID);
            this.itemExistence.write(buf);
            buf.m_130070_(this.name);
            buf.m_130079_(this.data);
            return buf;
        }
    }

    public record BlockEntityInstructionMessage(UUID instructionScreenID, BlockEntityExistence blockEntityExistence, String name, CompoundTag data) implements PacketMessage
    {
        public BlockEntityInstructionMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), BlockEntityExistence.read(bf), bf.m_130277_(), bf.m_130260_());
        }

        @Override
        public FriendlyByteBuf toFBB(FriendlyByteBuf buf) {
            buf.m_130077_(this.instructionScreenID);
            this.blockEntityExistence.write(buf);
            buf.m_130070_(this.name);
            buf.m_130079_(this.data);
            return buf;
        }
    }
}

