/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.DataGeneratorType;
import dev.felnull.otyacraftengine.data.provider.DataProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import java.util.List;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public abstract class TagProviderWrapper<T, A extends TagProviderAccess<T>>
extends DataProviderWrapper<TagsProvider<T>> {
    public TagProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    public abstract void generateTag(A var1);

    @Override
    public DataGeneratorType getGeneratorType() {
        return DataGeneratorType.SERVER;
    }

    public static interface TagAppenderWrapper<T> {
        public TagAppenderWrapper<T> add(T var1);

        public TagAppenderWrapper<T> add(ResourceKey<T> ... var1);

        public TagAppenderWrapper<T> addOptional(ResourceLocation var1);

        public TagAppenderWrapper<T> addTagHolder(TagKey<T> var1);

        default public TagAppenderWrapper<T> addTagHolder(ManualTagHolder<T> tagHolder) {
            TagProviderAccess<T> tp = this.getTagProvider();
            if (tp != null) {
                tagHolder.registering(tp);
            }
            return this.addTagHolder(tagHolder.getKey());
        }

        default public TagAppenderWrapper<T> addVanillaTag(TagKey<T> tagKey) {
            return this.addTagHolder(tagKey);
        }

        public TagAppenderWrapper<T> addOptionalTag(ResourceLocation var1);

        public TagAppenderWrapper<T> add(T ... var1);

        default public TagAppenderWrapper<T> addTags(List<TagKey<T>> tagKeys) {
            TagAppenderWrapper<T> appenderWrapper = this;
            for (TagKey<T> tagKey : tagKeys) {
                appenderWrapper = appenderWrapper.addTagHolder(tagKey);
            }
            return appenderWrapper;
        }

        default public TagAppenderWrapper<T> addTagHolders(List<ManualTagHolder<T>> tagHolders) {
            TagAppenderWrapper<T> appenderWrapper = this;
            for (ManualTagHolder<T> tagHolder : tagHolders) {
                appenderWrapper = appenderWrapper.addTagHolder(tagHolder);
            }
            return appenderWrapper;
        }

        default public TagAppenderWrapper<T> addOptionalTag(ResourceLocation ... resourceLocations) {
            TagAppenderWrapper<T> appenderWrapper = this;
            for (ResourceLocation resourceLocation : resourceLocations) {
                appenderWrapper = appenderWrapper.addOptionalTag(resourceLocation);
            }
            return appenderWrapper;
        }

        default public TagProviderAccess<T> getTagProvider() {
            return null;
        }
    }

    public static interface TagProviderAccess<T> {
        public TagAppenderWrapper<T> tag(TagKey<T> var1);
    }
}

