/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.planter;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingPlantation;
import com.minecolonies.coremod.colony.jobs.JobPlanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPlanter
extends AbstractEntityAICrafting<JobPlanter, BuildingPlantation> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final Integer PLANT_TO_REQUEST = 16;
    private static final double XP_PER_HARVEST = 1.0;
    private BuildingPlantation.PlantationSoilPosition plantableSoilPos;

    public EntityAIWorkPlanter(@NotNull JobPlanter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.PLANTATION_MOVE_TO_SOIL, this::moveToSoil, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_CHECK_SOIL, this::checkSoil, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_CLEAR_OBSTACLE, this::clearObstacle, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_FARM, this::farm, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_PLANT, this::plant, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.CRAFT || this.getState() == AIWorkerState.PLANTATION_FARM || this.getState() == AIWorkerState.PLANTATION_PLANT || this.getState() == AIWorkerState.PLANTATION_CHECK_SOIL || this.getState() == AIWorkerState.PLANTATION_MOVE_TO_SOIL || this.getState() == AIWorkerState.PLANTATION_CLEAR_OBSTACLE ? "working" : "");
    }

    private IAIState plant() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_())) {
            return this.getState();
        }
        ItemStack currentStack = new ItemStack((ItemLike)this.plantableSoilPos.getCombination().getItem());
        int plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41656_(currentStack));
        if (plantInInv <= 0) {
            return AIWorkerState.START_WORKING;
        }
        if (this.world.m_46597_(this.plantableSoilPos.getPosition().m_7494_(), BlockUtils.getBlockStateFromStack((ItemStack)currentStack))) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), currentStack);
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState clearObstacle() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.isItemPositionAir(this.plantableSoilPos)) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_())) {
            return this.getState();
        }
        if (!this.holdEfficientTool(this.world.m_8055_(this.plantableSoilPos.getPosition().m_7494_()), this.plantableSoilPos.getPosition().m_7494_())) {
            return AIWorkerState.START_WORKING;
        }
        if (this.positionHasInvalidBlock(this.plantableSoilPos)) {
            this.mineBlock(this.plantableSoilPos.getPosition().m_7494_());
            return this.getState();
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState farm() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.isItemPositionAir(this.plantableSoilPos)) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_())) {
            return this.getState();
        }
        if (!this.holdEfficientTool(this.world.m_8055_(this.plantableSoilPos.getPosition().m_7494_()), this.plantableSoilPos.getPosition().m_7494_())) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.positionHasInvalidBlock(this.plantableSoilPos)) {
            this.mineBlock(this.plantableSoilPos.getPosition().m_7494_());
            return this.getState();
        }
        for (ItemEntity item : this.world.m_45976_(ItemEntity.class, new AABB(this.worker.m_20183_()).m_82363_(4.0, 1.0, 4.0).m_82363_(-4.0, -1.0, -4.0))) {
            if (item == null) continue;
            this.worker.getCitizenItemHandler().tryPickupItemEntity(item);
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.START_WORKING;
    }

    private IAIState checkSoil() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        BuildingPlantation plantation = (BuildingPlantation)this.building;
        List<Item> availablePlants = plantation.getAvailablePlants();
        if (this.isItemPositionAir(this.plantableSoilPos)) {
            int plantInBuilding;
            Item currentItem = this.plantableSoilPos.getCombination().getItem();
            ItemStack currentStack = new ItemStack((ItemLike)currentItem);
            if (!availablePlants.contains(currentItem)) {
                return AIWorkerState.START_WORKING;
            }
            int plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41656_(currentStack));
            if (plantInInv + (plantInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, itemStack -> itemStack.m_41656_(currentStack))) <= 0) {
                this.requestPlantable(currentItem);
                return AIWorkerState.START_WORKING;
            }
            if (plantInInv == 0 && plantInBuilding > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(itemStack -> itemStack.m_41656_(currentStack), Math.min(plantInBuilding, PLANT_TO_REQUEST));
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            return AIWorkerState.PLANTATION_PLANT;
        }
        if (this.positionHasInvalidBlock(this.plantableSoilPos)) {
            return AIWorkerState.PLANTATION_CLEAR_OBSTACLE;
        }
        if (this.isSufficientHeight(this.plantableSoilPos) || !availablePlants.contains(this.plantableSoilPos.getCombination().getItem())) {
            return AIWorkerState.PLANTATION_FARM;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState moveToSoil() {
        if (this.plantableSoilPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.plantableSoilPos.getPosition().m_7494_(), 8)) {
            return this.getState();
        }
        return AIWorkerState.PLANTATION_CHECK_SOIL;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    public Class<BuildingPlantation> getExpectedBuildingClass() {
        return BuildingPlantation.class;
    }

    @Override
    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (!((JobPlanter)this.job).getTaskQueue().isEmpty() && ((JobPlanter)this.job).getCurrentTask() != null) {
            return this.getNextCraftingState();
        }
        if (!((BuildingPlantation)this.building).isInBuilding(this.worker.m_20183_()) && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobPlanter)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        BuildingPlantation plantation = (BuildingPlantation)this.building;
        List<BuildingPlantation.PlantationSoilPosition> soilPositions = plantation.getAllSoilPositions();
        if (soilPositions.isEmpty()) {
            Log.getLogger().warn("Planter building returned 0 available soil positions, schematic is " + plantation.getSchematicName() + ", please report this to the developer!");
            return AIWorkerState.START_WORKING;
        }
        int soilPositionIndex = this.worker.m_217043_().m_188503_(soilPositions.size());
        this.plantableSoilPos = soilPositions.get(soilPositionIndex);
        return AIWorkerState.PLANTATION_MOVE_TO_SOIL;
    }

    private void requestPlantable(Item current) {
        if (!((BuildingPlantation)this.building).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), q -> q.getRequest() instanceof Stack && ((Stack)q.getRequest()).getStack().m_41720_() == current)) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((ItemLike)current, PLANT_TO_REQUEST.intValue())));
        }
    }

    private boolean isItemPositionAir(BuildingPlantation.PlantationSoilPosition plantationSoilPosition) {
        Block foundBlock = this.world.m_8055_(plantationSoilPosition.getPosition().m_6630_(1)).m_60734_();
        return foundBlock instanceof AirBlock;
    }

    private boolean positionHasInvalidBlock(BuildingPlantation.PlantationSoilPosition plantationSoilPosition) {
        Block foundBlock = this.world.m_8055_(plantationSoilPosition.getPosition().m_6630_(1)).m_60734_();
        return plantationSoilPosition.getCombination().getBlock() != foundBlock;
    }

    private boolean isSufficientHeight(BuildingPlantation.PlantationSoilPosition plantationSoilPosition) {
        BlockPos position = plantationSoilPosition.getPosition();
        int minLength = plantationSoilPosition.getCombination().getMinimumLength();
        for (int i = 1; i <= minLength; ++i) {
            if (this.world.m_8055_(position.m_6630_(i)).m_60734_() == plantationSoilPosition.getCombination().getBlock()) continue;
            return false;
        }
        return true;
    }
}

