/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.loot;

import cofh.lib.util.random.WeightedRandomDrop;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.cultivation.config.ThermalCropConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class GrassLootModifier
extends LootModifier {
    public static final Codec<GrassLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.listOf().fieldOf("seeds").forGetter(m -> m.seeds)).apply((Applicative)inst, GrassLootModifier::new));
    private final List<String> seeds;
    private final List<WeightedRandomDrop> seedDrops = new ArrayList<WeightedRandomDrop>();

    public GrassLootModifier(LootItemCondition[] conditionsIn, List<String> seeds) {
        super(conditionsIn);
        this.seeds = seeds;
        this.addEntry(Items.f_42404_, 160);
        for (String seed : this.seeds) {
            this.addEntry(seed, 20);
        }
    }

    public void addEntry(Item seed, int weight) {
        this.seedDrops.add(new WeightedRandomDrop(seed, weight));
    }

    public void addEntry(String seed, int weight) {
        this.seedDrops.add(new WeightedRandomDrop((Item)ThermalCore.ITEMS.get(seed), weight));
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!ThermalCropConfig.dropSeedsFromGrass.get().booleanValue()) {
            return generatedLoot;
        }
        ObjectArrayList newLoot = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            if (stack.m_41720_() == Items.f_42404_) {
                WeightedRandom.m_216822_((RandomSource)context.m_230907_(), this.seedDrops).ifPresent(e -> newLoot.add((Object)e.toItemStack(stack.m_41613_())));
                continue;
            }
            newLoot.add((Object)stack);
        }
        return newLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

