/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;

public class MinecraftWrapper {
    private final Minecraft client;
    private Vec3 offset = Vec3.f_82478_;

    public MinecraftWrapper(Minecraft instance) {
        this.client = instance;
    }

    public String joinServerSession(String serverId) {
        try {
            this.client.m_91108_().joinServer(this.client.m_91094_().m_92548_(), this.client.m_91094_().m_92547_(), serverId);
        }
        catch (AuthenticationUnavailableException var3) {
            return "Servers-Unavailable!";
        }
        catch (InvalidCredentialsException var4) {
            return "invalidSession";
        }
        catch (AuthenticationException var5) {
            return var5.getMessage();
        }
        return null;
    }

    public GameProfile getGameprofile() {
        return this.client.m_91094_().m_92548_();
    }

    public Object getPlayer() {
        return this.client.f_91074_;
    }

    public boolean applyThirdPerson(boolean thirdPerson) {
        if (this.client.f_91074_.m_21209_()) {
            return false;
        }
        if (this.client.f_91074_.m_21255_()) {
            return false;
        }
        if (this.client.f_91074_.m_20998_(1.0f) != 0.0f && !this.client.f_91074_.m_6067_()) {
            return false;
        }
        return FirstPersonModelCore.enabled && !thirdPerson;
    }

    public void refreshPlayerSettings() {
        this.client.f_91066_.m_92172_();
    }

    public void updatePositionOffset(Entity player, Vec3 defValue) {
        if (player == this.client.m_91288_() && this.client.f_91074_.m_5803_()) {
            this.offset = defValue;
            return;
        }
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        z = 0.0;
        if (player != this.client.f_91074_ || this.client.f_91066_.m_92176_() != CameraType.FIRST_PERSON || !FirstPersonModelCore.isRenderingPlayer) {
            this.offset = defValue;
            return;
        }
        AbstractClientPlayer abstractClientPlayerEntity_1 = (AbstractClientPlayer)player;
        double realYaw = Mth.m_14189_((float)this.client.m_91296_(), (float)abstractClientPlayerEntity_1.f_20884_, (float)abstractClientPlayerEntity_1.f_20883_);
        if (!abstractClientPlayerEntity_1.m_7578_() || this.client.m_91288_() == abstractClientPlayerEntity_1) {
            float bodyOffset;
            if (this.client.f_91074_.m_6067_()) {
                abstractClientPlayerEntity_1.f_20883_ = abstractClientPlayerEntity_1.f_20885_;
                bodyOffset = abstractClientPlayerEntity_1.f_19860_ > 0.0f ? 0.6f : 0.5f;
            } else if (abstractClientPlayerEntity_1.m_6144_()) {
                bodyOffset = 0.27f + (float)FirstPersonModelCore.config.sneakXOffset / 100.0f;
            } else if (abstractClientPlayerEntity_1.m_20159_()) {
                realYaw = abstractClientPlayerEntity_1.m_20202_() instanceof Boat || abstractClientPlayerEntity_1.m_20202_() instanceof Minecart ? (double)Mth.m_14189_((float)this.client.m_91296_(), (float)abstractClientPlayerEntity_1.f_20884_, (float)abstractClientPlayerEntity_1.f_20883_) : (abstractClientPlayerEntity_1.m_20202_() instanceof LivingEntity ? (double)Mth.m_14189_((float)this.client.m_91296_(), (float)((LivingEntity)abstractClientPlayerEntity_1.m_20202_()).f_20884_, (float)((LivingEntity)abstractClientPlayerEntity_1.m_20202_()).f_20883_) : (double)Mth.m_14189_((float)this.client.m_91296_(), (float)abstractClientPlayerEntity_1.m_20202_().f_19859_, (float)abstractClientPlayerEntity_1.m_20202_().m_146908_()));
                bodyOffset = 0.2f + (float)FirstPersonModelCore.config.sitXOffset / 100.0f;
            } else {
                bodyOffset = 0.25f + (float)FirstPersonModelCore.config.xOffset / 100.0f;
            }
            x += (double)bodyOffset * Math.sin(Math.toRadians(realYaw));
            z -= (double)bodyOffset * Math.cos(Math.toRadians(realYaw));
            if (this.client.f_91074_.m_6067_()) {
                y = abstractClientPlayerEntity_1.f_19860_ > 0.0f && abstractClientPlayerEntity_1.m_5842_() ? (y += (double)0.6f * Math.sin(Math.toRadians(abstractClientPlayerEntity_1.f_19860_))) : (y += (double)0.01f * -Math.sin(Math.toRadians(abstractClientPlayerEntity_1.f_19860_)));
            }
        }
        Vec3 vec = new Vec3(x, y, z);
        abstractClientPlayerEntity_1 = null;
        this.offset = vec;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public boolean hasCustomSkin(Object player) {
        return !DefaultPlayerSkin.m_118627_((UUID)((AbstractClientPlayer)player).m_20148_()).equals((Object)((AbstractClientPlayer)player).m_108560_());
    }

    public Object getSkinTexture(Object player) {
        NativeImage skin = new NativeImage(NativeImage.Format.RGBA, 64, 64, true);
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        AbstractTexture abstractTexture = textureManager.m_118506_(((AbstractClientPlayer)player).m_108560_());
        GlStateManager.m_84544_((int)abstractTexture.m_117963_());
        skin.m_85045_(0, false);
        return skin;
    }

    public Object changeHue(Object ido, int hue) {
        ResourceLocation newId;
        ResourceLocation id = (ResourceLocation)ido;
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        if (textureManager.m_118506_(newId = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + hue)) != null) {
            return newId;
        }
        AbstractTexture abstractTexture = textureManager.m_118506_(id);
        if (abstractTexture == null) {
            return id;
        }
        GlStateManager.m_84544_((int)abstractTexture.m_117963_());
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        NativeImage skin = new NativeImage(NativeImage.Format.RGBA, width, height, true);
        skin.m_85045_(0, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (skin.m_85087_(x, y) == 0) continue;
                int RGBA = skin.m_84985_(x, y);
                int alpha = NativeImage.m_84983_((int)RGBA);
                int R = RGBA >> 16 & 0xFF;
                int G = RGBA >> 8 & 0xFF;
                int B = RGBA & 0xFF;
                float[] HSV = new float[3];
                Color.RGBtoHSB(R, G, B, HSV);
                Color fColor = Color.getHSBColor(HSV[0] + (float)hue / 360.0f, HSV[1], HSV[2]);
                skin.m_84988_(x, y, NativeImage.m_84992_((int)alpha, (int)fColor.getRed(), (int)fColor.getGreen(), (int)fColor.getBlue()));
            }
        }
        textureManager.m_118495_(newId, (AbstractTexture)new DynamicTexture(skin));
        return newId;
    }

    public Object getIdentifier(String namespace, String id) {
        return new ResourceLocation(namespace, id);
    }
}

