/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessRecipeBuilder
extends AbstractItemStackRecipeBuilder<ShapelessRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    protected ShapelessRecipeBuilder(RecipeSerializer<?> serializer, ResourceLocation id, ItemStack result) {
        super(serializer, id, result);
    }

    public static ShapelessRecipeBuilder builder(ItemLike result) {
        return ShapelessRecipeBuilder.builder(result, 1);
    }

    public static ShapelessRecipeBuilder builder(ItemLike result, int count) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static ShapelessRecipeBuilder builder(ItemLike result, int count, ResourceLocation id) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static ShapelessRecipeBuilder builder(ItemStack result) {
        return ShapelessRecipeBuilder.builder(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static ShapelessRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new ShapelessRecipeBuilder(RecipeSerializer.f_44077_, id, result);
    }

    public ShapelessRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public ShapelessRecipeBuilder addIngredient(TagKey<Item> tag, int quantity) {
        this.addAutoCriteria(tag);
        Ingredient ingredient = Ingredient.m_204132_(tag);
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public ShapelessRecipeBuilder addIngredient(ItemLike item, int quantity) {
        this.addAutoCriteria(item);
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ShapelessRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    @Override
    public AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe _build() {
        return new FinishedShapelessRecipe();
    }

    public class FinishedShapelessRecipe
    extends AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe {
        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : ShapelessRecipeBuilder.this.ingredients) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
        }
    }
}

