/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.handler.advancement.mod.TwoByTwoModifier;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.ShibaRenderer;
import vazkii.quark.content.mobs.entity.Shiba;

@LoadModule(category=ModuleCategory.MOBS)
public class ShibaModule
extends QuarkModule {
    public static EntityType<Shiba> shibaType;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config
    public static boolean ignoreAreasWithSkylight;
    public static QuarkGenericTrigger shibaHelpTrigger;

    @Override
    public void register() {
        shibaType = EntityType.Builder.m_20704_(Shiba::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.8f).m_20702_(8).setCustomClientFactory((spawnEntity, world) -> new Shiba((EntityType<? extends Shiba>)shibaType, (Level)world)).m_20712_("shiba");
        RegistryHelper.register(shibaType, (String)"shiba", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(this, shibaType, MobCategory.CREATURE, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, spawnConfig);
        EntitySpawnHandler.addEgg(shibaType, 11036481, 15259062, spawnConfig);
        EntityAttributeHandler.put(shibaType, Wolf::m_30425_);
        QuarkAdvancementHandler.addModifier(new TwoByTwoModifier(this, (Set<EntityType<?>>)ImmutableSet.of(shibaType)));
        shibaHelpTrigger = QuarkAdvancementHandler.registerGenericTrigger("shiba_help");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(shibaType, ShibaRenderer::new);
    }

    static {
        spawnConfig = new EntitySpawnConfig(40, 1, 3, CompoundBiomeConfig.fromBiomeTags(false, BiomeTags.f_207606_));
        ignoreAreasWithSkylight = false;
    }
}

