/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.client.hax.PseudoAccessorItemStack;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.client.resources.AttributeDisplayType;
import vazkii.quark.content.client.resources.AttributeIconEntry;
import vazkii.quark.content.client.resources.AttributeSlot;

public class AttributeTooltips {
    private static final Map<ResourceLocation, AttributeIconEntry> attributes = new HashMap<ResourceLocation, AttributeIconEntry>();

    public static void receiveAttributes(Map<String, AttributeIconEntry> map) {
        attributes.clear();
        for (Map.Entry<String, AttributeIconEntry> entry : map.entrySet()) {
            attributes.put(new ResourceLocation(entry.getKey()), entry.getValue());
        }
    }

    @Nullable
    private static AttributeIconEntry getIconForAttribute(Attribute attribute) {
        ResourceLocation loc = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute);
        if (loc != null) {
            return attributes.get(loc);
        }
        return null;
    }

    private static Component format(Attribute attribute, double value, AttributeDisplayType displayType) {
        switch (displayType) {
            case DIFFERENCE: {
                return Component.m_237113_((String)((value > 0.0 ? "+" : "") + ItemStack.f_41584_.format(value))).m_130940_(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
            case PERCENTAGE: {
                return Component.m_237113_((String)((value > 0.0 ? "+" : "") + ItemStack.f_41584_.format(value * 100.0) + "%")).m_130940_(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
            case MULTIPLIER: {
                AttributeSupplier supplier = DefaultAttributes.m_22297_((EntityType)EntityType.f_20532_);
                double scaledValue = value / supplier.m_22253_(attribute);
                return Component.m_237113_((String)(ItemStack.f_41584_.format(scaledValue) + "x")).m_130940_(scaledValue < 1.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
            }
        }
        return Component.m_237113_((String)ItemStack.f_41584_.format(value)).m_130940_(value < 0.0 ? ChatFormatting.RED : ChatFormatting.WHITE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = event.getItemStack();
        if (!Screen.m_96638_()) {
            List tooltipRaw = event.getTooltipElements();
            HashMap attributeTooltips = Maps.newHashMap();
            boolean onlyInvalid = true;
            Multimap<Attribute, AttributeModifier> baseCheck = null;
            boolean allAreSame = true;
            for (AttributeSlot slot : AttributeSlot.values()) {
                if (!AttributeTooltips.canShowAttributes(stack, slot)) continue;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                if (baseCheck == null) {
                    baseCheck = slotAttributes;
                } else if (slot.hasCanonicalSlot() && allAreSame && !slotAttributes.equals(baseCheck)) {
                    allAreSame = false;
                }
                if (!slotAttributes.isEmpty() && !slot.hasCanonicalSlot()) {
                    allAreSame = false;
                }
                onlyInvalid = AttributeTooltips.extractAttributeValues(stack, attributeTooltips, onlyInvalid, slot, slotAttributes);
            }
            AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(stack);
            boolean showSlots = !allAreSame && (onlyInvalid || attributeTooltips.size() == 1 && attributeTooltips.containsKey((Object)primarySlot));
            for (AttributeSlot slot : AttributeSlot.values()) {
                if (!attributeTooltips.containsKey((Object)slot)) continue;
                String stringForSlot = ((MutableComponent)attributeTooltips.get((Object)slot)).getString();
                int len = 16;
                if (stringForSlot.contains("/")) {
                    String[] toks;
                    stringForSlot = stringForSlot.substring(0, stringForSlot.length() - 1);
                    for (String tok : toks = stringForSlot.split("/")) {
                        len += mc.f_91062_.m_92895_(tok) + 5;
                    }
                }
                if (showSlots) {
                    len += 20;
                }
                tooltipRaw.add(1, Either.right((Object)new AttributeComponent(stack, len, 10)));
                if (allAreSame) break;
            }
        }
    }

    public static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, AttributeSlot slot) {
        Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedModifiers = ((PseudoAccessorItemStack)stack).quark$getCapturedAttributes();
        if (capturedModifiers.containsKey((Object)slot)) {
            return capturedModifiers.get((Object)slot);
        }
        return ImmutableMultimap.of();
    }

    public static boolean extractAttributeValues(ItemStack stack, Map<AttributeSlot, MutableComponent> attributeTooltips, boolean onlyInvalid, AttributeSlot slot, Multimap<Attribute, AttributeModifier> slotAttributes) {
        boolean anyInvalid = false;
        for (Attribute attr : slotAttributes.keySet()) {
            AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(attr);
            if (entry != null) {
                onlyInvalid = false;
                Minecraft mc = Minecraft.m_91087_();
                double attributeValue = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, stack, slotAttributes, attr);
                if (attributeValue == 0.0) continue;
                if (!attributeTooltips.containsKey((Object)slot)) {
                    attributeTooltips.put(slot, Component.m_237113_((String)""));
                }
                attributeTooltips.get((Object)slot).m_130946_(AttributeTooltips.format(attr, attributeValue, entry.displayTypes().get((Object)slot)).getString()).m_130946_("/");
                continue;
            }
            if (anyInvalid) continue;
            anyInvalid = true;
            if (!attributeTooltips.containsKey((Object)slot)) {
                attributeTooltips.put(slot, Component.m_237113_((String)""));
            }
            attributeTooltips.get((Object)slot).m_130946_("[+]");
        }
        return onlyInvalid;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int renderAttribute(PoseStack matrix, Attribute attribute, AttributeSlot slot, int x, int y, ItemStack stack, Multimap<Attribute, AttributeModifier> slotAttributes, Minecraft mc) {
        double value;
        AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(attribute);
        if (entry != null && (value = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, stack, slotAttributes, attribute)) != 0.0) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)entry.texture());
            GuiComponent.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
            Component valueStr = AttributeTooltips.format(attribute, value, entry.displayTypes().get((Object)slot));
            mc.f_91062_.m_92889_(matrix, valueStr, (float)(x + 12), (float)(y + 1), -1);
            x += mc.f_91062_.m_92852_((FormattedText)valueStr) + 20;
        }
        return x;
    }

    private static AttributeSlot getPrimarySlot(ItemStack stack) {
        if (stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof TippedArrowItem) {
            return AttributeSlot.POTION;
        }
        return AttributeSlot.fromCanonicalSlot(Mob.m_147233_((ItemStack)stack));
    }

    private static boolean canShowAttributes(ItemStack stack, AttributeSlot slot) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot == AttributeSlot.POTION) {
            return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 0x20) == 0;
        }
        return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 2) == 0;
    }

    private static double getAttribute(Player player, AttributeSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, Attribute key) {
        AttributeInstance attribute;
        AttributeInstance attribute2;
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        double value = 0.0;
        AttributeIconEntry entry = AttributeTooltips.getIconForAttribute(key);
        if (entry == null) {
            return 0.0;
        }
        AttributeDisplayType displayType = entry.displayTypes().get((Object)slot);
        if (!(displayType == AttributeDisplayType.PERCENTAGE || slot == null && key.equals(Attributes.f_22281_) || (attribute2 = player.m_21051_(key)) == null)) {
            value = attribute2.m_22115_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            value += modifier.m_22218_();
        }
        double rawValue = value;
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            value += rawValue * modifier.m_22218_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            value += value * modifier.m_22218_();
        }
        if (key.equals(Attributes.f_22281_) && slot == AttributeSlot.MAINHAND) {
            value += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        if (key.equals(Attributes.f_22282_) && slot == AttributeSlot.MAINHAND) {
            value += (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack);
        }
        if (!(displayType != AttributeDisplayType.DIFFERENCE || slot == null && key.equals(Attributes.f_22281_) || (attribute = player.m_21051_(key)) == null)) {
            value -= attribute.m_22115_();
        }
        return value;
    }

    public static boolean shouldHideAttributes() {
        return ImprovedTooltipsModule.staticEnabled && ImprovedTooltipsModule.attributeTooltips && !Quark.proxy.isClientPlayerHoldingShift();
    }

    @OnlyIn(value=Dist.CLIENT)
    public record AttributeComponent(ItemStack stack, int width, int height) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack pose, @Nonnull ItemRenderer itemRenderer, int something) {
            if (!Screen.m_96638_()) {
                pose.m_85836_();
                pose.m_85837_(0.0, 0.0, 500.0);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.m_91087_();
                pose.m_85837_(0.0, 0.0, (double)mc.m_91291_().f_115093_);
                int y = tooltipY - 1;
                AttributeSlot primarySlot = AttributeTooltips.getPrimarySlot(this.stack);
                boolean onlyInvalid = true;
                boolean showSlots = false;
                int attributeHash = 0;
                boolean allAreSame = true;
                block0: for (AttributeSlot slot : AttributeSlot.values()) {
                    if (!AttributeTooltips.canShowAttributes(this.stack, slot)) continue;
                    Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, slot);
                    if (slot == AttributeSlot.MAINHAND) {
                        attributeHash = slotAttributes.hashCode();
                    } else if (allAreSame && attributeHash != slotAttributes.hashCode()) {
                        allAreSame = false;
                    }
                    for (Attribute attr : slotAttributes.keys()) {
                        if (AttributeTooltips.getIconForAttribute(attr) == null) continue;
                        onlyInvalid = false;
                        if (slot == primarySlot) continue;
                        showSlots = true;
                        break block0;
                    }
                }
                if (allAreSame) {
                    showSlots = false;
                } else if (onlyInvalid) {
                    showSlots = true;
                }
                for (AttributeSlot slot : AttributeSlot.values()) {
                    if (!AttributeTooltips.canShowAttributes(this.stack, slot)) continue;
                    int x = tooltipX;
                    Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, slot);
                    boolean anyToRender = false;
                    for (Attribute attr : slotAttributes.keys()) {
                        double value = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, this.stack, slotAttributes, attr);
                        if (value == 0.0) continue;
                        anyToRender = true;
                        break;
                    }
                    if (!anyToRender) continue;
                    if (showSlots) {
                        RenderSystem.m_157427_(GameRenderer::m_172817_);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
                        GuiComponent.m_93133_((PoseStack)pose, (int)x, (int)y, (float)(202 + (slot == null ? -1 : slot.ordinal()) * 9), (float)35.0f, (int)9, (int)9, (int)256, (int)256);
                        x += 20;
                    }
                    for (Attribute key : slotAttributes.keySet()) {
                        x = AttributeTooltips.renderAttribute(pose, key, slot, x, y, this.stack, slotAttributes, mc);
                    }
                    for (Attribute key : slotAttributes.keys()) {
                        if (AttributeTooltips.getIconForAttribute(key) != null) continue;
                        mc.f_91062_.m_92750_(pose, "[+]", (float)(x + 1), (float)(y + 1), 0xFFFF55);
                        break;
                    }
                    y += 10;
                    if (allAreSame) break;
                }
                pose.m_85849_();
            }
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(@Nonnull Font font) {
            return this.width;
        }
    }
}

