/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.VariantChestBlock;
import vazkii.quark.content.building.block.be.VariantTrappedChestBlockEntity;
import vazkii.quark.content.building.module.VariantChestsModule;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantTrappedChestBlock
extends ChestBlock
implements IBlockItemProvider,
IQuarkBlock,
VariantChestsModule.IChestTextureProvider {
    public final String type;
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;
    private final String path;

    public VariantTrappedChestBlock(String type, QuarkModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties props) {
        super(props, supplier);
        RegistryHelper.registerBlock((Block)this, (String)(type + "_trapped_chest"));
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40751_);
        this.type = type;
        this.module = module;
        this.path = (this instanceof Compat ? "compat/" : "") + type + "/";
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public VariantTrappedChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState p_153065_) {
        return new VariantTrappedChestBlockEntity(pos, p_153065_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        return new VariantChestBlock.Item(block, props);
    }

    @Override
    public String getChestTexturePath() {
        return "model/chest/" + this.path;
    }

    @Override
    public boolean isTrap() {
        return true;
    }

    @Nonnull
    protected Stat<ResourceLocation> m_7699_() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12962_);
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6378_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return Mth.m_14045_((int)ChestBlockEntity.m_59086_((BlockGetter)world, (BlockPos)pos), (int)0, (int)15);
    }

    public int m_6376_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return side == Direction.UP ? state.m_60746_(world, pos, side) : 0;
    }

    public static class Compat
    extends VariantTrappedChestBlock {
        public Compat(String type, String mod, QuarkModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties props) {
            super(type, module, supplier, props);
            this.setCondition(() -> ModList.get().isLoaded(mod));
        }
    }
}

