/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type.inputtable;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.base.client.config.screen.CategoryScreen;
import vazkii.quark.base.client.config.screen.WidgetWrapper;
import vazkii.quark.base.client.config.screen.inputtable.ConvulsionMatrixInputScreen;
import vazkii.quark.base.client.config.screen.inputtable.IInputtableConfigType;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.inputtable.AbstractInputtableType;
import vazkii.quark.content.client.module.GreenerGrassModule;

public class ConvulsionMatrixConfig
extends AbstractInputtableType<ConvulsionMatrixConfig> {
    @Config
    public List<Double> r;
    @Config
    public List<Double> g;
    @Config
    public List<Double> b;
    public final Params params;
    public double[] colorMatrix;

    public ConvulsionMatrixConfig(Params params) {
        this.params = params;
        double[] defaultMatrix = params.defaultMatrix;
        this.colorMatrix = Arrays.copyOf(defaultMatrix, defaultMatrix.length);
        this.updateRGB();
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
        super.onReload(flagManager);
        try {
            this.colorMatrix = new double[]{this.r.get(0), this.r.get(1), this.r.get(2), this.g.get(0), this.g.get(1), this.g.get(2), this.b.get(0), this.b.get(1), this.b.get(2)};
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            e.printStackTrace();
            this.colorMatrix = Arrays.copyOf(this.params.defaultMatrix, this.params.defaultMatrix.length);
        }
    }

    @Override
    public void inherit(ConvulsionMatrixConfig other, boolean committing) {
        this.colorMatrix = Arrays.copyOf(other.colorMatrix, other.colorMatrix.length);
        this.updateRGB();
    }

    private void updateRGB() {
        this.r = Arrays.asList(this.colorMatrix[0], this.colorMatrix[1], this.colorMatrix[2]);
        this.g = Arrays.asList(this.colorMatrix[3], this.colorMatrix[4], this.colorMatrix[5]);
        this.b = Arrays.asList(this.colorMatrix[6], this.colorMatrix[7], this.colorMatrix[8]);
    }

    @Override
    public void inheritDefaults(ConvulsionMatrixConfig other) {
        this.colorMatrix = Arrays.copyOf(other.params.defaultMatrix, other.params.defaultMatrix.length);
    }

    @Override
    public ConvulsionMatrixConfig copy() {
        ConvulsionMatrixConfig newMatrix = new ConvulsionMatrixConfig(this.params.cloneWithNewDefault(this.colorMatrix));
        newMatrix.inherit(this, false);
        return newMatrix;
    }

    public int convolve(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int outR = this.clamp((int)((double)r * this.colorMatrix[0] + (double)g * this.colorMatrix[1] + (double)b * this.colorMatrix[2]));
        int outG = this.clamp((int)((double)r * this.colorMatrix[3] + (double)g * this.colorMatrix[4] + (double)b * this.colorMatrix[5]));
        int outB = this.clamp((int)((double)r * this.colorMatrix[6] + (double)g * this.colorMatrix[7] + (double)b * this.colorMatrix[8]));
        return 0xFF000000 | ((outR & 0xFF) << 16) + ((outG & 0xFF) << 8) + (outB & 0xFF);
    }

    private int clamp(int val) {
        return Math.min(255, Math.max(0, val));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ConvulsionMatrixConfig)) return false;
        ConvulsionMatrixConfig other = (ConvulsionMatrixConfig)obj;
        if (!Arrays.equals(other.colorMatrix, this.colorMatrix)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.colorMatrix);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addWidgets(CategoryScreen parent, IConfigElement element, List<WidgetWrapper> widgets) {
        IInputtableConfigType.addPencil(parent, element, widgets, () -> new ConvulsionMatrixInputScreen((Screen)parent, this, element, parent.category));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getSubtitle() {
        return "[" + Arrays.stream(this.colorMatrix).boxed().map(d -> String.format("%.1f", d)).collect(Collectors.joining(", ")) + "]";
    }

    public static class Params {
        private static final String IDENTITY_NAME = "Vanilla";
        public static final double[] IDENTITY = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        public final String name;
        public final String[] biomeNames;
        public final double[] defaultMatrix;
        public final int[] testColors;
        @Nullable
        public final int[] folliageTestColors;
        private final String[] presetNames;
        private final double[][] presets;
        public final Map<String, double[]> presetMap;

        public Params(String name, double[] defaultMatrix, String[] biomeNames, int[] testColors, @Nullable int[] folliageTestColors, String[] presetNames, double[][] presets) {
            Preconditions.checkArgument((defaultMatrix.length == 9 ? 1 : 0) != 0);
            Preconditions.checkArgument((biomeNames.length == 6 ? 1 : 0) != 0);
            Preconditions.checkArgument((testColors.length == 6 ? 1 : 0) != 0);
            Preconditions.checkArgument((folliageTestColors == null || folliageTestColors.length == 6 ? 1 : 0) != 0);
            Preconditions.checkArgument((presetNames.length == presets.length ? 1 : 0) != 0);
            this.name = name;
            this.defaultMatrix = defaultMatrix;
            this.biomeNames = biomeNames;
            this.testColors = testColors;
            this.folliageTestColors = folliageTestColors;
            this.presetNames = presetNames;
            this.presets = presets;
            this.presetMap = new LinkedHashMap<String, double[]>();
            this.presetMap.put(IDENTITY_NAME, IDENTITY);
            for (int i = 0; i < presetNames.length; ++i) {
                this.presetMap.put(presetNames[i], presets[i]);
            }
        }

        public Params cloneWithNewDefault(double[] newDefault) {
            return new Params(this.name, newDefault, this.biomeNames, this.testColors, this.folliageTestColors, this.presetNames, this.presets);
        }

        public boolean shouldDisplayFolliage() {
            return this.folliageTestColors != null && GreenerGrassModule.affectLeaves;
        }
    }
}

