/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import java.util.ArrayList;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FillWaxingKitRecipe
extends CustomRecipe {
    int waxUsed = 0;

    public FillWaxingKitRecipe(ResourceLocation pId) {
        super(pId);
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        int kit = 0;
        int wax = 0;
        ItemStack kit_item = ItemStack.f_41583_;
        for (int j = 0; j < pInv.m_6643_(); ++j) {
            ItemStack container_item = pInv.m_8020_(j);
            if (container_item.m_41619_()) continue;
            if (container_item.m_150930_((Item)ModItems.WAX_BLEND.get())) {
                ++wax;
                continue;
            }
            if (!container_item.m_150930_((Item)ModItems.WAXING_KIT.get())) {
                return false;
            }
            kit_item = container_item;
            ++kit;
        }
        return wax >= 1 && kit == 1 && (!kit_item.m_41782_() || !kit_item.m_41784_().m_128441_("waxCount") || kit_item.m_41784_().m_128451_("waxCount") < 256);
    }

    public ItemStack assemble(CraftingContainer pInv) {
        int kit_i = 0;
        int wax_i = 0;
        ItemStack kit = ItemStack.f_41583_;
        ArrayList<ItemStack> wax = new ArrayList<ItemStack>();
        for (int j = 0; j < pInv.m_6643_(); ++j) {
            ItemStack itemstack1 = pInv.m_8020_(j);
            if (itemstack1.m_41619_()) continue;
            if (itemstack1.m_150930_((Item)ModItems.WAX_BLEND.get())) {
                wax.add(itemstack1);
                wax_i += itemstack1.m_41613_();
                continue;
            }
            kit = itemstack1;
            ++kit_i;
        }
        if (wax_i >= 1 && kit_i == 1) {
            int count;
            ItemStack itemstack2 = kit.m_41777_();
            int baseCount = 0;
            CompoundTag tag = itemstack2.m_41784_();
            if (tag.m_128441_("waxCount")) {
                baseCount = tag.m_128451_("waxCount");
            }
            if ((count = baseCount + wax_i) <= 256) {
                this.waxUsed = wax_i;
                tag.m_128405_("waxCount", count);
            } else {
                this.waxUsed = 256 - baseCount;
                tag.m_128405_("waxCount", 256);
            }
            return itemstack2;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pInv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pInv.m_6643_(), (Object)ItemStack.f_41583_);
        int waxUsedTemp = this.waxUsed;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = pInv.m_8020_(i);
            if (itemstack.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (itemstack.m_41720_() != ModItems.WAX_BLEND.get()) continue;
            int toSubtract = 0;
            for (int j = 0; j < itemstack.m_41613_(); ++j) {
                if (waxUsedTemp <= 0) continue;
                ++toSubtract;
                --waxUsedTemp;
            }
            int count = itemstack.m_41613_() - toSubtract;
            if (count != 0) {
                itemstack.m_41764_(count);
                pInv.m_6836_(i, itemstack.m_41777_());
                itemstack.m_41764_(1);
                nonnulllist.set(i, (Object)itemstack);
                continue;
            }
            pInv.m_6836_(i, ItemStack.f_41583_);
            nonnulllist.set(i, (Object)ItemStack.f_41583_);
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.FILL_WAXING_KIT_SERIALIZER.get();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }
}

