/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.compat;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.loot.AffixLootEntry;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.placebo.json.PSerializer;

public class GatewaysCompat {
    public static void register() {
        WaveEntity.SERIALIZERS.put((Object)new ResourceLocation("apotheosis:boss"), BossWaveEntity.SERIALIZER);
        Reward.SERIALIZERS.put("apotheosis:affix", PSerializer.autoRegister((String)"Rarity Affix Reward", RarityAffixItemReward.class).build(true));
    }

    public static class BossWaveEntity
    implements WaveEntity {
        static final PSerializer<WaveEntity> SERIALIZER = PSerializer.autoRegister((String)"Boss Wave Entity", BossWaveEntity.class).build(true);
        @Nullable
        private final BossItem boss;

        public BossWaveEntity(@Nullable BossItem boss) {
            this.boss = boss;
        }

        public LivingEntity createEntity(Level level) {
            BossItem realBoss;
            BossItem bossItem = realBoss = this.boss == null ? (BossItem)BossItemManager.INSTANCE.getRandomItem(level.f_46441_) : this.boss;
            if (realBoss == null) {
                return null;
            }
            return realBoss.createBoss((ServerLevelAccessor)level, BlockPos.f_121853_, level.f_46441_, 0.0f);
        }

        public Component getDescription() {
            return Component.m_237110_((String)"misc.apotheosis.boss", (Object[])new Object[]{Component.m_237115_((String)(this.boss == null ? "misc.apotheosis.random" : this.boss.getEntity().m_20675_()))});
        }

        public AABB getAABB(double x, double y, double z) {
            return this.boss == null ? new AABB(0.0, 0.0, 0.0, 2.0, 2.0, 2.0).m_82386_(x, y, z) : this.boss.getSize();
        }

        public boolean shouldFinalizeSpawn() {
            return false;
        }

        public PSerializer<WaveEntity> getSerializer() {
            return SERIALIZER;
        }

        public JsonObject write() {
            JsonObject entityData = new JsonObject();
            if (this.boss != null) {
                entityData.addProperty("boss", this.boss.getId().toString());
            }
            return entityData;
        }

        public static WaveEntity read(JsonObject obj) {
            BossItem boss = obj.has("boss") ? (BossItem)BossItemManager.INSTANCE.getValue(new ResourceLocation(obj.get("boss").getAsString())) : null;
            return new BossWaveEntity(boss);
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130085_(this.boss == null ? new ResourceLocation("null", "null") : this.boss.getId());
        }

        public static WaveEntity read(FriendlyByteBuf buf) {
            BossItem boss = (BossItem)BossItemManager.INSTANCE.getValue(buf.m_130281_());
            return new BossWaveEntity(boss);
        }
    }

    public record RarityAffixItemReward(LootRarity rarity) implements Reward
    {
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(LootController.createLootItem(((AffixLootEntry)AffixLootManager.INSTANCE.getRandomItem(level.f_46441_, summoner.m_36336_())).getStack(), this.rarity, level.f_46441_));
        }

        public JsonObject write() {
            JsonObject obj = super.write();
            obj.addProperty("rarity", this.rarity.id());
            return obj;
        }

        public static RarityAffixItemReward read(JsonObject obj) {
            return new RarityAffixItemReward(LootRarity.byId(obj.get("rarity").getAsString()));
        }

        public void write(FriendlyByteBuf buf) {
            super.write(buf);
            buf.m_130070_(this.rarity.id());
        }

        public static RarityAffixItemReward read(FriendlyByteBuf buf) {
            return new RarityAffixItemReward(LootRarity.byId(buf.m_130277_()));
        }

        public String getName() {
            return "apotheosis:affix";
        }

        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.apotheosis.affix", (Object[])new Object[]{this.rarity.toComponent()}));
        }
    }
}

