/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GemManager
extends WeightedJsonReloadListener<Gem> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(Attribute.class, JsonUtil.makeSerializer((IForgeRegistry)ForgeRegistries.ATTRIBUTES)).create();
    public static final GemManager INSTANCE = new GemManager();

    public GemManager() {
        super(AdventureModule.LOGGER, "gems", false, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new PSerializer.Builder("Gem").withJsonDeserializer(obj -> (Gem)((Object)((Object)GSON.fromJson(obj, Gem.class)))));
    }

    public static ItemStack getRandomGemStack(RandomSource rand, float luck, Predicate<Gem> filter) {
        Gem gem = (Gem)INSTANCE.getRandomItem(rand, luck, filter);
        if (gem == null) {
            return ItemStack.f_41583_;
        }
        return GemItem.fromGem(gem, rand);
    }
}

