/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.AbandonedTrackManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.RemoteAudioTrackExecutor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.RemoteNode;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.NodeStatisticsMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessageMapper;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.TrackExceptionMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.TrackFrameDataMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.TrackFrameRequestMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.TrackStartRequestMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.TrackStartResponseMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.message.TrackStoppedMessage;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.RingBufferMath;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SimpleHttpInterfaceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.ImmutableAudioFrame;
import dev.felnull.imp.include.org.apache.commons.io.input.CountingInputStream;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.entity.ByteArrayEntity;
import dev.felnull.imp.include.org.apache.http.impl.client.HttpClientBuilder;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RemoteNodeProcessor
implements RemoteNode,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(RemoteNodeProcessor.class);
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int SOCKET_TIMEOUT = 2000;
    private static final int TRACK_KILL_THRESHOLD = 10000;
    private static final int TICK_MINIMUM_INTERVAL = 500;
    private static final int NODE_REQUEST_HISTORY = 200;
    private final DefaultAudioPlayerManager playerManager;
    private final String nodeAddress;
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private final HttpInterfaceManager httpInterfaceManager;
    private final AbandonedTrackManager abandonedTrackManager;
    private final BlockingQueue<RemoteMessage> queuedMessages;
    private final ConcurrentMap<Long, RemoteAudioTrackExecutor> playingTracks;
    private final RemoteMessageMapper mapper;
    private final AtomicBoolean threadRunning;
    private final AtomicInteger connectionState;
    private final ArrayDeque<RemoteNode.Tick> tickHistory;
    private volatile int aliveTickCounter;
    private volatile int requestTimingPenalty;
    private volatile long lastAliveTime;
    private volatile NodeStatisticsMessage lastStatistics;
    private volatile boolean closed;

    public RemoteNodeProcessor(DefaultAudioPlayerManager playerManager, String nodeAddress, ScheduledThreadPoolExecutor scheduledExecutor, HttpInterfaceManager httpInterfaceManager, AbandonedTrackManager abandonedTrackManager) {
        this.playerManager = playerManager;
        this.nodeAddress = nodeAddress;
        this.scheduledExecutor = scheduledExecutor;
        this.httpInterfaceManager = httpInterfaceManager;
        this.abandonedTrackManager = abandonedTrackManager;
        this.queuedMessages = new LinkedBlockingQueue<RemoteMessage>();
        this.playingTracks = new ConcurrentHashMap<Long, RemoteAudioTrackExecutor>();
        this.mapper = new RemoteMessageMapper();
        this.threadRunning = new AtomicBoolean();
        this.connectionState = new AtomicInteger(RemoteNode.ConnectionState.OFFLINE.id());
        this.tickHistory = new ArrayDeque(200);
        this.closed = false;
    }

    public void startPlaying(RemoteAudioTrackExecutor executor) {
        AudioTrack track = executor.getTrack();
        if (this.playingTracks.putIfAbsent(executor.getExecutorId(), executor) == null) {
            long position = executor.getNextInputTimecode();
            log.info("Sending request to play {} {} from position {}", track.getIdentifier(), executor.getExecutorId(), position);
            this.queuedMessages.add(new TrackStartRequestMessage(executor.getExecutorId(), track.getInfo(), this.playerManager.encodeTrackDetails(track), executor.getVolume(), executor.getConfiguration(), position));
        }
    }

    public void trackEnded(RemoteAudioTrackExecutor executor, boolean notifyNode) {
        if (this.playingTracks.remove(executor.getExecutorId()) != null) {
            log.info("Track {} removed from node {} (context {})", executor.getTrack().getIdentifier(), this.nodeAddress, executor.getExecutorId());
            if (notifyNode) {
                log.info("Notifying node {} of track stop for {} (context {})", this.nodeAddress, executor.getTrack().getIdentifier(), executor.getExecutorId());
                this.queuedMessages.add(new TrackStoppedMessage(executor.getExecutorId()));
            }
            executor.detach();
        }
    }

    public void shutdown() {
        this.processHealthCheck(true);
        this.closed = true;
        this.scheduledExecutor.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.closed || !this.threadRunning.compareAndSet(false, true)) {
            log.debug("Not running node processor for {}, thread already active.", (Object)this.nodeAddress);
            return;
        }
        log.debug("Trying to connect to node {}.", (Object)this.nodeAddress);
        this.connectionState.set(RemoteNode.ConnectionState.PENDING.id());
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            RingBufferMath timingAverage = new RingBufferMath(10, in -> Math.pow(in, 5.0), out -> Math.pow(out, 0.2));
            while (this.processOneTick(httpInterface, timingAverage)) {
                this.aliveTickCounter = Math.max(1, this.aliveTickCounter + 1);
                this.lastAliveTime = System.currentTimeMillis();
            }
        }
        catch (InterruptedException e) {
            log.info("Node {} processing was stopped.", (Object)this.nodeAddress);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            if (this.aliveTickCounter > 0) {
                log.error("Node {} went offline with exception.", (Object)this.nodeAddress, (Object)e);
            } else {
                log.debug("Retry, node {} is still offline.", (Object)this.nodeAddress);
            }
        }
        catch (Throwable e) {
            log.error("Node {} appears offline due to unexpected exception.", (Object)this.nodeAddress, (Object)e);
            ExceptionTools.rethrowErrors(e);
        }
        finally {
            this.processHealthCheck(true);
            this.connectionState.set(RemoteNode.ConnectionState.OFFLINE.id());
            this.aliveTickCounter = Math.min(-1, this.aliveTickCounter - 1);
            this.threadRunning.set(false);
            if (!this.closed) {
                long delay = this.getScheduleDelay();
                if (this.aliveTickCounter == -1) {
                    log.info("Node {} loop ended, retry scheduled in {}.", (Object)this.nodeAddress, (Object)delay);
                }
                this.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else {
                log.info("Node {} loop ended, node was removed.", (Object)this.nodeAddress);
            }
        }
    }

    private long getScheduleDelay() {
        if (this.aliveTickCounter >= -5) {
            return 1000L;
        }
        if (this.aliveTickCounter >= -20) {
            return 3000L;
        }
        return 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneTick(HttpInterface httpInterface, RingBufferMath timingAverage) throws Exception {
        TickBuilder tickBuilder = new TickBuilder(System.currentTimeMillis());
        try {
            if (!this.dispatchOneTick(httpInterface, tickBuilder)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            tickBuilder.endTime = System.currentTimeMillis();
            this.recordTick(tickBuilder.build(), timingAverage);
        }
        long sleepDuration = Math.max(tickBuilder.startTime + 500L - tickBuilder.endTime, 10L);
        Thread.sleep(sleepDuration);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchOneTick(HttpInterface httpInterface, TickBuilder tickBuilder) throws Exception {
        boolean success = false;
        HttpPost post = new HttpPost("http://" + this.nodeAddress + "/tick");
        this.abandonedTrackManager.distribute(Collections.singletonList(this));
        ByteArrayEntity entity = new ByteArrayEntity(this.buildRequestBody());
        post.setEntity(entity);
        tickBuilder.requestSize = (int)entity.getContentLength();
        CloseableHttpResponse response = httpInterface.execute(post);
        try {
            tickBuilder.responseCode = response.getStatusLine().getStatusCode();
            if (tickBuilder.responseCode != 200) {
                throw new IOException("Returned an unexpected response code " + tickBuilder.responseCode);
            }
            if (this.connectionState.compareAndSet(RemoteNode.ConnectionState.PENDING.id(), RemoteNode.ConnectionState.ONLINE.id())) {
                log.info("Node {} came online.", (Object)this.nodeAddress);
            } else if (this.connectionState.get() != RemoteNode.ConnectionState.ONLINE.id()) {
                log.warn("Node {} received successful response, but had already lost control of its tracks.", (Object)this.nodeAddress);
                boolean bl = false;
                return bl;
            }
            this.lastAliveTime = System.currentTimeMillis();
            if (!this.handleResponseBody(response.getEntity().getContent(), tickBuilder)) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                ExceptionTools.closeWithWarnings(response);
            } else {
                ExceptionTools.closeWithWarnings(response.getEntity().getContent());
            }
        }
        return true;
    }

    private byte[] buildRequestBody() throws IOException {
        ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(outputBytes);
        ArrayList<TrackFrameRequestMessage> messages = new ArrayList<TrackFrameRequestMessage>();
        int queuedCount = this.queuedMessages.drainTo(messages);
        if (queuedCount > 0) {
            log.debug("Including {} queued messages in the request to {}.", (Object)queuedCount, (Object)this.nodeAddress);
        }
        for (RemoteAudioTrackExecutor remoteAudioTrackExecutor : this.playingTracks.values()) {
            long pendingSeek = remoteAudioTrackExecutor.getPendingSeek();
            AudioFrameBuffer buffer = remoteAudioTrackExecutor.getAudioBuffer();
            int neededFrames = pendingSeek == -1L ? buffer.getRemainingCapacity() : buffer.getFullCapacity();
            messages.add(new TrackFrameRequestMessage(remoteAudioTrackExecutor.getExecutorId(), neededFrames, remoteAudioTrackExecutor.getVolume(), pendingSeek));
        }
        for (RemoteMessage remoteMessage : messages) {
            this.mapper.encode(output, remoteMessage);
        }
        this.mapper.endOutput(output);
        return outputBytes.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleResponseBody(InputStream inputStream, TickBuilder tickBuilder) {
        CountingInputStream countingStream = new CountingInputStream(inputStream);
        DataInputStream input = new DataInputStream(countingStream);
        try {
            RemoteMessage message;
            while ((message = this.mapper.decode(input)) != null) {
                if (message instanceof TrackStartResponseMessage) {
                    this.handleTrackStartResponse((TrackStartResponseMessage)message);
                    continue;
                }
                if (message instanceof TrackFrameDataMessage) {
                    this.handleTrackFrameData((TrackFrameDataMessage)message);
                    continue;
                }
                if (message instanceof TrackExceptionMessage) {
                    this.handleTrackException((TrackExceptionMessage)message);
                    continue;
                }
                if (!(message instanceof NodeStatisticsMessage)) continue;
                this.handleNodeStatistics((NodeStatisticsMessage)message);
            }
        }
        catch (InterruptedException interruption) {
            log.error("Node {} processing thread was interrupted.", (Object)this.nodeAddress);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            log.error("Error when processing response from node {}.", (Object)this.nodeAddress, (Object)e);
            ExceptionTools.rethrowErrors(e);
        }
        finally {
            tickBuilder.responseSize = countingStream.getCount();
        }
        return true;
    }

    private void handleTrackStartResponse(TrackStartResponseMessage message) {
        if (message.success) {
            log.debug("Successful start confirmation from node {} for executor {}.", (Object)this.nodeAddress, (Object)message.executorId);
        } else {
            RemoteAudioTrackExecutor executor = (RemoteAudioTrackExecutor)this.playingTracks.get(message.executorId);
            if (executor != null) {
                executor.dispatchException(new FriendlyException("Remote machine failed to start track: " + message.failureReason, FriendlyException.Severity.SUSPICIOUS, null));
                executor.stop();
            } else {
                log.debug("Received failed track start for an already stopped executor {} from node {}.", (Object)message.executorId, (Object)this.nodeAddress);
            }
        }
    }

    private void handleTrackFrameData(TrackFrameDataMessage message) throws Exception {
        RemoteAudioTrackExecutor executor = (RemoteAudioTrackExecutor)this.playingTracks.get(message.executorId);
        if (executor != null) {
            if (message.seekedPosition >= 0L) {
                executor.clearSeek(message.seekedPosition);
            }
            AudioFrameBuffer buffer = executor.getAudioBuffer();
            executor.receivedData();
            AudioDataFormat format = executor.getConfiguration().getOutputFormat();
            for (AudioFrame frame : message.frames) {
                buffer.consume(new ImmutableAudioFrame(frame.getTimecode(), frame.getData(), frame.getVolume(), format));
            }
            if (message.finished) {
                buffer.setTerminateOnEmpty();
                this.trackEnded(executor, false);
            }
        }
    }

    private void handleTrackException(TrackExceptionMessage message) {
        RemoteAudioTrackExecutor executor = (RemoteAudioTrackExecutor)this.playingTracks.get(message.executorId);
        if (executor != null) {
            executor.dispatchException(message.exception);
        }
    }

    private void handleNodeStatistics(NodeStatisticsMessage message) {
        log.trace("Received stats from node: {} {} {} {}", message.playingTrackCount, message.totalTrackCount, Float.valueOf(message.processCpuUsage), Float.valueOf(message.systemCpuUsage));
        this.lastStatistics = message;
    }

    public static HttpInterfaceManager createHttpInterfaceManager() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(2000).build();
        HttpClientBuilder builder = HttpClientTools.createSharedCookiesHttpBuilder();
        builder.setDefaultRequestConfig(requestConfig);
        return new SimpleHttpInterfaceManager(builder, requestConfig);
    }

    public synchronized void processHealthCheck(boolean terminate) {
        if (this.playingTracks.isEmpty() || !terminate && this.lastAliveTime >= System.currentTimeMillis() - 10000L) {
            return;
        }
        this.connectionState.set(RemoteNode.ConnectionState.OFFLINE.id());
        if (!terminate) {
            log.warn("Bringing node {} offline since last response from it was {}ms ago.", (Object)this.nodeAddress, (Object)(System.currentTimeMillis() - this.lastAliveTime));
        }
        for (Long executorId : new ArrayList(this.playingTracks.keySet())) {
            RemoteAudioTrackExecutor executor = (RemoteAudioTrackExecutor)this.playingTracks.remove(executorId);
            if (executor == null) continue;
            this.abandonedTrackManager.add(executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTick(RemoteNode.Tick tick, RingBufferMath timingAverage) {
        timingAverage.add(tick.endTime - tick.startTime);
        this.requestTimingPenalty = (int)(1450.0 / ((1450.0 - Math.min(timingAverage.mean(), 1440.0)) / 30.0) - 30.0);
        ArrayDeque<RemoteNode.Tick> arrayDeque = this.tickHistory;
        synchronized (arrayDeque) {
            if (this.tickHistory.size() == 200) {
                this.tickHistory.removeFirst();
            }
            this.tickHistory.addLast(tick);
        }
    }

    @Override
    public String getAddress() {
        return this.nodeAddress;
    }

    @Override
    public RemoteNode.ConnectionState getConnectionState() {
        if (this.closed) {
            return RemoteNode.ConnectionState.REMOVED;
        }
        return ((RemoteNode.ConnectionState[])RemoteNode.ConnectionState.class.getEnumConstants())[this.connectionState.get()];
    }

    @Override
    public NodeStatisticsMessage getLastStatistics() {
        return this.lastStatistics;
    }

    @Override
    public int getTickMinimumInterval() {
        return 500;
    }

    @Override
    public int getTickHistoryCapacity() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RemoteNode.Tick> getLastTicks(boolean reset) {
        ArrayDeque<RemoteNode.Tick> arrayDeque = this.tickHistory;
        synchronized (arrayDeque) {
            ArrayList<RemoteNode.Tick> result = new ArrayList<RemoteNode.Tick>(this.tickHistory);
            if (reset) {
                this.tickHistory.clear();
            }
            return result;
        }
    }

    @Override
    public int getPlayingTrackCount() {
        return this.playingTracks.size();
    }

    @Override
    public List<AudioTrack> getPlayingTracks() {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (RemoteAudioTrackExecutor executor : this.playingTracks.values()) {
            tracks.add(executor.getTrack());
        }
        return tracks;
    }

    private boolean isUnavailableForTracks(NodeStatisticsMessage statistics) {
        return statistics == null || this.connectionState.get() != RemoteNode.ConnectionState.ONLINE.id();
    }

    private int getPenaltyForPlayingTracks(NodeStatisticsMessage statistics) {
        int count = statistics.playingTrackCount;
        int penalty = Math.min(count, 100);
        if (count > 100) {
            penalty = (int)((double)penalty + Math.pow((double)count - 100.0, 0.7));
        }
        return penalty * 3 / 2;
    }

    private int getPenaltyForPausedTracks(NodeStatisticsMessage statistics) {
        return statistics.totalTrackCount - statistics.playingTrackCount;
    }

    private int getPenaltyForCpuUsage(NodeStatisticsMessage statistics) {
        return (int)(1.0f / ((1.0f - Math.min(statistics.systemCpuUsage, 0.99f)) / 30.0f) - 30.0f);
    }

    @Override
    public Map<String, Integer> getBalancerPenaltyDetails() {
        HashMap<String, Integer> details = new HashMap<String, Integer>();
        NodeStatisticsMessage statistics = this.lastStatistics;
        if (this.isUnavailableForTracks(statistics)) {
            details.put("unavailable", Integer.MAX_VALUE);
        } else {
            details.put("playing", this.getPenaltyForPlayingTracks(statistics));
            details.put("paused", this.getPenaltyForPausedTracks(statistics));
            details.put("cpu", this.getPenaltyForCpuUsage(statistics));
            details.put("timings", this.requestTimingPenalty);
        }
        int total = 0;
        Iterator iterator = details.values().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            total += value;
        }
        details.put("total", total);
        return details;
    }

    public int getBalancerPenalty() {
        NodeStatisticsMessage statistics = this.lastStatistics;
        if (this.isUnavailableForTracks(statistics)) {
            return Integer.MAX_VALUE;
        }
        return this.getPenaltyForPlayingTracks(statistics) + this.getPenaltyForPausedTracks(statistics) + this.getPenaltyForCpuUsage(statistics) + this.requestTimingPenalty;
    }

    @Override
    public boolean isPlayingTrack(AudioTrack track) {
        AudioTrackExecutor executor = ((InternalAudioTrack)track).getActiveExecutor();
        if (executor instanceof RemoteAudioTrackExecutor) {
            return this.playingTracks.containsKey(((RemoteAudioTrackExecutor)executor).getExecutorId());
        }
        return false;
    }

    private static class TickBuilder {
        private final long startTime;
        private long endTime;
        private int responseCode;
        private int requestSize;
        private int responseSize;

        private TickBuilder(long startTime) {
            this.startTime = startTime;
            this.responseCode = -1;
        }

        private RemoteNode.Tick build() {
            return new RemoteNode.Tick(this.startTime, this.endTime, this.responseCode, this.requestSize, this.responseSize);
        }
    }
}

