/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.integration.PatchouliIntegration;
import dev.felnull.imp.item.ManualItem;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ManualItemRenderer
implements BEWLItemRenderer {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Component FELNULL_DEV_TEXT = Component.m_237113_((String)"FelNull DEV");
    private static final Component MANUAL_TEXT = Component.m_237115_((String)"imp.text.manual");
    private static final Component COVER_INFO_TEXT = Component.m_237115_((String)"imp.text.manual.coverInfo");
    private final Component MOD_NAME_TEXT;
    private final Component MOD_VERSION_TEXT;
    private int openProgress;
    private int openProgressO;

    public ManualItemRenderer() {
        Mod mod = Platform.getMod((String)"iammusicplayer");
        this.MOD_NAME_TEXT = Component.m_237113_((String)mod.getName());
        this.MOD_VERSION_TEXT = Component.m_237113_((String)("v" + mod.getVersion()));
    }

    public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource multiBufferSource, float f, int light, int overlay) {
        BakedModel model = IMPModels.MANUAL.get();
        VertexConsumer vc = ItemRenderer.m_115222_((MultiBufferSource)multiBufferSource, (RenderType)Sheets.m_110789_(), (boolean)true, (boolean)stack.m_41790_());
        float par = Mth.m_14179_((float)f, (float)this.openProgressO, (float)this.openProgress) / 10.0f;
        poseStack.m_85836_();
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            OERenderUtils.poseTrans16((PoseStack)poseStack, (double)11.0, (double)0.0, (double)0.0);
            OERenderUtils.poseRotateZ((PoseStack)poseStack, (float)(-25.0f * par));
            OERenderUtils.poseTrans16((PoseStack)poseStack, (double)-11.0, (double)0.0, (double)0.0);
        }
        OERenderUtils.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)model, (int)light, (int)overlay);
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            OERenderUtils.poseTrans16((PoseStack)poseStack, (double)0.0, (double)(0.125 * (double)par), (double)0.0);
            OERenderUtils.poseTrans16((PoseStack)poseStack, (double)10.0, (double)0.125, (double)0.0);
            OERenderUtils.poseRotateZ((PoseStack)poseStack, (float)(-135.0f * par));
            OERenderUtils.poseTrans16((PoseStack)poseStack, (double)-10.0, (double)-0.125, (double)0.0);
        }
        OERenderUtils.poseTrans16((PoseStack)poseStack, (double)0.0, (double)0.125, (double)0.0);
        this.renderTurning(poseStack, multiBufferSource, vc, light, overlay);
        poseStack.m_85849_();
    }

    public void tick() {
        if (ManualItemRenderer.mc.f_91073_ == null || ManualItemRenderer.mc.f_91074_ == null) {
            this.openProgress = 0;
            this.openProgressO = 0;
            return;
        }
        if (mc.m_91104_()) {
            return;
        }
        this.openProgressO = this.openProgress;
        this.openProgress = PatchouliIntegration.INSTANCE.isEnable() && ManualItem.MANUAL_BOOK.equals((Object)PatchouliIntegration.INSTANCE.getOpenBookGui()) ? Math.min(this.openProgress + 1, 10) : Math.max(this.openProgress - 1, 0);
    }

    private void renderTurning(PoseStack poseStack, MultiBufferSource multiBufferSource, VertexConsumer vc, int light, int overlay) {
        BakedModel model = IMPModels.MANUAL_TURNING.get();
        poseStack.m_85836_();
        OERenderUtils.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)model, (int)light, (int)overlay);
        this.renderText(poseStack, multiBufferSource, FELNULL_DEV_TEXT, light, 9.0f, 15.75f, 0.4f, false, 0);
        this.renderText(poseStack, multiBufferSource, MANUAL_TEXT, light, 2.1125f, 15.75f, 0.54f, true, -1);
        this.renderText(poseStack, multiBufferSource, this.MOD_NAME_TEXT, light, 9.85f, 14.5f, 0.7f, false, 0);
        this.renderText(poseStack, multiBufferSource, this.MOD_VERSION_TEXT, light, 9.85f, 13.5f, 0.4f, false, 0);
        this.renderText(poseStack, multiBufferSource, COVER_INFO_TEXT, light, 5.5f, 12.0f, 0.4f, true, 0);
        poseStack.m_85849_();
    }

    private void renderText(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, int light, float x, float y, float scale, boolean center, int color) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)0.001f, 0.0);
        OERenderUtils.poseTrans16((PoseStack)poseStack, (double)x, (double)0.125, (double)y);
        OERenderUtils.poseRotateX((PoseStack)poseStack, (float)-90.0f);
        OERenderUtils.poseRotateZ((PoseStack)poseStack, (float)180.0f);
        if (center) {
            Objects.requireNonNull(ManualItemRenderer.mc.f_91062_);
            OERenderUtils.renderCenterTextSprite((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (Component)text, (float)0.0f, (float)0.0f, (float)0.0f, (float)scale, (float)0.0f, (float)9.0f, (int)color, (int)light);
        } else {
            Objects.requireNonNull(ManualItemRenderer.mc.f_91062_);
            OERenderUtils.renderTextSprite((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (Component)text, (float)0.0f, (float)0.0f, (float)0.0f, (float)scale, (float)0.0f, (float)9.0f, (int)color, (int)light);
        }
        poseStack.m_85849_();
    }
}

