/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.PlaybackProgressBar;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.MusicMedia;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MusicBaseMMMonitor
extends ImageNameBaseMMMonitor {
    private static final ResourceLocation ADD_MUSIC_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/monitor/add_music.png");
    private static final ResourceLocation SHOW_MUSIC_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/monitor/show_music.png");
    private static final Component PLAYBACK_CONTROL_TEXT = Component.m_237115_((String)"imp.button.playbackControl");
    protected static final Component MUSIC_SOURCE_TEXT = Component.m_237115_((String)"imp.text.musicSource");
    private static final Component PLAYBACK_NON_PROGRESS_TEXT = Component.m_237115_((String)"--:--/--:--");
    private static final Component PLAYBACK_LOADING_PROGRESS_TEXT = Component.m_237115_((String)"imp.text.playbackLoading");
    private SmartButton playControlButton;
    protected int playBackX = 189;
    protected int playBackY = 40;
    protected boolean isLoaderSelect;
    private Component AUTHOR_TEXT;

    public MusicBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.playControlButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.playBackX, this.getStartY() + this.playBackY, 20, 20, PLAYBACK_CONTROL_TEXT, n -> {
            if (this.getScreen().isMusicPlaying()) {
                this.getScreen().stopMusic();
            } else if (!this.getMusicSource().isEmpty()) {
                this.getScreen().playMusic(this.getMusicSource(), 0L);
            }
        }));
        this.playControlButton.setHideText(true);
        this.playControlButton.setIcon(WIDGETS_TEXTURE, 0, 123, 11, 11);
        this.playControlButton.f_93623_ = !this.getMusicSource().isEmpty();
        this.addRenderWidget(new PlaybackProgressBar(this.getStartX() + this.playBackX + 22, this.getStartY() + this.playBackY + 14, (Component)Component.m_237115_((String)"imp.progressBar.playbackControl"), () -> {
            if (this.getScreen().isMusicPlaying()) {
                return Float.valueOf(this.getScreen().getMusicPlayer().getCurrentPositionProgress());
            }
            return Float.valueOf(0.0f);
        }, n -> {
            if (this.getScreen().isMusicPlaying()) {
                MusicSource ms = this.getScreen().getMusicPlayer().getSource();
                this.getScreen().playMusic(ms, (long)((float)ms.getDuration() * n.floatValue()));
            }
        }));
        if (!this.getMusicAuthor().isEmpty()) {
            this.setMusicAuthor(this.getMusicAuthor());
        }
    }

    @Override
    public void depose() {
        super.depose();
        this.AUTHOR_TEXT = null;
    }

    @Override
    public void tick() {
        super.tick();
        boolean bl = this.playControlButton.f_93623_ = !this.getMusicSource().isEmpty();
        if (this.getScreen().isMusicPlaying() || this.getScreen().isMusicLoading()) {
            this.playControlButton.setIcon(WIDGETS_TEXTURE, 0, 134, 11, 11);
        } else {
            this.playControlButton.setIcon(WIDGETS_TEXTURE, 0, 123, 11, 11);
        }
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        Object pt;
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)(this.isLoaderSelect ? ADD_MUSIC_TEXTURE : SHOW_MUSIC_TEXTURE), (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        this.drawSmartText(poseStack, MUSIC_SOURCE_TEXT, this.getStartX() + 189, this.getStartY() + 13);
        OERenderUtils.drawTexture((ResourceLocation)MusicManagerMonitor.WIDGETS_TEXTURE, (PoseStack)poseStack, (float)(this.getStartX() + this.playBackX), (float)(this.getStartY() + this.playBackY), (float)68.0f, (float)90.0f, (float)177.0f, (float)20.0f);
        if (this.getScreen().isMusicPlaying()) {
            MusicEntry mp = this.getScreen().getMusicPlayer();
            pt = Component.m_237113_((String)FNStringUtil.getTimeProgress(mp.getCurrentPosition(), mp.getSource().getDuration()));
        } else {
            pt = this.getScreen().isMusicLoading() ? PLAYBACK_LOADING_PROGRESS_TEXT : (!this.getMusicSource().isEmpty() ? Component.m_237113_((String)FNStringUtil.getTimeProgress(0L, this.getMusicSource().getDuration())) : PLAYBACK_NON_PROGRESS_TEXT);
        }
        this.drawSmartText(poseStack, (Component)pt, this.getStartX() + this.playBackX + 22, this.getStartY() + this.playBackY + 4);
        if (this.AUTHOR_TEXT != null) {
            this.drawSmartText(poseStack, this.AUTHOR_TEXT, this.getStartX() + this.playBackX, this.getStartY() + this.playBackY + 25);
        }
        if (!this.isLoaderSelect) {
            this.drawSmartButtonBox(poseStack, this.getStartX() + 189, this.getStartY() + 22, 176, 15, false);
            MusicMedia lt = this.getRawMusicLoaderType();
            if (lt != null) {
                int sx = 0;
                ResourceLocation ic = lt.getIcon();
                if (ic != null) {
                    OERenderUtils.drawTexture((ResourceLocation)ic, (PoseStack)poseStack, (float)(this.getStartX() + 190), (float)(this.getStartY() + 23), (float)0.0f, (float)0.0f, (float)13.0f, (float)13.0f, (float)13.0f, (float)13.0f);
                    sx += 13;
                }
                this.drawSmartText(poseStack, lt.getMediaName(), this.getStartX() + 190 + sx + 2, (float)this.getStartY() + 21.0f + 4.25f);
            }
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((ResourceLocation)(this.isLoaderSelect ? ADD_MUSIC_TEXTURE : SHOW_MUSIC_TEXTURE), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartTextSprite(poseStack, multiBufferSource, MUSIC_SOURCE_TEXT, 189.0f, 13.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderTextureSprite(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, multiBufferSource, this.playBackX, this.playBackY, 0.003f, 177.0f, 20.0f, 68.0f, 90.0f, 177.0f, 20.0f, 256.0f, 256.0f, i, j, onPxW, onPxH, monitorHeight);
        Object pt = !this.getMusicSource(blockEntity).isEmpty() ? Component.m_237113_((String)FNStringUtil.getTimeProgress(0L, this.getMusicSource(blockEntity).getDuration())) : PLAYBACK_NON_PROGRESS_TEXT;
        this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)pt, this.playBackX + 22, this.playBackY + 4, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.playBackX, this.playBackY, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, WIDGETS_TEXTURE, 0, 123, 11, 11, 256, 256, this.getMusicSource(blockEntity).isEmpty());
        OERenderUtils.renderTextureSprite((ResourceLocation)WIDGETS_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)(onPxW * (float)(this.playBackX + 22)), (float)(monitorHeight - onPxH * (float)(this.playBackY + 14 + 3)), (float)0.004f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(onPxW * 153.0f), (float)(onPxH * 3.0f), (float)52.0f, (float)54.0f, (float)153.0f, (float)3.0f, (float)256.0f, (float)256.0f, (int)i, (int)j);
        if (!this.getMusicAuthor(blockEntity).isEmpty()) {
            int le = 176 - MusicBaseMMMonitor.mc.f_91062_.m_92852_((FormattedText)Component.m_237110_((String)"imp.text.musicAuthor", (Object[])new Object[]{""}));
            String aut = OEClientUtils.getWidthOmitText((String)this.getMusicAuthor(blockEntity), (float)le, (String)"...");
            this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)Component.m_237110_((String)"imp.text.musicAuthor", (Object[])new Object[]{aut}), this.playBackX, this.playBackY + 25, 0.004f, onPxW, onPxH, monitorHeight, i);
        }
        if (!this.isLoaderSelect) {
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 189.0f, 22.0f, 0.003f, 176.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight);
            MusicMedia lt = this.getRawMusicLoaderType(blockEntity);
            if (lt != null) {
                int sx = 0;
                ResourceLocation ic = lt.getIcon();
                if (ic != null) {
                    this.renderTextureSprite(ic, poseStack, multiBufferSource, 190.0f, 23.0f, 0.0050000004f, 13.0f, 13.0f, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight);
                    sx += 13;
                }
                this.renderSmartTextSprite(poseStack, multiBufferSource, lt.getMediaName(), 190 + sx + 2, 27.25f, 0.0050000004f, onPxW, onPxH, monitorHeight, i);
            }
        }
    }

    protected void setMusicAuthor(String author) {
        if (author.isEmpty()) {
            this.AUTHOR_TEXT = null;
        } else {
            int le = 176 - MusicBaseMMMonitor.mc.f_91062_.m_92852_((FormattedText)Component.m_237110_((String)"imp.text.musicAuthor", (Object[])new Object[]{""}));
            String aut = OEClientUtils.getWidthOmitText((String)author, (float)le, (String)"...");
            this.AUTHOR_TEXT = Component.m_237110_((String)"imp.text.musicAuthor", (Object[])new Object[]{aut});
        }
    }

    @NotNull
    protected String getMusicAuthor() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            return this.getMusicAuthor(musicManagerBlock);
        }
        return "";
    }

    @NotNull
    protected String getMusicAuthor(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMusicAuthor((Player)MusicBaseMMMonitor.mc.f_91074_);
    }

    @NotNull
    protected String getMusicSourceName() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity2 = (MusicManagerBlockEntity)blockEntity;
            return this.getMusicSourceName(blockEntity2);
        }
        return "";
    }

    @NotNull
    protected String getMusicSourceName(@NotNull MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicSourceName((Player)MusicBaseMMMonitor.mc.f_91074_);
    }

    @NotNull
    protected MusicSource getMusicSource() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity2 = (MusicManagerBlockEntity)blockEntity;
            return this.getMusicSource(blockEntity2);
        }
        return MusicSource.EMPTY;
    }

    @NotNull
    protected MusicSource getMusicSource(@NotNull MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicSource((Player)MusicBaseMMMonitor.mc.f_91074_);
    }

    @Nullable
    protected MusicMedia getRawMusicLoaderType(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        return IMPMusicMedias.getAllMedia().get(this.getMusicLoaderType(musicManagerBlockEntity));
    }

    @Nullable
    protected MusicMedia getRawMusicLoaderType() {
        return IMPMusicMedias.getAllMedia().get(this.getMusicLoaderType());
    }

    @NotNull
    protected String getMusicLoaderType() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity2 = (MusicManagerBlockEntity)blockEntity;
            return this.getMusicLoaderType(blockEntity2);
        }
        return "auto";
    }

    @NotNull
    protected String getMusicLoaderType(@NotNull MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicLoaderType((Player)MusicBaseMMMonitor.mc.f_91074_).isEmpty() ? "auto" : blockEntity.getMusicLoaderType((Player)MusicBaseMMMonitor.mc.f_91074_);
    }
}

