/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.PlayBackBaseBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RadioBMonitor
extends PlayBackBaseBMonitor {
    private static final ResourceLocation BACK_BG_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox/monitor/playback_back.png");
    private static final Component LOADING_STREAM_TEXT = Component.m_237115_((String)"imp.text.streamLoading");
    private static final Component PLAYING_STREAM_TEXT = Component.m_237115_((String)"imp.text.streamPlaying");
    private static final Component NON_PROGRESS_TEXT = Component.m_237113_((String)"--:--/--:--");
    private SmartButton backButton;

    public RadioBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.backButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 15, this.getStartY() + this.height - 12, 14, 11, (Component)Component.m_237115_((String)"gui.back"), n -> this.setMonitor(BoomboxData.MonitorType.RADIO_SELECT)));
        this.backButton.setHideText(true);
        this.backButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8);
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)BACK_BG_TEXTURE, (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        Component ptx = LOADING_STREAM_TEXT;
        if (!this.getScreen().isMusicLoading() && this.getScreen().getBoomBoxData().isPlaying()) {
            ptx = PLAYING_STREAM_TEXT;
        } else if (!this.getScreen().getBoomBoxData().isPlaying()) {
            ptx = NON_PROGRESS_TEXT;
        }
        this.drawSmartText(poseStack, ptx, this.getStartX() + 38 - (this.isShortProgressBar() ? 0 : 36), this.getStartY() + 15, -15639282);
    }

    @Override
    public void renderAppearance(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        OERenderUtils.renderTextureSprite((ResourceLocation)BACK_BG_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        Component ptx = LOADING_STREAM_TEXT;
        if (!data.isLoadingMusic() && data.isPlaying()) {
            ptx = PLAYING_STREAM_TEXT;
        } else if (!data.isPlaying()) {
            ptx = NON_PROGRESS_TEXT;
        }
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartTextSpriteColorSprite(poseStack, multiBufferSource, ptx, 38.0f - (this.isShortProgressBar(data) ? 0.0f : 36.0f), 17.0f, 0.002f, onPxW, onPxH, monitorHeight, -15639282, i);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 15, this.height - 12, 0.002f, 14.0f, 11.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8, 256, 256);
    }

    @Override
    @NotNull
    protected ImageInfo getPlayBackImage(BoomboxData data) {
        return data.getRadioImage();
    }

    @Override
    @NotNull
    protected String getPlayBackName(BoomboxData data) {
        return data.getRadioName();
    }

    @Override
    @NotNull
    protected String getPlayBackAuthor(BoomboxData data) {
        return data.getRadioAuthor();
    }

    @Override
    @NotNull
    protected MusicSource getPlayBackSource(BoomboxData data) {
        return data.getRadioSource();
    }

    @Override
    protected boolean isShortTipProgressBar() {
        return true;
    }
}

