/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class DiskRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<DiskRecipe> SERIALIZER = new SimpleRecipeSerializer(DiskRecipe::new);

    public DiskRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean paperFound = false;
        boolean redstoneFound = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == Items.f_42516_) {
                if (paperFound) {
                    return false;
                }
                paperFound = true;
                continue;
            }
            if (stack.m_204117_(Tags.Items.DUSTS_REDSTONE)) {
                if (redstoneFound) {
                    return false;
                }
                redstoneFound = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) continue;
            return false;
        }
        return redstoneFound && paperFound;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() == Items.f_42516_ || stack.m_204117_(Tags.Items.DUSTS_REDSTONE) || (dye = ColourUtils.getStackColour(stack)) == null) continue;
            tracker.addColour(dye);
        }
        return ItemDisk.createFromIDAndColour(-1, null, tracker.hasColour() ? tracker.getColour() : Colour.BLUE.getHex());
    }

    public boolean m_8004_(int x, int y) {
        return x >= 2 && y >= 2;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemDisk.createFromIDAndColour(-1, null, Colour.BLUE.getHex());
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

