/*
 * Decompiled with CFR 0.152.
 */
package matmos_tct.network;

import java.util.HashMap;
import java.util.function.Supplier;
import matmos_tct.MatmosMod;
import matmos_tct.procedures.CaveloopoffProcedure;
import matmos_tct.procedures.CavelooponProcedure;
import matmos_tct.procedures.CavesoundProcedure;
import matmos_tct.procedures.FindoffProcedure;
import matmos_tct.procedures.VolumeProcedure;
import matmos_tct.procedures.VolumeoffProcedure;
import matmos_tct.procedures.WindProcedure;
import matmos_tct.world.inventory.SetingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SetingsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SetingsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SetingsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SetingsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SetingsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SetingsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = SetingsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            VolumeProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            VolumeoffProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            CavesoundProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            VolumeoffProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            WindProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            FindoffProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            CavelooponProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            CaveloopoffProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MatmosMod.addNetworkMessage(SetingsButtonMessage.class, SetingsButtonMessage::buffer, SetingsButtonMessage::new, SetingsButtonMessage::handler);
    }
}

