/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRayTraceEntityPacket
extends PacketBase
implements IPacketServer {
    protected int targetId;
    protected Vec3 origin;
    protected Vec3 hit;

    public ItemRayTraceEntityPacket() {
        super(67, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        if (!ItemHelper.isPlayerHoldingEntityRayTraceItem((Player)player)) {
            return;
        }
        ItemHelper.onRayTraceEntity((Player)player, this.targetId, this.origin, this.hit);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.targetId);
        buf.writeDouble(this.origin.f_82479_);
        buf.writeFloat((float)this.origin.f_82480_);
        buf.writeDouble(this.origin.f_82481_);
        buf.writeDouble(this.hit.f_82479_);
        buf.writeFloat((float)this.hit.f_82480_);
        buf.writeDouble(this.hit.f_82481_);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.targetId = buf.readInt();
        this.origin = new Vec3(buf.readDouble(), (double)buf.readFloat(), buf.readDouble());
        this.hit = new Vec3(buf.readDouble(), (double)buf.readFloat(), buf.readDouble());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(Player player, Entity target, Vec3 origin, Vec3 hit) {
        LocalPlayer client;
        if (player.f_19853_.f_46443_ && (client = Minecraft.m_91087_().f_91074_) != null && client.equals((Object)player)) {
            ItemRayTraceEntityPacket packet = new ItemRayTraceEntityPacket();
            packet.targetId = target.m_19879_();
            packet.origin = origin;
            packet.hit = hit;
            packet.sendToServer();
        }
    }
}

