/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;

public abstract class ScreenAddonScreen
extends Screen
implements IScreenAddonConsumer {
    public int x;
    public int y;
    private IAssetProvider assetProvider;
    private List<IScreenAddon> addonList;
    private boolean drawBackground;
    private boolean isMouseDragging;
    private int dragX;
    private int dragY;

    public ScreenAddonScreen(IAssetProvider assetProvider, boolean drawBackground) {
        super((Component)Component.m_237113_((String)""));
        this.assetProvider = assetProvider;
        this.drawBackground = drawBackground;
    }

    public void m_7856_() {
        super.m_7856_();
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.x = this.f_96543_ / 2 - background.getArea().width / 2;
        this.y = this.f_96544_ / 2 - background.getArea().height / 2;
        this.addonList = this.guiAddons().stream().map(IFactory::create).collect(Collectors.toList());
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85836_();
        this.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    public void renderBackground(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.checkForMouseDrag(mouseX, mouseY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawBackground) {
            this.m_96558_(stack, 0);
            AssetUtil.drawAsset(stack, this, this.assetProvider.getAsset(AssetTypes.BACKGROUND), this.x, this.y);
        }
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(stack, this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
    }

    public void renderForeground(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawForegroundLayer(stack, this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
        for (IScreenAddon iScreenAddon : this.addonList) {
            if (!iScreenAddon.m_5953_(mouseX - this.x, mouseY - this.y) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            this.m_169388_(stack, iScreenAddon.getTooltipLines(), Optional.empty(), mouseX, mouseY);
        }
    }

    public abstract List<IFactory<IScreenAddon>> guiAddons();

    private void checkForMouseDrag(int mouseX, int mouseY) {
        int pressedButton = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0);
        if (pressedButton == 1) {
            if (!this.m_7282_()) {
                this.m_7897_(true);
            } else {
                for (IScreenAddon iScreenAddon : this.addonList) {
                    if (!iScreenAddon.m_5953_(mouseX - this.x, mouseY - this.y)) continue;
                    iScreenAddon.m_7979_(mouseX - this.x, mouseY - this.y, pressedButton, this.dragX, this.dragY);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.m_7897_(false);
        }
    }

    public List<IScreenAddon> getAddons() {
        return this.addonList;
    }

    public List<? extends GuiEventListener> m_6702_() {
        ArrayList children = new ArrayList(super.m_6702_());
        children.addAll(this.getAddons());
        return children;
    }
}

