/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class EditConfigListScreen<E, CV extends ConfigValue<E>>
extends BaseScreen {
    private final ListConfig<E, CV> list;
    private final ConfigCallback callback;
    private final Component title;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final PanelScrollBar scroll;

    public EditConfigListScreen(ListConfig<E, CV> l, ConfigCallback cb) {
        this.list = l;
        this.callback = cb;
        this.title = Component.m_237113_((String)this.list.getName()).m_130940_(ChatFormatting.BOLD);
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (int i = 0; i < ((List)EditConfigListScreen.this.list.value).size(); ++i) {
                    this.add(new ButtonConfigValue((Panel)this, EditConfigListScreen.this.list, i));
                }
                if (EditConfigListScreen.this.list.getCanEdit()) {
                    this.add(new ButtonAddValue(this));
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                EditConfigListScreen.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.accept"), Icons.ACCEPT, (widget, button) -> this.doAccept());
        this.buttonCancel = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.cancel"), Icons.CANCEL, (widget, button) -> this.doCancel());
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
    }

    private void doAccept() {
        this.callback.save(true);
    }

    private void doCancel() {
        this.callback.save(false);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.buttonCancel.onClicked(MouseButton.LEFT);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        EditConfigScreen.COLOR_BACKGROUND.draw(matrixStack, 0, 0, w, 20);
        theme.drawString(matrixStack, this.getTitle(), 6, 6, 2);
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return EditConfigScreen.THEME;
    }

    public class ButtonAddValue
    extends Button {
        public ButtonAddValue(Panel panel) {
            super(panel);
            this.setHeight(12);
            this.setTitle((Component)Component.m_237113_((String)"+ ").m_7220_((Component)Component.m_237115_((String)"gui.add")));
        }

        @Override
        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            theme.drawString(matrixStack, this.getTitle(), x + 4, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            ((ConfigValue)EditConfigListScreen.this.list.type).value = ((ConfigValue)EditConfigListScreen.this.list.type).defaultValue == null ? null : ((ConfigValue)EditConfigListScreen.this.list.type).copy(((ConfigValue)EditConfigListScreen.this.list.type).defaultValue);
            ((ConfigValue)EditConfigListScreen.this.list.type).onClicked(button, accepted -> {
                if (accepted) {
                    ((List)EditConfigListScreen.this.list.value).add(((ConfigValue)EditConfigListScreen.this.list.type).value);
                }
                this.openGui();
            });
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }
    }

    public static class ButtonConfigValue<E, CV extends ConfigValue<E>>
    extends Button {
        public final ListConfig<E, CV> list;
        public final int index;

        public ButtonConfigValue(Panel panel, ListConfig<E, CV> l, int i) {
            super(panel);
            this.list = l;
            this.index = i;
            this.setHeight(12);
        }

        @Override
        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            MutableColor4I textCol = ((ConfigValue)this.list.type).getColor(((List)this.list.value).get(this.index)).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
                if (this.getMouseX() >= x + w - 19) {
                    Color4I.WHITE.withAlpha(33).draw(matrixStack, x + w - 19, y, 19, h);
                }
            }
            theme.drawString(matrixStack, this.getGui().getTheme().trimStringToWidth((FormattedText)((ConfigValue)this.list.type).getStringForGUI(((List)this.list.value).get(this.index)), this.width), x + 4, y + 2, textCol, 0);
            if (mouseOver) {
                theme.drawString(matrixStack, "[-]", x + w - 16, y + 2, Color4I.WHITE, 0);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                if (this.list.getCanEdit()) {
                    ((List)this.list.value).remove(this.index);
                    this.parent.refreshWidgets();
                }
            } else {
                ((ConfigValue)this.list.type).value = ((List)this.list.value).get(this.index);
                ((ConfigValue)this.list.type).onClicked(button, accepted -> {
                    if (accepted) {
                        ((List)this.list.value).set(this.index, ((ConfigValue)this.list.type).value);
                    }
                    this.openGui();
                });
            }
        }

        @Override
        public void addMouseOverText(TooltipList l) {
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                l.translate("selectServer.delete", new Object[0]);
            } else {
                ((ConfigValue)this.list.type).value = ((List)this.list.value).get(this.index);
                ((ConfigValue)this.list.type).addInfo(l);
            }
        }
    }
}

