/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import dev.ftb.mods.ftbic.block.entity.machine.TeleporterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TeleporterEntry
implements Comparable<TeleporterEntry> {
    public final ResourceKey<Level> dimension;
    public final BlockPos pos;
    public final String name;
    public final String placerName;
    public final double energyUse;

    public TeleporterEntry(TeleporterBlockEntity e, double u) {
        this.dimension = e.m_58904_().m_46472_();
        this.pos = e.m_58899_();
        this.name = e.name;
        this.placerName = e.isPublic ? e.placerName : "";
        this.energyUse = u;
    }

    public TeleporterEntry(FriendlyByteBuf buf) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.pos = buf.m_130135_();
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.placerName = buf.m_130136_(Short.MAX_VALUE);
        this.energyUse = buf.readDouble();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130064_(this.pos);
        buf.m_130072_(this.name, Short.MAX_VALUE);
        buf.m_130072_(this.placerName, Short.MAX_VALUE);
        buf.writeDouble(this.energyUse);
    }

    @Override
    public int compareTo(@NotNull TeleporterEntry o) {
        int i = Boolean.compare(this.placerName.isEmpty(), o.placerName.isEmpty());
        if (i == 0) {
            i = Double.compare(this.energyUse, o.energyUse);
        }
        if (i == 0) {
            i = this.name.compareToIgnoreCase(o.name);
        }
        return i;
    }
}

