/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.screen.ElectricBlockScreen;
import dev.ftb.mods.ftbic.screen.NuclearReactorInfoScreen;
import dev.ftb.mods.ftbic.screen.NuclearReactorMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class NuclearReactorScreen
extends ElectricBlockScreen<NuclearReactorMenu> {
    public static final ResourceLocation NUCLEAR_REACTOR_TEXTURE = new ResourceLocation("ftbic", "textures/gui/nuclear_reactor.png");

    public NuclearReactorScreen(NuclearReactorMenu m, Inventory inv, Component c) {
        super(m, inv, c);
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
    }

    @Override
    public ResourceLocation getScreenTexture() {
        return NUCLEAR_REACTOR_TEXTURE;
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float delta, int mouseX, int mouseY) {
        super.m_7286_(poseStack, delta, mouseX, mouseY);
        this.drawNuclearBar(poseStack, this.f_97735_ + 115, this.f_97736_ + 5, ((NuclearReactorMenu)this.f_97732_).data.get(SyncedData.PAUSED) == false && ((NuclearReactorMenu)this.f_97732_).data.get(NuclearReactorBlockEntity.ENERGY_OUTPUT) > 0.0);
        this.drawHeatBar(poseStack, this.f_97735_ + 115, this.f_97736_ + 127, Mth.m_14036_((float)((float)((NuclearReactorMenu)this.f_97732_).data.get(NuclearReactorBlockEntity.HEAT).intValue() / (float)((NuclearReactorMenu)this.f_97732_).data.get(NuclearReactorBlockEntity.MAX_HEAT).intValue()), (float)0.0f, (float)1.0f));
        this.drawSmallPauseButton(poseStack, this.f_97735_ + 105, this.f_97736_ + 5, mouseX, mouseY, ((NuclearReactorMenu)this.f_97732_).data.get(SyncedData.PAUSED));
        this.drawSmallQuestionButton(poseStack, this.f_97735_ + 94, this.f_97736_ + 5, mouseX, mouseY);
        this.drawSmallRedstoneButton(poseStack, this.f_97735_ + 105, this.f_97736_ + 127, mouseX, mouseY, ((NuclearReactorMenu)this.f_97732_).data.get(SyncedData.ALLOW_REDSTONE_CONTROL));
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        NuclearReactorScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)(((NuclearReactorMenu)this.f_97732_).data.get(SyncedData.PAUSED) != false ? Component.m_237113_((String)"Paused") : FTBICUtils.formatEnergy(((NuclearReactorMenu)this.f_97732_).data.get(NuclearReactorBlockEntity.ENERGY_OUTPUT))), (int)142, (int)6, (int)0xFFFFFF);
        NuclearReactorScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)FTBICUtils.formatHeat(((NuclearReactorMenu)this.f_97732_).data.get(NuclearReactorBlockEntity.HEAT)), (int)142, (int)128, (int)0xFFFFFF);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (NuclearReactorScreen.isIn((int)mouseX, (int)mouseY, this.f_97735_ + 105, this.f_97736_ + 5, 9, 10)) {
            this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerButtonClickPacket(((NuclearReactorMenu)this.f_97732_).f_38840_, 0));
            return true;
        }
        if (NuclearReactorScreen.isIn((int)mouseX, (int)mouseY, this.f_97735_ + 105, this.f_97736_ + 127, 9, 10)) {
            this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerButtonClickPacket(((NuclearReactorMenu)this.f_97732_).f_38840_, 1));
            return true;
        }
        if (NuclearReactorScreen.isIn((int)mouseX, (int)mouseY, this.f_97735_ + 94, this.f_97736_ + 5, 9, 10)) {
            double totalEnergyOutput;
            double maxEnergyOutput;
            int runTime;
            NuclearReactor reactor;
            ArrayList<Component> info;
            block9: {
                info = new ArrayList<Component>();
                reactor = new NuclearReactor(new ItemStack[((NuclearReactorBlockEntity)((NuclearReactorMenu)this.f_97732_).entity).reactor.inputItems.length]);
                reactor.paused = false;
                reactor.simulation = true;
                reactor.heat = ((NuclearReactorMenu)this.f_97732_).data.get(NuclearReactorBlockEntity.HEAT);
                for (int i = 0; i < 54; ++i) {
                    reactor.inputItems[i] = ((NuclearReactorBlockEntity)((NuclearReactorMenu)this.f_97732_).entity).reactor.inputItems[i].m_41720_() instanceof ReactorItem ? ((NuclearReactorBlockEntity)((NuclearReactorMenu)this.f_97732_).entity).reactor.inputItems[i].m_41777_() : ItemStack.f_41583_;
                }
                runTime = 0;
                maxEnergyOutput = 0.0;
                totalEnergyOutput = 0.0;
                do {
                    boolean stop = reactor.tick();
                    ++runTime;
                    maxEnergyOutput = Math.max(maxEnergyOutput, reactor.energyOutput);
                    totalEnergyOutput += reactor.energyOutput;
                    if (stop) break block9;
                } while (runTime < 10000000);
                info.add((Component)Component.m_237113_((String)"Simulation ran for too long!").m_130940_(ChatFormatting.RED));
            }
            if (maxEnergyOutput <= 0.0) {
                info.add((Component)Component.m_237113_((String)"Insert Fuel Rods to check run time!"));
            } else {
                info.add((Component)Component.m_237113_((String)String.format("This reactor will run for %,d s", runTime)));
                if (reactor.heat >= reactor.maxHeat) {
                    info.add((Component)Component.m_237113_((String)("This reactor will explode with " + Mth.m_14165_((double)reactor.explosionRadius) + " block radius")).m_130940_(ChatFormatting.RED));
                } else {
                    info.add((Component)Component.m_237113_((String)"This reactor will not explode").m_130940_(ChatFormatting.GREEN));
                }
                info.add((Component)Component.m_237113_((String)"Max energy generated: ").m_7220_((Component)FTBICUtils.formatEnergy(maxEnergyOutput)).m_130946_("/t"));
                info.add((Component)Component.m_237113_((String)"Total energy generated: ").m_7220_((Component)FTBICUtils.formatEnergy(totalEnergyOutput)));
            }
            this.f_96541_.m_91152_((Screen)new NuclearReactorInfoScreen(this, info));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

