/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import java.util.ArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class NuclearReactor {
    public final ItemStack[] inputItems;
    public boolean paused;
    public boolean allowRedstoneControl;
    public boolean simulation;
    public int heat;
    public double energyOutput;
    public int maxHeat;
    public double explosionModifier;
    public double explosionRadius;

    public NuclearReactor(ItemStack[] is) {
        this.inputItems = is;
        this.paused = true;
        this.allowRedstoneControl = false;
        this.simulation = false;
        this.energyOutput = 0.0;
        this.heat = 0;
    }

    public ItemStack getAt(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return ItemStack.f_41583_;
        }
        return this.inputItems[x + y * 9];
    }

    public void setAt(int x, int y, ItemStack stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        this.inputItems[x + y * 9] = stack;
    }

    public void addHeat(int h) {
        this.heat = Math.max(this.heat + h, 0);
    }

    public void distributeHeat(ItemStack[] around, int heat) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(around.length);
        ItemStack first = ItemStack.f_41583_;
        for (ItemStack stack : around) {
            if (!(stack.m_41720_() instanceof ReactorItem) || !((ReactorItem)stack.m_41720_()).isHeatAcceptor(stack)) continue;
            list.add(stack);
            if (first != ItemStack.f_41583_) continue;
            first = stack;
        }
        if (list.isEmpty()) {
            this.addHeat(heat);
            return;
        }
        for (ItemStack stack : list) {
            ((ReactorItem)stack.m_41720_()).damageReactorItem(stack, heat / list.size());
        }
        ((ReactorItem)first.m_41720_()).damageReactorItem(first, heat % list.size());
    }

    public boolean tick() {
        ReactorItem reactorItem;
        Item item;
        ItemStack stack;
        int y;
        int x;
        this.energyOutput = 0.0;
        this.maxHeat = 10000;
        this.explosionModifier = 1.0;
        this.explosionRadius = (Double)FTBICConfig.NUCLEAR.NUCLEAR_REACTOR_EXPLOSION_BASE_RADIUS.get();
        boolean stopSimulation = true;
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 6; ++y) {
                stack = this.getAt(x, y);
                item = stack.m_41720_();
                if (!(item instanceof ReactorItem)) continue;
                reactorItem = (ReactorItem)item;
                reactorItem.reactorTickPre(this, stack, x, y);
                if (!stack.m_41619_() && !reactorItem.isItemBroken(stack)) continue;
                this.setAt(x, y, ItemStack.f_41583_);
            }
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 6; ++y) {
                stack = this.getAt(x, y);
                item = stack.m_41720_();
                if (!(item instanceof ReactorItem)) continue;
                reactorItem = (ReactorItem)item;
                reactorItem.reactorTickPost(this, stack, x, y);
                if (!stack.m_41619_() && !reactorItem.isItemBroken(stack)) continue;
                this.setAt(x, y, ItemStack.f_41583_);
            }
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 6; ++y) {
                stack = this.getAt(x, y);
                item = stack.m_41720_();
                if (!(item instanceof ReactorItem)) continue;
                reactorItem = (ReactorItem)item;
                if (stack.m_41619_() || reactorItem.isItemBroken(stack)) {
                    this.setAt(x, y, ItemStack.f_41583_);
                    continue;
                }
                if (!this.simulation || !reactorItem.keepSimulationRunning(stack)) continue;
                stopSimulation = false;
            }
        }
        this.heat = Math.max(0, this.heat);
        this.explosionRadius *= this.explosionModifier;
        this.explosionRadius = Math.min(this.explosionRadius, (Double)FTBICConfig.NUCLEAR.NUCLEAR_REACTOR_EXPLOSION_LIMIT.get());
        if (this.heat >= this.maxHeat) {
            stopSimulation = true;
        }
        return stopSimulation;
    }
}

