/*
 * Decompiled with CFR 0.152.
 */
package squeek.wthitharvestability;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.Nullable;
import squeek.wthitharvestability.TooltipHandler;
import squeek.wthitharvestability.helpers.BlockHelper;
import squeek.wthitharvestability.helpers.ColorHelper;
import squeek.wthitharvestability.helpers.OreHelper;
import squeek.wthitharvestability.helpers.StringHelper;
import squeek.wthitharvestability.helpers.ToolHelper;
import squeek.wthitharvestability.helpers.ToolType;

@WailaPlugin(id="wthitharvestability:plugin")
public class WailaHandler
implements IBlockComponentProvider,
IEventListener,
IWailaPlugin {
    private static final ResourceLocation LEVEL = WailaHandler.rl("level.enabled");
    private static final ResourceLocation LEVEL_ITEM = WailaHandler.rl("level.item");
    private static final ResourceLocation LEVEL_SNEAK = WailaHandler.rl("level.sneak");
    private static final ResourceLocation LEVEL_NUM = WailaHandler.rl("level_num.enabled");
    private static final ResourceLocation LEVEL_NUM_SNEAK = WailaHandler.rl("level_num.sneak");
    private static final ResourceLocation HARVESTABLE = WailaHandler.rl("harvestable.enabled");
    private static final ResourceLocation HARVESTABLE_TRUE_STRING = WailaHandler.rl("harvestable.true_string");
    private static final ResourceLocation HARVESTABLE_FALSE_STRING = WailaHandler.rl("harvestable.false_string");
    private static final ResourceLocation HARVESTABLE_SNEAK = WailaHandler.rl("harvestable.sneak");
    private static final ResourceLocation EFFECTIVE_TOOL = WailaHandler.rl("effective_tool.enabled");
    private static final ResourceLocation EFFECTIVE_TOOL_SNEAK = WailaHandler.rl("effective_tool.sneak");
    private static final ResourceLocation SHEARABILITY = WailaHandler.rl("shearability.enabled");
    private static final ResourceLocation SHEARABILITY_STRING = WailaHandler.rl("shearability.string");
    private static final ResourceLocation SHEARABILITY_SNEAK = WailaHandler.rl("shearability.sneak");
    private static final ResourceLocation MINIMAL = WailaHandler.rl("minimal.enabled");
    private static final ResourceLocation MINIMAL_SEPARATOR = WailaHandler.rl("minimal.separator");
    private static final ResourceLocation ORE_ONLY = WailaHandler.rl("ores_only");
    private static final ResourceLocation UNHARVESTABLE_ONLY = WailaHandler.rl("unharvestable_only");
    private static final ResourceLocation TOOL_REQUIRED_ONLY = WailaHandler.rl("tool_required_only");

    @Nullable
    public String getHoveredItemModName(ItemStack stack, IPluginConfig config) {
        TooltipHandler.enableHarvestTooltip = config.getBoolean(LEVEL_ITEM);
        return null;
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        Block stackBlock;
        BlockState state = accessor.getBlockState();
        ItemStack stack = accessor.getStack();
        Player player = accessor.getPlayer();
        if (accessor.getBlock() instanceof InfestedBlock && (stackBlock = Block.m_49814_((Item)stack.m_41720_())) != accessor.getBlock()) {
            state = stackBlock.m_49966_();
        }
        boolean minimalLayout = config.getBoolean(MINIMAL);
        ArrayList<Component> stringParts = new ArrayList<Component>();
        try {
            this.getHarvestability(stringParts, player, state, accessor.getPosition(), config, minimalLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!stringParts.isEmpty()) {
            if (minimalLayout) {
                tooltip.addLine(StringHelper.concatenateStringList(stringParts, ChatFormatting.RESET + config.getString(MINIMAL_SEPARATOR)));
            } else {
                stringParts.forEach(arg_0 -> ((ITooltip)tooltip).addLine(arg_0));
            }
        }
    }

    public void getHarvestability(List<Component> stringList, Player player, BlockState state, BlockPos pos, IPluginConfig config, boolean minimalLayout) {
        boolean isSneaking = player.m_6144_();
        boolean showHarvestLevel = config.getBoolean(LEVEL) && (!config.getBoolean(LEVEL_SNEAK) || isSneaking);
        boolean showHarvestLevelNum = config.getBoolean(LEVEL_NUM) && (!config.getBoolean(LEVEL_NUM_SNEAK) || isSneaking);
        boolean showEffectiveTool = config.getBoolean(EFFECTIVE_TOOL) && (!config.getBoolean(EFFECTIVE_TOOL_SNEAK) || isSneaking);
        boolean showCurrentlyHarvestable = config.getBoolean(HARVESTABLE) && (!config.getBoolean(HARVESTABLE_SNEAK) || isSneaking);
        boolean hideWhileHarvestable = config.getBoolean(UNHARVESTABLE_ONLY);
        boolean showOresOnly = config.getBoolean(ORE_ONLY);
        boolean toolRequiredOnly = config.getBoolean(TOOL_REQUIRED_ONLY);
        if (showHarvestLevel || showEffectiveTool || showCurrentlyHarvestable) {
            String currentlyHarvestable;
            boolean isCurrentlyHarvestable;
            ToolType effectiveTool;
            if (showOresOnly && !OreHelper.isBlockAnOre(state.m_60734_())) {
                return;
            }
            if (BlockHelper.isAdventureModeAndBlockIsUnbreakable(player, pos) || BlockHelper.isBlockUnbreakable(player.f_19853_, pos, state)) {
                MutableComponent unbreakableString = Component.m_237113_((String)ColorHelper.getBooleanColor(false)).m_130946_(config.getString(HARVESTABLE_FALSE_STRING)).m_130946_(" ").m_7220_((Component)(!minimalLayout ? Component.m_237115_((String)"waila.h12y.harvestable").m_130940_(ChatFormatting.RESET) : Component.m_237113_((String)"")));
                stringList.add((Component)unbreakableString);
                return;
            }
            Tier harvestTier = null;
            for (Tier tier : TierSortingRegistry.getSortedTiers()) {
                if (!TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state)) continue;
                harvestTier = tier;
                break;
            }
            if ((effectiveTool = BlockHelper.getEffectiveToolOf(player.f_19853_, pos, state)) == null) {
                harvestTier = null;
            }
            boolean blockHasEffectiveTools = harvestTier != null;
            String shearability = this.getShearabilityString(player, state, pos, config);
            if (toolRequiredOnly && !state.m_60834_() && !blockHasEffectiveTools && shearability.isEmpty()) {
                return;
            }
            boolean canHarvest = false;
            boolean isEffective = false;
            boolean isAboveMinHarvestLevel = false;
            boolean isHoldingTinkersTool = false;
            ItemStack heldStack = player.m_21205_();
            if (!heldStack.m_41619_()) {
                canHarvest = ToolHelper.canToolHarvestBlock(heldStack, state) || !isHoldingTinkersTool && BlockHelper.canHarvestBlock(state, player);
                isAboveMinHarvestLevel = (showCurrentlyHarvestable || showHarvestLevel) && ToolHelper.canToolHarvestLevel(heldStack, harvestTier);
                isEffective = showEffectiveTool && ToolHelper.isToolEffectiveAgainst(heldStack, state, effectiveTool);
            }
            boolean bl = isCurrentlyHarvestable = canHarvest && isAboveMinHarvestLevel || !isHoldingTinkersTool && BlockHelper.canHarvestBlock(state, player);
            if (hideWhileHarvestable && isCurrentlyHarvestable) {
                return;
            }
            Object object = showCurrentlyHarvestable ? ColorHelper.getBooleanColor(isCurrentlyHarvestable) + config.getString(isCurrentlyHarvestable ? HARVESTABLE_TRUE_STRING : HARVESTABLE_FALSE_STRING) + " " + (String)(!minimalLayout ? ChatFormatting.RESET + I18n.m_118938_((String)"waila.h12y.currentlyharvestable", (Object[])new Object[0]) : "") : (currentlyHarvestable = "");
            if (!currentlyHarvestable.isEmpty() || !shearability.isEmpty()) {
                String separator = !shearability.isEmpty() ? " " : "";
                stringList.add((Component)Component.m_237113_((String)(currentlyHarvestable + separator + shearability)));
            }
            if (harvestTier != null && showEffectiveTool) {
                String effectiveToolClass = effectiveTool.toolClass();
                Object effectiveToolString = I18n.m_118936_((String)("waila.h12y.toolclass." + effectiveToolClass)) ? I18n.m_118938_((String)("waila.h12y.toolclass." + effectiveToolClass), (Object[])new Object[0]) : effectiveToolClass.substring(0, 1).toUpperCase() + effectiveToolClass.substring(1);
                stringList.add((Component)Component.m_237115_((String)(!minimalLayout ? "waila.h12y.effectivetool" : "")).m_130946_(" ").m_130946_(ColorHelper.getBooleanColor(isEffective && (!isHoldingTinkersTool || canHarvest), isHoldingTinkersTool && isEffective && !canHarvest) + (String)effectiveToolString));
            }
            if (harvestTier != null && (showHarvestLevel || showHarvestLevelNum)) {
                Object harvestLevelString = "";
                String harvestLevelName = StringHelper.stripFormatting(StringHelper.getHarvestLevelName(harvestTier));
                String harvestLevelNum = String.valueOf(harvestTier.m_6604_());
                boolean bl2 = showHarvestLevelNum = showHarvestLevelNum && (!showHarvestLevel || !harvestLevelName.equals(harvestLevelNum));
                if (showHarvestLevel) {
                    harvestLevelString = harvestLevelName + (String)(showHarvestLevelNum ? " (" + harvestLevelNum + ")" : "");
                } else if (showHarvestLevelNum) {
                    harvestLevelString = harvestLevelNum;
                }
                stringList.add((Component)Component.m_237115_((String)(!minimalLayout ? "waila.h12y.harvestlevel" : "")).m_130946_(" ").m_130946_(ColorHelper.getBooleanColor(isAboveMinHarvestLevel && canHarvest) + (String)harvestLevelString));
            }
        }
    }

    public String getShearabilityString(Player player, BlockState state, BlockPos pos, IPluginConfig config) {
        boolean canBeSheared;
        boolean isSneaking = player.m_6144_();
        boolean showShearability = config.getBoolean(SHEARABILITY) && (!config.getBoolean(SHEARABILITY_SNEAK) || isSneaking);
        boolean isDoublePlant = state.m_60734_() instanceof DoublePlantBlock;
        boolean bl = canBeSheared = state.m_60734_() instanceof IForgeShearable || isDoublePlant;
        if (showShearability && canBeSheared) {
            ItemStack heldStack = player.m_21205_();
            boolean isHoldingShears = !heldStack.m_41619_() && heldStack.m_41720_() instanceof ShearsItem;
            boolean isShearable = isHoldingShears && (isDoublePlant || ((IForgeShearable)state.m_60734_()).isShearable(heldStack, player.f_19853_, pos));
            return ColorHelper.getBooleanColor(isShearable, !isShearable && isHoldingShears) + config.getString(SHEARABILITY_STRING);
        }
        return "";
    }

    private static ResourceLocation rl(String path) {
        return new ResourceLocation("harvestability", path);
    }

    public void register(IRegistrar registrar) {
        registrar.addConfig(MINIMAL, false);
        registrar.addConfig(MINIMAL_SEPARATOR, " : ");
        registrar.addMergedConfig(HARVESTABLE, true);
        registrar.addConfig(HARVESTABLE_TRUE_STRING, "\u2714");
        registrar.addConfig(HARVESTABLE_FALSE_STRING, "\u2718");
        registrar.addConfig(HARVESTABLE_SNEAK, false);
        registrar.addMergedConfig(LEVEL, true);
        registrar.addMergedConfig(LEVEL_ITEM, true);
        registrar.addConfig(LEVEL_SNEAK, false);
        registrar.addConfig(LEVEL_NUM, false);
        registrar.addConfig(LEVEL_NUM_SNEAK, false);
        registrar.addMergedConfig(EFFECTIVE_TOOL, true);
        registrar.addConfig(EFFECTIVE_TOOL_SNEAK, false);
        registrar.addMergedConfig(SHEARABILITY, true);
        registrar.addConfig(SHEARABILITY_STRING, "\u2702");
        registrar.addConfig(SHEARABILITY_SNEAK, false);
        registrar.addConfig(TOOL_REQUIRED_ONLY, true);
        registrar.addConfig(ORE_ONLY, false);
        registrar.addConfig(UNHARVESTABLE_ONLY, false);
        registrar.addComponent((IBlockComponentProvider)this, TooltipPosition.BODY, Block.class);
        registrar.addEventListener((IEventListener)this);
    }
}

