/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public final class WrenchHook {
    private WrenchHook() {
    }

    public static void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = WrenchHook.onPlayerUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static InteractionResult onPlayerUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be;
        if (player.m_5833_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (InteractionUtil.isInAlternateUseMode(player) && InteractionUtil.canWrenchDisassemble(itemStack)) {
            BlockEntity be2 = level.m_7702_(hitResult.m_82425_());
            if (be2 instanceof AEBaseBlockEntity) {
                AEBaseBlockEntity baseBlockEntity = (AEBaseBlockEntity)be2;
                if (!Platform.hasPermissions(new DimensionalBlockPos(level, hitResult.m_82425_()), player)) {
                    return InteractionResult.FAIL;
                }
                return baseBlockEntity.disassembleWithWrench(player, level, hitResult);
            }
        } else if (!InteractionUtil.isInAlternateUseMode(player) && InteractionUtil.canWrenchRotate(itemStack) && (be = level.m_7702_(hitResult.m_82425_())) instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity baseBlockEntity = (AEBaseBlockEntity)be;
            if (!Platform.hasPermissions(new DimensionalBlockPos(level, hitResult.m_82425_()), player)) {
                return InteractionResult.FAIL;
            }
            return baseBlockEntity.rotateWithWrench(player, level, hitResult);
        }
        return InteractionResult.PASS;
    }
}

